'From Smalltalk-80, Version 2.3 of 13 June 1988 on 4 September 1991 at 8:32:24 am'!



!Plan methodsFor: 'interpretation'!

execute
	"Execute my constraints in order."

	Sensor leftShiftDown ifTrue: [Transcript show: '*** executing plan ***'; cr].
	historyVariables do: [:v | v advanceHistory].
	constraints do: 
		[:c | 
		c execute.
		Sensor leftShiftDown ifTrue: [Transcript show: c printString; cr]]! !


!Planner class methodsFor: 'planning/value propagation'!

makePlan: seedConstraints
	"Extract a plan for resatisfaction starting from the given seed constraints, usually a set of input constraints. This method assumes that stay optimization is desired; the plan will contain only constraints whose output variables are not stay. Constraints that do no computation, such as stay and edit constraints, are not included in the plan."
	"Details: The outputs of a constraint are marked when it is added to the plan under construction. A constraint may be appended to the plan when all its input variables are known. A variable is known if either a) the variable is marked (indicating that has been computed by a constraint appearing earlier in the plan), b) the variable is 'stay' (i.e. it is a constant at plan execution time), or c) the variable is not determined by any constraint. The last provision is for past states of history variables, which are not stay but which are also not computed by any constraint."
	"Assume: seedConstraints are all satisfied."

	| todo mark plan hotC out inC |
	todo _ seedConstraints.
	mark _ self newMark.
	plan _ Plan new.
	(todo isEmpty) ifFalse: [hotC _ todo removeFirst].
	[hotC == nil] whileFalse:
		[((hotC output mark ~= mark) and:		"not in plan already and..."
		  [hotC inputsKnown: mark])			"eligible for inclusion"
			ifTrue:
				[
hotC output stay ifFalse: [
				plan append: hotC.
].
				 out _ hotC output.
				 out mark: mark.
				 hotC _ self nextConstraintIn: todo downstreamOf: out]
			ifFalse:
				[(hotC output mark ~= mark) ifTrue:
					["this code backs up in the constraint graph; this is useful when not all the source nodes are easily determined"
					 hotC inputsDo:
						[: inVar |
						 inC _ inVar determinedBy.
						 ((inVar stay) or:
						  [(inC == nil) or:
						  [inVar mark == mark]]) ifFalse:
							[todo addFirst: inC]]].
				 hotC _ (todo isEmpty)
					ifTrue: [nil]
					ifFalse: [todo removeFirst]]].
	^plan finalize! !

InvisiblePointGlyph subclass: #MacDrawDraggerGlyph
	instanceVariableNames: 'exists myDash myFlexiConstraint theScene editConstraints plan '
	classVariableNames: 'CopyConstraint '
	poolDictionaries: ''
	category: 'Minstrel-SIGGRAPH'!


!MacDrawDraggerGlyph methodsFor: 'initialize-release'!

initialize
	self initialize: '?'!

initialize: i
	super initialize.
	exists _ FreeVariable value: true.! !

!MacDrawDraggerGlyph methodsFor: 'accessing'!

dash
	^myDash!

dash: d scene: s 
	myDash _ d.
	theScene _ s!

exists
	^exists!

height
	^y!

isSpare
	^exists value and: [myDash exists value not]!

offset
	^x! !

!MacDrawDraggerGlyph methodsFor: 'glyph protocol'!

displayOn: aDisplayMedium at: aDisplayPoint clip: clipBox 
	| p box |
	exists value
		ifTrue: 
			[self
				vLineFrom: x value @ MacDrawDemo dragTop
				length: MacDrawDemo dragBottom - MacDrawDemo dragTop
				on: aDisplayMedium
				at: aDisplayPoint
				clip: clipBox.
			"box _ MacDrawDemo dragBox.  
			p _ self asPoint - (box width // 2 @ (box height // 2)) + 
			aDisplayPoint.  
			box moveTo: p.  
			aDisplayMedium fill: box mask: Form white.  
			aDisplayMedium border: box width: 1"
			MacDrawDemo draggerBoxForm displayOn: aDisplayMedium at: aDisplayPoint + self asPoint]!

isSelectable
	^exists value!

isVisible
	^true!

locationPoints
	^Array with: self! !

!MacDrawDraggerGlyph methodsFor: 'printing'!

printOn: aStream 
	| title |
	title _ self class name.
	aStream nextPutAll: ((title at: 1) isVowel
							ifTrue: ['an ']
							ifFalse: ['a '])
						, title! !

!MacDrawDraggerGlyph methodsFor: 'mouse'!

handleMouseDown: mousePoint view: view 
	Cursor execute
		showWhile: 
			[editConstraints _ theScene editConstraintsFor: self and: myDash.
			plan _ Planner extractPlanFromInputConstraints: editConstraints.
			view computeBackground]!

handleMouseMove: mousePoint view: view
"MessageTally spyOn: [
1 to: 10 do: [:i |"
	plan execute.
	view displayFeedback
"]]"!

handleMouseUp: mousePoint view: view 
	Cursor execute
		showWhile: 
			[editConstraints do: [:each | each destroyConstraint].
			editConstraints _ nil.
			plan release.
			plan _ nil.
			theScene cleanUpFor: self and: myDash.
			view displayScene]!

wantsMouse
	^true! !

!MacDrawDraggerGlyph methodsFor: 'scene access'!

doDashDraggerAlignDefault: idx 
	"The default alignment is to keep them aligned.  However, if the dash 
	does not exist, then don't bother."

	myFlexiConstraint notNil
		ifTrue: 
			[myFlexiConstraint destroyConstraint.
			myFlexiConstraint _ nil].
	myDash exists value ifTrue: [myFlexiConstraint _ (FlexiEqualityConstraint
					var: myDash right0
					var: self offset
					strength: #default)
					name: idx printString , ':dash right0 = drag offset']!

doDashDraggerAlignMovement: idx 
	"When moving the last dragger, we use a different constraint."

	myFlexiConstraint notNil
		ifTrue: 
			[myFlexiConstraint destroyConstraint.
			myFlexiConstraint _ nil].
	CopyConstraint isNil ifTrue: [CopyConstraint _
			Constraint names: #(a b) methods: #('a _ b')].
	myFlexiConstraint _ ("FlexiEqualityConstraint"
						CopyConstraint copy
				var: self offset
				var: myDash right1
				strength: #required)
				name: idx printString , ':dragger = right1'! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

MacDrawDraggerGlyph class
	instanceVariableNames: ''!


!MacDrawDraggerGlyph class methodsFor: 'classification'!

glyphCategory
	^'SIGGRAPH'! !

!MacDrawDraggerGlyph class methodsFor: 'constraint release'!

releaseConstraints
	"MacDrawDraggerGlyph releaseConstraints"

	CopyConstraint _ nil! !

PointGlyph subclass: #PlanetGlyph
	instanceVariableNames: 'form '
	classVariableNames: 'DefaultForms '
	poolDictionaries: ''
	category: 'Minstrel-SIGGRAPH'!


!PlanetGlyph methodsFor: 'initialize-release'!

initialize
	super initialize.
	form _ Form dotOfSize: 5! !

!PlanetGlyph methodsFor: 'accessing'!

form1
	self form: (DefaultForms at: 1)!

form2
	self form: (DefaultForms at: 2)!

form2b
	self form: (DefaultForms at: 4)!

form3
	self form: (DefaultForms at: 3)!

form: f 
	form _ f.
	form offset: (form width // 2) negated @ (form height // 2) negated! !

!PlanetGlyph methodsFor: 'glyph protocol'!

boundingBox
	| offset |
	offset _ form boundingBox extent // 2.
	offset _ offset x negated @ offset y negated.
	^(form boundingBox copy translateBy: self asPoint)
		translateBy: offset!

containsPoint: aPoint 
	^self boundingBox containsPoint: aPoint!

displayOn: aDisplayMedium at: aDisplayPoint clip: clipBox 
	form
		displayOn: aDisplayMedium
		at: aDisplayPoint x + x value rounded @ (aDisplayPoint y + y value rounded)
		clippingBox: clipBox! !

!PlanetGlyph methodsFor: 'enumeration'!

selectableGlyphsDo: aBlock 
	aBlock value: self.!

visibleGlyphsDo: aBlock 
	aBlock value: self.! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

PlanetGlyph class
	instanceVariableNames: ''!


!PlanetGlyph class methodsFor: 'class initialization'!

initialize
	"PlanetGlyph initialize."

	DefaultForms _ Array new: 4.
	DefaultForms at: 1 put: (Form
			extent: 40 @ 40
			fromArray: #(0 12288 0 1 56704 0 23 30576 0 93 56796 0 119 30582 0 477 56797 0 887 30583 0 1501 56797 49152 1911 30583 24576 3549 56797 49152 6007 30583 28672 7645 56797 53248 14199 30583 28672 7645 56797 55296 30583 30583 29696 24029 56797 56320 30583 30583 29696 24029 56797 56320 30583 30583 29696 56797 56797 56320 30583 30583 30208 24029 56797 56320 30583 30583 29696 24029 56797 56320 30583 30583 29696 7645 56797 55296 14199 30583 28672 7645 56797 55296 6007 30583 28672 7645 56797 53248 1911 30583 24576 1501 56797 49152 887 30583 0 477 56797 0 119 30582 0 29 56792 0 7 30560 0 1 56704 0 0 4096 0 0 0 0 )
			offset: 0 @ 0).
	DefaultForms at: 2 put: (Form
			extent: 30 @ 30
			fromArray: #(2 0 21 16384 170 43008 341 21504 682 43520 1365 21760 2730 43648 5461 21824 10922 43680 5461 21824 10922 43680 21845 21840 10922 43680 21845 21840 43690 43688 21845 21840 10922 43680 21845 21840 10922 43680 5461 21824 10922 43680 5461 21824 2730 43648 1365 21760 682 43520 341 21504 170 43008 21 16384 2 0 0 0 )
			offset: 0 @ 0).
	DefaultForms at: 3 put: (Form
			extent: 20 @ 20
			fromArray: #(64 0 544 0 2184 0 546 0 2184 32768 8738 0 2184 32768 8738 0 2184 32768 8738 8192 2184 32768 8738 0 2184 32768 8738 0 2184 32768 546 0 2184 0 544 0 0 0 0 0 )
			offset: 0 @ 0).
	DefaultForms at: 4 put: (Form
			extent: 30 @ 30
			fromArray: #(2 0 29 49152 375 29696 477 56320 887 30208 3549 56704 6007 30528 7645 56768 14199 30560 7645 56768 14199 30560 24029 56784 30583 30576 24029 56784 30583 30576 24029 56784 30583 30576 24029 56784 30583 30576 7645 56768 14199 30560 7645 56768 6007 30528 1501 56576 1911 30464 477 56320 375 28672 29 49152 2 0 0 0 )
			offset: 0 @ 0)! !

!PlanetGlyph class methodsFor: 'classification'!

glyphCategory
	^'SIGGRAPH'! !

PlanetGlyph initialize!


EqualityConstraint subclass: #FlexiEqualityConstraint
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Minstrel-SIGGRAPH'!


!Scene reorganize!
('initialize-release' initialize)
('accessing' constraintCount viewHeightVar viewWidthVar)
('testing' isAnimated)
('glyphs access' glyphsVar inputGlyphsDo: selectableGlyphsDo: topLevelGlyphs topLevelGlyphsDo: visibleGlyphsDo:)
('glyphs' addGlyph: moveToFront: moveToRear: removeGlyph:)
('selections' clearSelection deselect: select: selected toggleSelect:)
('background processing' backgroundTask: computeBackgroundPlan initialAnimationConstraints)
!



!Scene methodsFor: 'testing'!

isAnimated
	"This message should really be implemented with some other mechanism such as 
	looking at all the constraints and return true if any span time boundries."

	^false! !

!Scene methodsFor: 'background processing'!

backgroundTask: theView 
	"The controller sends this message to the model when nothing else is happening. 
	This allows the model to do background processing to support, for example, a 
	simulation or an animation."

	^self!

computeBackgroundPlan
	"The controller sends this message to the model when it wants to create a plan 
	to animate things when nothing else is going on."

	^nil!

initialAnimationConstraints
	"The controller sends this message to the model when it wants to create a plan 
	to animate things when something is going on."

	^#()! !

Object subclass: #DemoComments
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Minstrel-SIGGRAPH'!

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

DemoComments class
	instanceVariableNames: ''!


!DemoComments class methodsFor: 'instance creation'!

from: aClass 
	| topView holder view |
	topView _ SpecialSystemView
				model: nil
				label: 'Demonstration Information'
				minimumSize: aClass infoSize.
	holder _ StringHolder new initialize.
	holder contents: aClass comment.
	view _ StringHolderView container: holder.
	topView borderWidth: 1; addSubView: view.
	topView controller open! !


!BasicRectangleGlyph methodsFor: 'accessing'!

asRectangle
	^left value @ top value corner: right value @ bottom value!

bottomLeft
	^left value @ bottom value!

bottomRight
	^right value @ bottom value!

center
	^center!

corner
	^self bottomRight!

extent
	^self width @ self height!

origin
	^self topLeft!

topLeft
	^left value @ top value!

topRight
	^right value @ top value! !

Scene subclass: #CFKDemo
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Minstrel-SIGGRAPH'!
CFKDemo comment:
'						***** Introducing Constraints (Celsius-Fahrenheit-Kelvin) *****

Just as a database demo is not complete with the Employee relation and a graphics demo is not complete without rendering a teapot, a constraint demo is not complete with the Celsius-Fahrenheit example.

Constraints are multi-directional, automatically-maintained assertions about the state of a system.  For example, the relation between Celsius and Fahrenheit temperatures is a constraint.  Constraints are often stated as equations, but other mechanism are both possible and are used in these demos.

This demo uses many different types of constraints: arithmetic constraints to maintain the relation between the different interpretations of temperature; layout constraints to keep the title under each thermometer, the equations between the thermometers, and the number beside the mercury; and consistency constraints to keep the mercury height proportional to the temperature which in turn is equal to the text printed beside it.  Last, but not least, special graphical constraints are used to control the display when the temperature gets too cold or too hot (Try 10 Kelvin or 200 Celsius!!).  Yes, the entire demo is composed of many smaller objects working together, synchronized and kept consistent with constraints.

Interesting actions to try are: (1) moving the mercury up and down, (2) selecting and then entering a temperature directly (use <delete> and the number keys), (3) switching to "edit" mode and rearranging the thermometers (press the mouse button on the title bar to get a menu which includes "edit".  Use the same menu to return to "operate").
'!


!CFKDemo methodsFor: 'initialize-release'!

create
	| c f k c1 tc tf tk tcf tck mpc |
	Transcript cr; show: 'Building the ', self class name, '..'.
	Transcript cr; show: '..adding the Fahrenheit thermometer'.
	f _ ThermometerGlyph new initialize.
	f moveTo: 50 @ 160.
	f overVal: 752.0 underVal: -184.0.
	self addGlyph: f.
	Transcript cr; show: '..adding the Celsius thermometer'.
	c _ ThermometerGlyph new initialize.
	c moveTo: 250 @ 160.
	c overVal: 400.0 underVal: -120.0.
	self addGlyph: c.
	Transcript cr; show: '..adding the Kelvin thermometer'.
	k _ ThermometerGlyph new initialize.
	k moveTo: 450 @ 160.
	k minVal: 0.
	k maxVal: 400.
	k overVal: 450.0 underVal: -1.0.
	self addGlyph: k.
	Transcript cr; show: '..adding the consistency constraints'.
	c1 _ Constraint names: #(c f ) methods: #('c _ (f - 32.0) / 1.8' 'f _ (c * 1.8) + 32' ).
	c1
		var: c temperatureVar
		var: f temperatureVar
		strength: #required.
	c1 _ Constraint names: #(c k ) methods: #('c _ k - 273.16' 'k _ c + 273.16' ).
	c1
		var: c temperatureVar
		var: k temperatureVar
		strength: #required.
	Transcript cr; show: '..adding the text boxes'.
	tc _ TextGlyph new initialize.
	tc text: 'Celsius'.
	self addGlyph: tc.
	tf _ TextGlyph new initialize.
	tf text: 'Fahrenheit'.
	self addGlyph: tf.
	tk _ TextGlyph new initialize.
	tk text: 'Kelvin'.
	self addGlyph: tk.
	tcf _ TwoProngTextGlyph new initialize.
	tcf moveTo: 150 @ 325.
	tcf
		left: f editBox rightVar @ f editBox bottomVar
		right: c editBox leftVar @ c editBox bottomVar
		string: 'c * 1.8 = f - 32'.
	self addGlyph: tcf.
	tck _ TwoProngTextGlyph new initialize.
	tck moveTo: 350 @ 325.
	tck
		left: c editBox rightVar @ c editBox bottomVar
		right: k editBox leftVar @ k editBox bottomVar
		string: 'k = c + 273.16'.
	self addGlyph: tck.
	Transcript cr; show: '..adding the layout constraints'.
	EqualityConstraint
		var: c editBox center xVar
		var: tc box center xVar
		strength: #required.
	OffsetConstraint
		from: c editBox bottomVar
		to: tc box topVar
		require: 30.
	EqualityConstraint
		var: f editBox center xVar
		var: tf box center xVar
		strength: #required.
	OffsetConstraint
		from: f editBox bottomVar
		to: tf box topVar
		require: 30.
	EqualityConstraint
		var: k editBox center xVar
		var: tk box center xVar
		strength: #required.
	OffsetConstraint
		from: k editBox bottomVar
		to: tk box topVar
		require: 30.
	Transcript cr; show: 'finished'!

create1
	| c f k c1 |
	c _ ThermometerGlyph new initialize.
	c moveTo: 30 @ 160.
	f _ ThermometerGlyph new initialize.
	f moveTo: 90 @ 160.
	k _ ThermometerGlyph new initialize.
	k moveTo: 150 @ 160.
	k minVal: 0.
	k maxVal: 400.
	self addGlyph: c; addGlyph: f; addGlyph: k.
	c1 _ Constraint names: #(c f ) methods: #('c _ (f - 32.0) / 1.8' 'f _ (c * 1.8) + 32' ).
	c1
		var: c temperatureVar
		var: f temperatureVar
		strength: #required.
	c1 _ Constraint names: #(c k ) methods: #('c _ k - 273.16' 'k _ c + 273.16' ).
	c1
		var: c temperatureVar
		var: k temperatureVar
		strength: #required!

create2
	| c f k c1 tc tf tk tcf tck mpc |
	Transcript cr; show: 'Building the CFKDemo..'.
	Transcript cr; show: '..adding the Fahrenheit thermometer'.
	f _ ThermometerGlyph new initialize.
	f moveTo: 50 @ 160.
	self addGlyph: f.
	Transcript cr; show: '..adding the Celsius thermometer'.
	c _ ThermometerGlyph new initialize.
	c moveTo: 250 @ 160.
	self addGlyph: c.
	Transcript cr; show: '..adding the Kelvin thermometer'.
	k _ ThermometerGlyph new initialize.
	k moveTo: 450 @ 160.
	k minVal: 0.
	k maxVal: 400.
	self addGlyph: k.
	Transcript cr; show: '..adding the consistency constraints'.
	c1 _ Constraint names: #(c f ) methods: #('c _ (f - 32.0) / 1.8' 'f _ (c * 1.8) + 32' ).
	c1
		var: c temperatureVar
		var: f temperatureVar
		strength: #required.
	c1 _ Constraint names: #(c k ) methods: #('c _ k - 273.16' 'k _ c + 273.16' ).
	c1
		var: c temperatureVar
		var: k temperatureVar
		strength: #required.
	Transcript cr; show: '..adding the text boxes'.
	tc _ TextGlyph new initialize.
	tc text: 'Celsius'.
	self addGlyph: tc.
	tf _ TextGlyph new initialize.
	tf text: 'Fahrenheit'.
	self addGlyph: tf.
	tk _ TextGlyph new initialize.
	tk text: 'Kelvin'.
	self addGlyph: tk.
	tcf _ TextGlyph new initialize.
	tcf text: 'c * 1.8 = f - 32'.
	tcf moveTo: 150@160.
	self addGlyph: tcf.
	tck _ TextGlyph new initialize.
	tck text: 'k = c + 273.16'.
	tck moveTo: 350@160.
	self addGlyph: tck.
	Transcript cr; show: '..adding the layout constraints'.
	EqualityConstraint
		var: c editBox center xVar
		var: tc box center xVar
		strength: #required.
	OffsetConstraint
		from: c editBox bottomVar
		to: tc box topVar
		require: 30.
	EqualityConstraint
		var: f editBox center xVar
		var: tf box center xVar
		strength: #required.
	OffsetConstraint
		from: f editBox bottomVar
		to: tf box topVar
		require: 30.
	EqualityConstraint
		var: k editBox center xVar
		var: tk box center xVar
		strength: #required.
	OffsetConstraint
		from: k editBox bottomVar
		to: tk box topVar
		require: 30.
	mpc _ Constraint names: #(p1 mp p2 ) methods: #('mp _ (p1 + p2) / 2' 'p1 _ mp*2 - p2' 'p2 _ mp*2 - p1' ).
	mpc copy
		var: c editBox bottomVar
		var: tcf box bottomVar
		var: f editBox bottomVar
		strength: #required.
	mpc copy
		var: c editBox leftVar
		var: tcf box leftVar
		var: f editBox leftVar
		strength: #required.
	mpc copy
		var: c editBox bottomVar
		var: tck box bottomVar
		var: k editBox bottomVar
		strength: #required.
	mpc copy
		var: c editBox leftVar
		var: tck box leftVar
		var: k editBox leftVar
		strength: #required.
	StayConstraint var: c editBox leftVar strength: #default.
	StayConstraint var: f editBox leftVar strength: #default.
	StayConstraint var: k editBox leftVar strength: #default.
	StayConstraint var: c editBox bottomVar strength: #default.
	StayConstraint var: f editBox bottomVar strength: #default.
	StayConstraint var: k editBox bottomVar strength: #default.
	Transcript cr; show: 'finished'!

create3
	| c f k c1 tc tf tk tcf tck mpc |
	Transcript cr; show: 'Building the CFKDemo..'.
	Transcript cr; show: '..adding the Fahrenheit thermometer'.
	f _ ThermometerGlyph new initialize.
	f moveTo: 50 @ 160.
	self addGlyph: f.
	Transcript cr; show: '..adding the Celsius thermometer'.
	c _ ThermometerGlyph new initialize.
	c moveTo: 250 @ 160.
	self addGlyph: c.
	Transcript cr; show: '..adding the Kelvin thermometer'.
	k _ ThermometerGlyph new initialize.
	k moveTo: 450 @ 160.
	k minVal: 0.
	k maxVal: 400.
	self addGlyph: k.
	Transcript cr; show: '..adding the consistency constraints'.
	c1 _ Constraint names: #(c f ) methods: #('c _ (f - 32.0) / 1.8' 'f _ (c * 1.8) + 32' ).
	c1
		var: c temperatureVar
		var: f temperatureVar
		strength: #required.
	c1 _ Constraint names: #(c k ) methods: #('c _ k - 273.16' 'k _ c + 273.16' ).
	c1
		var: c temperatureVar
		var: k temperatureVar
		strength: #required.
	Transcript cr; show: '..adding the text boxes'.
	tc _ TextGlyph new initialize.
	tc text: 'Celsius'.
	self addGlyph: tc.
	tf _ TextGlyph new initialize.
	tf text: 'Fahrenheit'.
	self addGlyph: tf.
	tk _ TextGlyph new initialize.
	tk text: 'Kelvin'.
	self addGlyph: tk.
	tcf _ TextGlyph new initialize.
	tcf text: 'c * 1.8 = f - 32'.
	tcf moveTo: 150@260.
	self addGlyph: tcf.
	tck _ TextGlyph new initialize.
	tck text: 'k = c + 273.16'.
	tck moveTo: 350@260.
	self addGlyph: tck.
	Transcript cr; show: '..adding the layout constraints'.
	EqualityConstraint
		var: c editBox center xVar
		var: tc box center xVar
		strength: #required.
	OffsetConstraint
		from: c editBox bottomVar
		to: tc box topVar
		require: 30.
	EqualityConstraint
		var: f editBox center xVar
		var: tf box center xVar
		strength: #required.
	OffsetConstraint
		from: f editBox bottomVar
		to: tf box topVar
		require: 30.
	EqualityConstraint
		var: k editBox center xVar
		var: tk box center xVar
		strength: #required.
	OffsetConstraint
		from: k editBox bottomVar
		to: tk box topVar
		require: 30.
	StayConstraint var: c editBox leftVar strength: #default.
	StayConstraint var: f editBox leftVar strength: #default.
	StayConstraint var: k editBox leftVar strength: #default.
	StayConstraint var: c editBox bottomVar strength: #default.
	StayConstraint var: f editBox bottomVar strength: #default.
	StayConstraint var: k editBox bottomVar strength: #default.
	mpc _ Constraint names: #(p1 mp p2 ) methods: #('mp _ (p1 + p2) / 2' 'p1 _ mp*2 - p2' 'p2 _ mp*2 - p1' ).
	mpc copy
		var: c editBox bottomVar
		var: tcf box bottomVar
		var: f editBox bottomVar
		strength: #required.
	mpc copy
		var: c editBox leftVar
		var: tcf box leftVar
		var: f editBox leftVar
		strength: #required.
	mpc copy
		var: c editBox bottomVar
		var: tck box bottomVar
		var: k editBox bottomVar
		strength: #required.
	mpc copy
		var: c editBox leftVar
		var: tck box leftVar
		var: k editBox leftVar
		strength: #required.
	Transcript cr; show: 'finished'!

initialize
	super initialize.
	self create! !

!CFKDemo methodsFor: 'public'!

open
	"CFKDemo new open"

	| topView |
	topView _ SpecialSystemView
				model: nil
				label: 'Fahrenheit - Celsius - Kelvin Demo'
				minimumSize: 525 @ 400.
	topView borderWidth: 1; addSubView: (SceneView new initialize model: self).
	topView controller open! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

CFKDemo class
	instanceVariableNames: ''!


!CFKDemo class methodsFor: 'access'!

infoSize
	^700@310! !

Scene subclass: #AnchorLine1Demo
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Minstrel-SIGGRAPH'!
AnchorLine1Demo comment:
'										***** What is a Constraint Hierarchy? (Anchors and Mice) *****

A constraint hierarchy is an ordered sequence of sets of constraints such that the constraints in the stronger sets dominate those in the weaker sets.  For example, if "X = 5" is strong and "X = 3" is weak, the solution would be "X = 5".  The strongest set in a constraint hierarchy is the required level: these constraints must be satisified.  All other levels are preferred and should be satisfied (respecting their various strengths) may be violated if necessary.

These three examples demonstrate different constraint hierarchies.  In the no-anchor example, the only constraints are the "horizontal line" constraint and (when the mouse drags a point) the "mouse drags point" constraint.  (Note: all interactions are implemented using constraints, thus the connection between the mouse and the point it is dragging is actually a constraint.)  In the anchor example, there is a strong "anchor" constraint which holds the left point in place.  This anchor constraint is stronger than the mouse constraint, and thus the mouse cannot move the left end and it can only move the right end back and forth.  In the anchor-strong-mouse example, the mouse has been made stronger than the anchor and thus the mouse can drag the anchor around again.

To summarize, the three examples have the following constraint hierarchies:
		* no-anchor *								* anchor *								* anchor-strong-mouse *
	required horizontal line						required horizontal line						required horizontal line
	medium mouse								strong anchor								veryStrong mouse
												medium mouse								strong anchor
'!


!AnchorLine1Demo methodsFor: 'initialize-release'!

create
	| l |
	Transcript cr; show: 'Building the ' , self class name , '..'.
	Transcript cr; show: '..adding the components'.
	l _ LineGlyph new.
	l moveTo: 100 @ 100.
	self addGlyph: l.
	Transcript cr; show: '..adding the consistency constraints'.
	EqualityConstraint
		var: l p1 yVar
		var: l p2 yVar
		strength: #required.
	Transcript cr; show: 'finished'!

initialize
	super initialize.
	self create! !

!AnchorLine1Demo methodsFor: 'public'!

open
	"AnchorLine1Demo new open"

	| topView |
	topView _ SpecialSystemView
				model: nil
				label: 'Horizontal Line, No Anchor'
				minimumSize: 300 @ 200.
	topView borderWidth: 1; addSubView: (SceneView new initialize model: self).
	topView controller open! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

AnchorLine1Demo class
	instanceVariableNames: ''!


!AnchorLine1Demo class methodsFor: 'access'!

infoSize
	^900@270! !

SceneView subclass: #MacDrawDemoView
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Minstrel-SIGGRAPH'!


!MacDrawDemoView methodsFor: 'controller access'!

defaultControllerClass
	^MacDrawDemoController! !


!FreeVariable methodsFor: 'access'!

speciallast
	"Turn myself into a HistoryVariable and then return my previous state variable."

	| newSelf newLast |
	newSelf _ HistoryVariable value: value.
	newLast _ newSelf speciallast.
	self become: newSelf.
	^newLast! !

Glyph subclass: #MacDrawRulerGlyph
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Minstrel-SIGGRAPH'!


!MacDrawRulerGlyph methodsFor: 'glyph protocol'!

displayOn: aDisplayMedium at: aDisplayPoint clip: clipBox 
	| left right bottom littles |
	left _ MacDrawDemo leftEdge.
	right _ MacDrawDemo rightEdge.
	bottom _ MacDrawDemo dragTop - 20.
	littles _ Array
				with: (Array with: 12.5 with: bottom - 5)
				with: (Array with: 25 with: bottom - 10)
				with: (Array with: 100 with: bottom - 25).
	self
		hLineFrom: left @ bottom
		length: right - left
		on: aDisplayMedium
		at: aDisplayPoint
		clip: clipBox.
	littles do: [:each | left
			to: right
			by: (each at: 1)
			do: [:x | self
					vLineFrom: x @ (each at: 2)
					length: bottom - (each at: 2)
					on: aDisplayMedium
					at: aDisplayPoint
					clip: clipBox]]!

isSelectable
	^false!

locationPoints
	^Array with: MacDrawDemo leftEdge @ MacDrawDemo dragTop! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

MacDrawRulerGlyph class
	instanceVariableNames: ''!


!MacDrawRulerGlyph class methodsFor: 'classification'!

glyphCategory
	^'SIGGRAPH'! !


!VectorGlyph methodsFor: 'initialize-release'!

addConstraints

	(ArrowC isNil) ifTrue:
		[ArrowC _ Constraint
			names: #(vector p1 p2)
			methods: #('vector _ p2 - p1')].
	(DirectionC isNil) ifTrue:
		[DirectionC _ Constraint
			names: #(p1 p2 oldP1 oldP2)
			methods: #('p2 _ p1 + (oldP2 - oldP1)')].

	"constraints to attach and align arrow head"
	(p2 xVar) requireEquals: (arrowHead location xVar).
	(p2 yVar) requireEquals: (arrowHead location yVar).
	(ArrowC copy) var: (arrowHead vector xVar) var: (p1 xVar) var: (p2 xVar) strength: #required.
	(ArrowC copy) var: (arrowHead vector yVar) var: (p1 yVar) var: (p2 yVar) strength: #required.

	"constraints to maintain vector length and direction when moving p1"
	(DirectionC copy)
		var: (p1 xVar) var: (p2 xVar)
		var: (p1 xVar last) var: (p2 xVar last) strength: #default.
	(DirectionC copy)
		var: (p1 yVar) var: (p2 yVar)
		var: (p1 yVar last) var: (p2 yVar last) strength: #default.! !

Scene subclass: #AnchorLine3Demo
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Minstrel-SIGGRAPH'!


!AnchorLine3Demo methodsFor: 'initialize-release'!

create
	| l f |
	Transcript cr; show: 'Building the ' , self class name , '..'.
	Transcript cr; show: '..adding the components'.
	f _ SIGGRAPHAnchorGlyph new initialize.
	l _ LineGlyph new.
	l moveTo: 100 @ 100.
	self addGlyph: f; addGlyph: l.
	Transcript cr; show: '..adding the consistency constraints'.
	EqualityConstraint
		var: l p1 yVar
		var: l p2 yVar
		strength: #required.
	EqualityConstraint
		var: l p1 xVar
		var: f xVar
		strength: #required.
	EqualityConstraint
		var: l p1 yVar
		var: f yVar
		strength: #required.
	StayConstraint var: f xVar strength: #default.
	StayConstraint var: f yVar strength: #default.
	Transcript cr; show: 'finished'!

initialize
	super initialize.
	self create! !

!AnchorLine3Demo methodsFor: 'public'!

open
	"AnchorLine3Demo new open"

	| topView |
	topView _ SpecialSystemView
				model: nil
				label: 'Horizontal Line, Anchor, Strong Mouse'
				minimumSize: 300 @ 200.
	topView borderWidth: 1; addSubView: (SceneView new initialize model: self).
	topView controller open! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

AnchorLine3Demo class
	instanceVariableNames: ''!



!HistoryVariable methodsFor: 'history'!

speciallast
	"Answer the DBVariable for my previous state. If there isn't one yet, create one and remember it."

	(last == nil) ifTrue:
		[last _ HistoryVariable value: value.
		 last walkStrength: Strength absoluteWeakest.
		 last stay: false].
	^last! !

Scene subclass: #Plus1Demo
	instanceVariableNames: 'values '
	classVariableNames: 'PlusConstraint PrintConstraint '
	poolDictionaries: ''
	category: 'Minstrel-SIGGRAPH'!
Plus1Demo comment:
'								***** Why use Constraint Hierarchies? (Sums) *****

Constraint hierarchies are useful for many parts of a software system including: (i) as a declarative specification for defaults, (ii) as a mechanism to describe the behavior of a graphical user interface, and (iii) as a mechanism for declaratively controlling the dataflow.  Typically, to control the flow of data in a "flat" constraint system one must use some operational features.  For example, many constraint system use a well-defined search mechanism and thus the user can write his or her rules to take advantage of that mechanism to control the dataflow, i.e., he or she can use non-declarative features.  Of course, if the system is improved and the search algorithm changes, the program no longer works correctly.  One of the benefits of using a constraint hierarchy is that the hierarchy can control the dataflow declaratively.

The no-hierarchy demo has a flat constraint system and just a little experimentation will illustrate that its behavior is difficult to predict.  Specifically, the data does not flow from left-to-right as one might expect.  The hierarchy demo uses constraints of different strengths to cause the "correct" dataflow.  Furthermore, any constraint hierarchy solver will produce exactly the same solutions for this second demo, regardless of its implementation (assuming, of course, that the solver is implemented correctly.)
'!


!Plus1Demo methodsFor: 'initialize-release'!

create
	"Plus1Demo releaseConstraints"

	| texts xs ys ps |
	Transcript cr; show: 'Building the ' , self class name , '..'.
	Transcript cr; show: '..adding the components'.
	values _ Array new: 7.
	1 to: values size do: [:i | values at: i put: (FreeVariable value: 10)].
	texts _ Array new: values size.
	1 to: values size do: [:i | texts at: i put: BoxTextGlyph new].
	xs _ #(50 50 150 150 250 250 350 ).
	ys _ #(50 150 100 200 150 250 200 ).
	ps _ OrderedCollection new.
	xs with: ys do: [:x :y | ps add: x @ y].
	texts with: ps do: 
		[:text :p | 
		text moveTo: p].
	xs _ #(100 200 300 ).
	ys _ #(100 150 200 ).
	1
		to: 5
		by: 2
		do: 
			[:i | 
			p _ ThreeProngTextGlyph new initialize.
			p
				left: (texts at: i) center
				right: (texts at: i + 2) center
				down: (texts at: i + 1) center
				string: '+'.
			self addGlyph: p].
	texts do: [:each | self addGlyph: each].
	Transcript cr; show: '..adding the consistency constraints'.
	PrintConstraint isNil ifTrue: [PrintConstraint _ Constraint names: #(text temp ) methods: #('temp _ text asNumber' 'text _ temp printString' )].
	texts with: values do: [:text :value | PrintConstraint copy
			var: text textVar
			var: value
			strength: #required].
	PlusConstraint isNil ifTrue: [PlusConstraint _ Constraint names: #(a b c ) methods: #('c _ a + b' 'a _ c - b' 'b _ c - a' )].
	1
		to: 5
		by: 2
		do: [:i | PlusConstraint copy
				var: (values at: i)
				var: (values at: i + 1)
				var: (values at: i + 2)
				strength: #required].
	self createDefaults.
	Transcript cr; show: 'finished'!

createDefaults!

initialize
	super initialize.
	self create! !

!Plus1Demo methodsFor: 'public'!

open
	"Plus1Demo new open"

	| topView |
	topView _ SpecialSystemView
				model: nil
				label: 'Plus Demo, No Hierarchy'
				minimumSize: 400 @ 300.
	topView borderWidth: 1; addSubView: (SceneView new initialize model: self).
	topView controller open! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

Plus1Demo class
	instanceVariableNames: ''!


!Plus1Demo class methodsFor: 'constraint release'!

releaseConstraints
	"Plus1Demo releaseConstraints"

	PrintConstraint _ PlusConstraint _ nil! !

!Plus1Demo class methodsFor: 'access'!

infoSize
	^700@250! !
PointGlyph subclass: #AnchorGlyph
	instanceVariableNames: 'node anchorForm '
	classVariableNames: 'AnchorForm '
	poolDictionaries: ''
	category: 'Minstrel-Springs Demo'!
Object subclass: #AbstractConstraint
	instanceVariableNames: 'strength name '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'DB-Constraints'!


!AbstractConstraint methodsFor: 'accessing'!

name: n
	name _ n! !

!AbstractConstraint methodsFor: 'printing'!

longPrintOn: aStream

	| bindings |
	aStream nextPut: $(.
	self shortPrintOn: aStream.
	aStream space; nextPutAll: self strength printString.
	(self isSatisfied)
		ifTrue:
			[aStream cr; space; space; space.
			 self inputsDo:
				[: in | aStream nextPutAll: 'v', in asOop printString, '(', in value printString, ') '].
			aStream nextPutAll: '-> '.
			aStream nextPutAll: 'v', self output asOop printString, '(', self output value printString, ')']
		ifFalse:
			[aStream space; nextPutAll: 'UNSATISFIED'].
	aStream nextPut: $)!

shortPrintOn: aStream

	aStream nextPutAll: self class name.
	aStream nextPutAll: '(', self asOop printString.
	name notNil ifTrue: [aStream nextPutAll: ' "', name, '"'].
	aStream nextPut: $)! !

ScriptGlyph subclass: #ThreeProngTextGlyph
	instanceVariableNames: 'textGlyph left right down offset '
	classVariableNames: 'CenterOffsetConstraint '
	poolDictionaries: ''
	category: 'Minstrel-SIGGRAPH'!


!ThreeProngTextGlyph methodsFor: 'initialize-release'!

initialize
	"ThreeProngTextGlyph releaseConstraints"

	super initialize.
	textGlyph _ TextGlyph new initialize.
	left _ PointGlyph new initialize.
	right _ PointGlyph new initialize.
	down _ PointGlyph new initialize.
	left moveTo: 10 @ 10.
	right moveTo: 100 @ 10.
	down moveTo: 45@ 50.
	textGlyph moveTo: 40 @ 15.
	offset _ PointGlyph new initialize.
	offset moveTo: 0 @ 8.
	CenterOffsetConstraint isNil ifTrue: [CenterOffsetConstraint _ (Constraint names: #(out left right down off ) methods: #('out _ ((left + right + down) // 3) - off' 'off _ ((left + right + down) // 3) - out' ))
					name: 'center offset'].
	StayConstraint
		var: offset xVar
		strength: #default.
	CenterOffsetConstraint copy
		var: textGlyph box leftVar
		var: left xVar
		var: right xVar
		var: down xVar
		var: offset xVar
		strength: #required.
	StayConstraint
		var: offset yVar
		strength: #default.
	CenterOffsetConstraint copy
		var: textGlyph box topVar
		var: left yVar
		var: right yVar
		var: down yVar
		var: offset yVar
		strength: #required!

left: l right: r down: d string: s
	| stays |  
	stays _ Set new.
	stays add: (StayConstraint
		var: "textGlyph box leftVar" offset xVar
		strength: #strongPreferred).
	stays add: (StayConstraint
		var: "textGlyph box topVar" offset yVar
		strength: #strongPreferred).
	stays add: (StayConstraint
		var: l xVar
		strength: #strongPreferred).
	stays add: (StayConstraint
		var: l yVar
		strength: #strongPreferred).
	stays add: (StayConstraint
		var: r xVar
		strength: #strongPreferred).
	stays add: (StayConstraint
		var: r yVar
		strength: #strongPreferred).
	stays add: (StayConstraint
		var: d xVar
		strength: #strongPreferred).
	stays add: (StayConstraint
		var: d yVar
		strength: #strongPreferred).
	EqualityConstraint
		var: l xVar
		var: left xVar
		strength: #required.
	EqualityConstraint
		var: l yVar
		var: left yVar
		strength: #required.
	EqualityConstraint
		var: r xVar
		var: right xVar
		strength: #required.
	EqualityConstraint
		var: r yVar
		var: right yVar
		strength: #required.
	EqualityConstraint
		var: d xVar
		var: down xVar
		strength: #required.
	EqualityConstraint
		var: d yVar
		var: down yVar
		strength: #required.
	stays do: [:each | each destroyConstraint].
	textGlyph text: s! !

!ThreeProngTextGlyph methodsFor: 'access'!

offset: p
	offset xVar value: p x.
	offset yVar value: p y! !

!ThreeProngTextGlyph methodsFor: 'glyph protocol'!

boundingBox
	^textGlyph boundingBox!

displayOn: aDisplayMedium at: aDisplayPoint clip: clipBox 
	| r |
	r _ textGlyph box asRectangle moveBy: aDisplayPoint.
	(Line
		from: left asPoint
		to: r left @ r top
		withForm: (Form extent: 1 @ 1) black)
		displayOn: aDisplayMedium
		at: aDisplayPoint.
	(Line
		from: right asPoint
		to: r right @ r center y
		withForm: (Form extent: 1 @ 1) black)
		displayOn: aDisplayMedium
		at: aDisplayPoint.
	(Line
		from: down asPoint
		to: r left @ r bottom
		withForm: (Form extent: 1 @ 1) black)
		displayOn: aDisplayMedium
		at: aDisplayPoint.
	aDisplayMedium fill: (r insetBy: -1 @ -1) mask: Form white.
	textGlyph
		displayOn: aDisplayMedium
		at: aDisplayPoint
		clip: clipBox.
	aDisplayMedium border: (r insetBy: -3 @ -3)
		width: 2 mask: Form gray.
	false ifTrue: [self stilltodo]!

isSelectable
	^true!

locationPoints
	^Array
		with: textGlyph box center"
		with: left asPoint
		with: right asPoint
		with: down asPoint"! !

!ThreeProngTextGlyph methodsFor: 'enumeration'!

selectableGlyphsDo: aBlock 
	aBlock value: self.
	aBlock value: textGlyph.
"aBlock value: left.
aBlock value: right.
aBlock value: down"!

visibleGlyphsDo: aBlock 
	aBlock value: self.
	aBlock value: textGlyph! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

ThreeProngTextGlyph class
	instanceVariableNames: ''!


!ThreeProngTextGlyph class methodsFor: 'classification'!

glyphCategory
	^'SIGGRAPH'! !

!ThreeProngTextGlyph class methodsFor: 'constraint release'!

releaseConstraints
	"ThreeProngTextGlyph releaseConstraints"

	CenterOffsetConstraint _ nil! !

ScriptGlyph subclass: #ThermometerGlyph
	instanceVariableNames: 'temperature minVal maxVal overVal over underVal under editBox mercury textGlyph editConstraint editConstraint2 plan prevY '
	classVariableNames: 'BulbForm BulbForm2 CapForm MercConstraint OverConstraint PrintConstraint UnderConstraint '
	poolDictionaries: ''
	category: 'Minstrel-SIGGRAPH'!


!ThermometerGlyph methodsFor: 'initialize-release'!

initialize
	super initialize.
	editBox _ (RectangleGlyph new) width: 20; height: 200.
	minVal _ FreeVariable value: -100.0.
	underVal _ FreeVariable value: -120.0.
	maxVal _ FreeVariable value: 300.0.
	overVal _ FreeVariable value: 320.0.
	temperature _ FreeVariable value: 0.
	over _ FreeVariable value: false.
	under _ FreeVariable value: false.
	mercury _ PointGlyph new initialize.
	mercury moveTo: editBox center asPoint + editBox width asPoint.
	textGlyph _ TextGlyph new initialize.
	PrintConstraint isNil ifTrue: [PrintConstraint _ Constraint names: #(text temp ) methods: #('text _ temp printString' 'temp _ text asNumber' )].
	PrintConstraint copy
		var: textGlyph textVar
		var: temperature
		strength: #required.
	EqualityConstraint
		var: mercury yVar
		var: textGlyph box bottomVar
		strength: #required.
	"EqualityConstraint  
	var: mercury xVar  
	var: textGlyph box leftVar  
	strength: #required."
	EqualityConstraint
		var: editBox rightVar
		var: textGlyph box leftVar
		strength: #required.
	MercConstraint isNil ifTrue: [MercConstraint _ Constraint names: #(boxh boxt merc min max temp ) methods: #('merc _ ThermometerGlyph internalMsg1: min and: max and: temp and: boxh and: boxt' )].
	MercConstraint copy
		var: editBox heightVar
		var: editBox topVar
		var: mercury yVar
		var: minVal
		var: maxVal
		var: temperature
		strength: #required.
	OverConstraint isNil ifTrue: [OverConstraint _ Constraint names: #(temp over overval ) methods: #('over _ ThermometerGlyph internalMsg2: temp and: overval' )].
	OverConstraint copy
		var: temperature
		var: over
		var: overVal
		strength: #required.
	UnderConstraint isNil ifTrue: [UnderConstraint _ Constraint names: #(temp under underval ) methods: #('under _ ThermometerGlyph internalMsg3: temp and: underval' )].
	UnderConstraint copy
		var: temperature
		var: under
		var: underVal
		strength: #required! !

!ThermometerGlyph methodsFor: 'accessing'!

editBox
	^editBox!

maxVal: aNumber 
	maxVal setValue: aNumber!

minVal: aNumber 
	minVal setValue: aNumber!

overVal: n underVal: m 
	overVal value: n.
	underVal value: m!

temperature

	^temperature value!

temperature: aNumber

	temperature setValue: ((aNumber max: minVal value) min: maxVal value).!

temperatureVar
	^temperature! !

!ThermometerGlyph methodsFor: 'glyph protocol'!

boundingBox
	| r left right top bottom bf |
	false ifTrue: [self stilltodo].
	bf _ under value
				ifTrue: [BulbForm2]
				ifFalse: [BulbForm].
	r _ editBox asRectangle.
	left _ r left - (bf width - r width // 2).
	right _ r right + (bf width - r width // 2).
	top _ r top.
	over value ifTrue: [top _ top - CapForm height].
	bottom _ r bottom + bf height.
	^left @ top corner: right @ bottom!

displayOn: aDisplayMedium at: aDisplayPoint clip: clipBox 
	| markY box |
	box _ editBox asRectangle moveBy: aDisplayPoint.
	markY _ (editBox left @ mercury y) corner: editBox bottomRight.
	aDisplayMedium fill: editBox mask: Form white.
	aDisplayMedium fill: markY mask: Form gray.
	aDisplayMedium border: editBox asRectangle width: 1.
	under value
		ifTrue: [BulbForm2 displayOn: aDisplayMedium at: editBox bottomLeft - (0 @ 1) - (BulbForm2 width - editBox width // 2 @ 0)]
		ifFalse: [BulbForm displayOn: aDisplayMedium at: editBox bottomLeft - (0 @ 1) - (BulbForm width - editBox width // 2 @ 0)].
	over value ifTrue: [CapForm displayOn: aDisplayMedium at: editBox topLeft - (((CapForm width - editBox width // 2)) @ (CapForm height - 1))].
	false ifTrue: [self stilltodo]!

isSelectable
	^true!

locationPoints
	^Array with: editBox center!

old.displayOn: aDisplayMedium at: aDisplayPoint clip: clipBox 
	| scaleFactor markY over1 under1 |
	"textGlyph displayOn: aDisplayMedium at: aDisplayPoint clip: clipBox."
	scaleFactor _ editBox height asFloat / (maxVal value - minVal value) asFloat.
	markY _ (scaleFactor * (temperature value asFloat - minVal value asFloat)) rounded.
	over1 _ markY > (editBox height + 40).
	under1 _ markY < -60.
	markY _ (markY max: 0)
				min: editBox height.
	markY _ editBox height - markY.
	markY _ editBox topLeft + (0 @ markY) corner: editBox bottomRight.
	aDisplayMedium fill: editBox mask: Form white.
	aDisplayMedium fill: markY mask: Form gray.
	aDisplayMedium border: editBox asRectangle width: 1.
	under1
		ifTrue: [BulbForm2 displayOn: aDisplayMedium at: editBox bottomLeft - (0 @ 1) - (BulbForm2 width - editBox width // 2 @ 0)]
		ifFalse: [BulbForm displayOn: aDisplayMedium at: editBox bottomLeft - (0 @ 1) - (BulbForm width - editBox width // 2 @ 0)].
	over1 ifTrue: [CapForm displayOn: aDisplayMedium at: editBox topLeft - (0 @ (CapForm height - 1))].
	false ifTrue: [self stilltodo]! !

!ThermometerGlyph methodsFor: 'enumeration'!

selectableGlyphsDo: aBlock 
	aBlock value: self.
	"aBlock value: mercury."
	aBlock value: textGlyph!

visibleGlyphsDo: aBlock
	aBlock value: self.
	"aBlock value: mercury."
	aBlock value: textGlyph! !

!ThermometerGlyph methodsFor: 'mouse'!

handleMouseDown: mousePoint view: view 
	Sensor leftShiftDown
		ifTrue: [^self editScript]
		ifFalse: 
			[editConstraint _ EditConstraint var: temperature strength: #preferred.
			editConstraint2 _ EditConstraint var: mercury yVar strength: #preferred.
			editConstraint isSatisfied
				ifTrue: 
					[plan _ Planner extractPlanFromInputConstraints: (Array with: editConstraint with: editConstraint2).
					view computeBackground]
				ifFalse: [view flash]]!

handleMouseMove: mousePoint view: view 
	"Move the slider, show feedback, and run the script. If the shift key is pressed, 
	the user wants to edit the script, so do nothing."

	| scaleFactor relativeY scaledValue |
	scaleFactor _ (maxVal value - minVal value) asFloat / editBox height asFloat.
	relativeY _ mousePoint y - editBox top.
	relativeY _ relativeY max: 0.
	relativeY _ relativeY min: editBox height.
	relativeY _ editBox height - relativeY.
	(relativeY ~~ prevY and: [editConstraint notNil and: [editConstraint isSatisfied]])
		ifTrue: 
			[scaledValue _ minVal value asFloat + (scaleFactor * relativeY asFloat).
			temperature value: scaledValue.
			mercury yVar value: (editBox height - relativeY)  + (editBox top).
			plan execute.
			view displayFeedback.
			compiledScript notNil ifTrue: [compiledScript
					value: view model
					value: view
					value: scaledValue].
			prevY _ relativeY]!

handleMouseUp: mousePoint view: view 
	"Clean up the edit constraint and plan."

	editConstraint notNil
		ifTrue: 
			[editConstraint destroyConstraint.
			editConstraint _ nil.
			editConstraint2 destroyConstraint.
			editConstraint2 _ nil.
			plan release.
			plan _ nil]!

wantsMouse
	^true! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

ThermometerGlyph class
	instanceVariableNames: ''!


!ThermometerGlyph class methodsFor: 'class initialization'!

initialize
	"ThermometerGlyph initialize."

	BulbForm _ Form
				extent: 30 @ 30
				fromArray: #(1706 43712 1365 21824 1706 43712 1365 21824 1706 43712 3413 21856 6826 43696 13653 21840 10922 43704 13653 21848 10922 43688 30037 21852 27306 43692 54613 21844 43690 43692 54613 21844 60074 43692 21845 21844 27306 43692 13653 21848 10922 43704 13653 21840 6826 43696 3413 21856 1706 43712 853 21888 426 43776 213 22016 127 64512 0 0 )
				offset: 0 @ 0.
	BulbForm2 _ (Form
	extent: 30@30
	fromArray: #( 1706 43712 1365 21824 1706 43712 1365 21824 1706 43712 3413 21856 6826 43696 13653 21840 10922 43704 13653 22520 10922 43520 30079 22016 27361 44032 57281 22528 43009 45060 55296 57356 59392 796 22648 2036 29167 3756 341 40280 938 64184 8021 21840 6826 43696 3413 21856 1706 43712 853 21888 426 43776 213 22016 127 64512 0 0)
	offset: 0@0).
	CapForm _ (Form
	extent: 41@29
	fromArray: #( 0 0 0 0 0 0 32263 33249 61184 32527 50161 65280 25500 59193 47872 24984 26137 47872 25496 26137 33536 32536 26137 33536 32536 26137 33536 25496 26137 33536 24984 26137 33536 25500 59161 33536 32527 50161 33536 32263 33249 33536 0 0 0 43176 2082 35328 21585 21765 5376 43682 43690 10752 5461 17749 21504 2730 2600 43008 4437 21841 21504 674 43690 32768 341 21781 16384 682 43690 40960 341 17749 16384 42 43688 0 85 21844 0 10 43688 0 21 21844 0)
	offset: 0@0)! !

!ThermometerGlyph class methodsFor: 'internal'!

internalMsg1: minVar and: maxVar and: tempVar and: boxHeightVar and: boxTopVar
	| scaleFactor markY |
	scaleFactor _ boxHeightVar  asFloat / (maxVar  - minVar ) asFloat.
	markY _ (scaleFactor * (tempVar  asFloat - minVar  asFloat)) rounded.
	markY _ (markY max: 0)
				min: boxHeightVar.
	markY _ boxHeightVar - markY + boxTopVar.
	^markY!

internalMsg2: tempVar and: over
	^tempVar > over!

internalMsg3: tempVar and: under
	^tempVar < under! !

!ThermometerGlyph class methodsFor: 'constraint release'!

releaseConstraints
	"ThermometerGlyph releaseConstraints"

	PrintConstraint _ MercConstraint _ OverConstraint _ UnderConstraint _ nil! !

!ThermometerGlyph class methodsFor: 'classification'!

glyphCategory
	^'SIGGRAPH'! !

ThermometerGlyph initialize!


PointGlyph subclass: #FakeMouseGlyph
	instanceVariableNames: 'form '
	classVariableNames: 'MouseForm '
	poolDictionaries: ''
	category: 'Minstrel-SIGGRAPH'!


!FakeMouseGlyph methodsFor: 'glyph protocol'!

displayOn: aDisplayMedium at: aDisplayPoint clip: clipBox 
	MouseForm
		displayOn: aDisplayMedium
		at: aDisplayPoint + self asPoint
		clippingBox: clipBox
		rule: Form paint
		mask: Form black! !

!FakeMouseGlyph methodsFor: 'merging'!

canMergeWith: aGlyph 
	^false!

changing
	"This is a hack to prevent the ugly black can-merge box from showing up around 
	my anchor."

	^true! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

FakeMouseGlyph class
	instanceVariableNames: ''!


!FakeMouseGlyph class methodsFor: 'class initialization'!

initialize
	"FakeMouseGlyph initialize"

	MouseForm _ Form
				extent: 16 @ 16
				fromArray: #(1 3 7 15 31 63 127 31 31 25 48 48 96 96 192 192 )
				offset: -16 @ 0.! !

FakeMouseGlyph initialize!


Scene subclass: #TwoPlanetDemo
	instanceVariableNames: 'planet1 planet2 velocity1 velocity2 accel1 accel2 gravity '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Minstrel-SIGGRAPH'!


!TwoPlanetDemo methodsFor: 'initialize-release'!

create
	| v1 h1 v2 v3 v4 c cx cy |
	Transcript cr; show: 'Building the ' , self class name , '..'.
	Transcript cr; show: '..adding planets'.
	gravity _ FreeVariable new.
	planet1 _ PlanetGlyph new initialize.
	planet1 form2.
	planet1 moveTo: 150 @ 200.
	planet2 _ PlanetGlyph new initialize.
	planet2 form2b.
	planet2 moveTo: 350 @ 250.
	self addGlyph: planet1; addGlyph: planet2.
	Transcript cr; show: '..adding control sliders'.
	v1 _ PlanetVectorGlyph new initialize.
	v1 moveTo: 50 @ 50.
	v2 _ PlanetVectorGlyph new initialize.
	v2 moveTo: 125 @ 50.
	v3 _ PlanetVectorGlyph new initialize.
	v3 moveTo: 375 @ 50.
	v4 _ PlanetVectorGlyph new initialize.
	v4 moveTo: 450 @ 50.
	self addGlyph: v1; addGlyph: v2; addGlyph: v3; addGlyph: v4.
	h1 _ (HSliderGlyph on: gravity) minVal: 0.0; maxVal: 1000000.0; value: 30.0; moveTo: 250 @ 50. 
	self addGlyph: h1.
	Transcript cr; show: '..adding stay constraints'.
	StayConstraint var: v1 p1 xVar strength: #default.
	StayConstraint var: v1 p1 yVar strength: #default.
	StayConstraint var: v2 p1 xVar strength: #default.
	StayConstraint var: v2 p1 yVar strength: #default.
	StayConstraint var: v3 p1 xVar strength: #default.
	StayConstraint var: v3 p1 yVar strength: #default.
	StayConstraint var: v4 p1 xVar strength: #default.
	StayConstraint var: v4 p1 yVar strength: #default.
	Transcript cr; show: '..adding interface constraints'.
	c _ Constraint names: #(v prev deltav ) methods: #('v _ prev + (deltav // 5)' 'deltav _ (v - prev) * 5' ).
	c copy
		var: v1 arrowHead vector xVar
		var: v1 arrowHead vector xVar last
		var: v2 arrowHead vector xVar
		strength: #required.
	c copy
		var: v1 arrowHead vector yVar
		var: v1 arrowHead vector yVar last
		var: v2 arrowHead vector yVar
		strength: #required.
	c copy
		var: v4 arrowHead vector xVar
		var: v4 arrowHead vector xVar last
		var: v3 arrowHead vector xVar
		strength: #required.
	c copy
		var: v4 arrowHead vector yVar
		var: v4 arrowHead vector yVar last
		var: v3 arrowHead vector yVar
		strength: #required.
	Transcript cr; show: '..adding behavior constraints'.
	c _ Constraint names: #(v prev deltav ) methods: #(
		'v _ ((prev + (deltav // 5)) < 0
			ifTrue: [0]
			ifFalse: [(prev + (deltav // 5)) > 500
				ifTrue: [500]
				ifFalse: [prev + (deltav // 5)]])' 'deltav _ (v - prev) * 5' ).
	c copy
		var: planet1 xVar
		var: planet1 xVar last
		var: v1 arrowHead vector xVar
		strength: #required.
	c copy
		var: planet1 yVar
		var: planet1 yVar last
		var: v1 arrowHead vector yVar
		strength: #required.
	c copy
		var: planet2 xVar
		var: planet2 xVar last
		var: v4 arrowHead vector xVar
		strength: #required.
	c copy
		var: planet2 yVar
		var: planet2 yVar last
		var: v4 arrowHead vector yVar
		strength: #required.
	cx _ Constraint names: #(p1x p1y p2x p2y ax g) methods: #(
		'ax _ (g * (
			(p2x - p1x) abs < 1
				ifTrue: [0]
				ifFalse: [((p2x - p1x) / ((p2x - p1x) squared + (p2y - p1y) squared) sqrt)
						/ ((p2x - p1x) squared + (p2y - p1y) squared)]))').
	cy _ Constraint names: #(p1x p1y p2x p2y ay g) methods: #(
		'ay _ (g * (
			(p2y - p1y) abs < 1
				ifTrue: [0]
				ifFalse: [((p2y - p1y) / ((p2x - p1x) squared + (p2y - p1y) squared) sqrt)
						/ ((p2x - p1x) squared + (p2y - p1y) squared)]))').
	cx copy
		var: planet1 xVar last
		var: planet1 yVar last
		var: planet2 xVar last
		var: planet2 yVar last
		var: v2 arrowHead vector xVar
		var: gravity
		strength: #strongDefault.
	cy copy
		var: planet1 xVar last
		var: planet1 yVar last
		var: planet2 xVar last
		var: planet2 yVar last
		var: v2 arrowHead vector yVar
		var: gravity
		strength: #strongDefault.
	cx copy
		var: planet2 xVar last
		var: planet2 yVar last
		var: planet1 xVar last
		var: planet1 yVar last
		var: v3 arrowHead vector xVar
		var: gravity
		strength: #strongDefault.
	cy copy
		var: planet2 xVar last
		var: planet2 yVar last
		var: planet1 xVar last
		var: planet1 yVar last
		var: v3 arrowHead vector yVar
		var: gravity
		strength: #strongDefault.
	Transcript cr; show: 'finished'!

initialize
	super initialize.
	self create! !

!TwoPlanetDemo methodsFor: 'public'!

open
	"TwoPlanetDemo new open"

	| topView |
	topView _ SpecialSystemView
				model: nil
				label: 'Planet Demo (Real Gravity)'
				minimumSize: 525 @ 425.
	topView borderWidth: 1; addSubView: (SceneView new initialize model: self).
	topView controller open! !

!TwoPlanetDemo methodsFor: 'testing'!

isAnimated
	^true! !

!TwoPlanetDemo methodsFor: 'background processing'!

computeBackgroundPlan
	^Planner extractPlanFromVariables: (Array with: gravity)! !

LineGlyph subclass: #PlanetVectorGlyph
	instanceVariableNames: 'arrowHead '
	classVariableNames: 'ArrowC '
	poolDictionaries: ''
	category: 'Minstrel-SIGGRAPH'!


!PlanetVectorGlyph methodsFor: 'initialize-release'!

addConstraints
	| ArrowC |
	ArrowC isNil ifTrue: [ArrowC _ Constraint names: #(vector p1 p2 ) methods: #('vector _ p2 - p1' 'p2 _ p1 + vector' )].
	p2 xVar requireEquals: arrowHead location xVar.
	p2 yVar requireEquals: arrowHead location yVar.
	ArrowC copy
		var: arrowHead vector xVar
		var: p1 xVar
		var: p2 xVar
		strength: #required.
	ArrowC copy
		var: arrowHead vector yVar
		var: p1 yVar
		var: p2 yVar
		strength: #required!

initialize
	"p1 is the base of the vector, a PointGlyph.
	 p2 is the head of the vector, an InvisiblePointGlyph"

	super initialize.
	p1 _ PointGlyph new moveTo: 10@10.
	p2 _ InvisiblePointGlyph new moveTo: 30@30.
	arrowHead _ ArrowHeadGlyph new.
	self addConstraints.! !

!PlanetVectorGlyph methodsFor: 'accessing'!

arrowHead
	^arrowHead! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

PlanetVectorGlyph class
	instanceVariableNames: ''!


!PlanetVectorGlyph class methodsFor: 'constraint release'!

releaseConstraints
	"PlanetVectorGlyph releaseConstraints"

	ArrowC _ nil! !

!PlanetVectorGlyph class methodsFor: 'classification'!

glyphCategory
	^'SIGGRAPH'! !


!VectorGlyph class methodsFor: 'constraint release'!

releaseConstraints
	"VectorGlyph releaseConstraints"

	ArrowC _ nil.
	DirectionC _ nil.! !

Scene subclass: #MacDrawDemo
	instanceVariableNames: 'dashes draggers sparedragger selfvariable '
	classVariableNames: 'CalculateSpareConstraint DashDragAlignConstraint MaxLengthConstraint MinLengthConstraint MinRight2Constraint MinRightConstraint '
	poolDictionaries: ''
	category: 'Minstrel-SIGGRAPH'!
MacDrawDemo comment:
'							***** Complex Graphical User Interfaces (MacDraw II) *****

This demo was taken from the MacDraw II Dashed Lines dialog box, a user interface widget for defining the number and length of the black and white dashes that, together, comprise a dashed line.  In the original MacDraw II, this dialog box was implemented completely in Pascal: the programmer designed the box, extracted the constraints, hand-solved them, coded them in Pascal, and debugged and debugged and debugged.  In this version, the behavior is almost completely defined by constraints.  Even the existence or non-existence of the dashes is defined by constraints.

This dialog box uses three basic types of constraints: data consistency constraints, graphical constraints, and behavioral constraints.  Data consistency constraints include: no dash shall be shorted than 5 pixels.  No dash shall be longer than 125 pixels.  There must be at least two dashes.  There can be no more than six dashes.  Etc.  Graphical constraints include keeping the "draggers" aligned with the right end of their respective dash expect for the last one which can be dragged to the far right edge to delete a dash.  Behavioral constraints are basically internal but include such things as the existence of dashes and draggers, and "snapping" action which occurs when the last dragger is released between the right end of its dash and the right edge of the box.

Interesting actions to try include: (1) trying to shrink a dash too far, (2) trying to grow a dash too large, (3) dragging the last dragger to the far right, (4) dragging the dragger on the far right (if there you left it there) off the far right "parking" place, (5) trying to compact a dash on the right by shoving it against the edge with a dash from the middle, and (6) releasing the last dragger half-way between the end of its dash and the right edge of the box.
'!


!MacDrawDemo methodsFor: 'initialize-release'!

create1
	| c d |
	Transcript cr; show: 'Building the ' , self class name , '..'.
	Transcript cr; show: '..adding the dashes'.
	dashes _ d _ Array new: 6.
	1 to: d size do: [:i | d at: i put: (MacDrawDashGlyph new initialize: i)].
	(d at: 1) left0 value: MacDrawDemo leftEdge.
	2 to: d size + 1 do: 
		[:i | 
		(d at: i - 1) right0 value: (d at: i - 1) left0 value + (d at: i - 1) length0 value.
		(d at: i - 1) right1 value: (d at: i - 1) left1 value + (d at: i - 1) length1 value.
		(d at: i - 1) right2 value: (d at: i - 1) left2 value + (d at: i - 1) length2 value.
		(d at: i - 1) right3 value: (d at: i - 1) left3 value + (d at: i - 1) length3 value.
		(d at: i - 1) color value: i even.
		i > d size
			ifFalse: 
				[(d at: i) left0 value: (d at: i - 1) right0 value.
				(d at: i) left1 value: (d at: i - 1) right1 value.
				(d at: i) left2 value: (d at: i - 1) right2 value.
				(d at: i) left3 value: (d at: i - 1) right3 value]].
	1 to: d size do: [:i | self addGlyph: (d at: i)].
	Transcript cr; show: '..adding the dash constraints'.
	(StayConstraint var: (d at: 1) left0 strength: #required) name: 'initial length0 stay'.
	(StayConstraint var: (d at: 1) left1 strength: #required) name: 'initial length1 stay'.
	(StayConstraint var: (d at: 1) left2 strength: #required) name: 'initial length2 stay'.
	(StayConstraint var: (d at: 1) left3 strength: #required) name: 'initial length3 stay'.
	2 to: d size do: 
		[:i | 
		(EqualityConstraint
			var: (d at: i - 1) right0
			var: (d at: i) left0
			strength: #required) name: ((i-1) printString), ':right0 = ', (i printString), ':left0'.
		(EqualityConstraint
			var: (d at: i - 1) right1
			var: (d at: i) left1
			strength: #required) name: ((i-1) printString), ':right1 = ', (i printString), ':left1'.
		(EqualityConstraint
			var: (d at: i - 1) right2
			var: (d at: i) left2
			strength: #required) name: ((i-1) printString), ':right2 = ', (i printString), ':left2'.
		(EqualityConstraint
			var: (d at: i - 1) right3
			var: (d at: i) left3
			strength: #required) name: ((i-1) printString), ':right3 = ', (i printString), ':left3'].
	(StayConstraint var: (d at: 1) color strength: #required) name: 'initial color stay'.
	c _ Constraint names: #(left right ) methods: #('left _ right not' 'right _ left not' ).
	2 to: d size do: [:i | (c copy
			var: (d at: i - 1) color
			var: (d at: i) color
			strength: #required) name: (i printString), ':color alternate'].
	self create2!

create2
	| d |
	Transcript cr; show: '..adding the draggers'.
	d _ draggers _ Array new: dashes size.
	1 to: d size do: [:i | d at: i put: (MacDrawDraggerGlyph new initialize: i)].
	d with: dashes do: [:drag :dash | drag dash: dash scene: self].
	d do: [:each | self addGlyph: each].
	(d at: 1) height value: 20 + MacDrawDemo dragTop.
	Transcript cr; show: '..adding the dragger constraints'.
	(StayConstraint var: (d at: 1) height strength: #required) name: 'initial height'.
	2 to: d size do: [:i | (OffsetConstraint
			from: (d at: i - 1) height
			to: (d at: i) height
			strength: #required
			offset: MacDrawDemo dragBox height) name: i printString, ':height descent'].
	1 to: d size do: [:i |
			drag _ d at: i.
			dash _ dashes at: i.
			self defaultFlexiForDash: dash andDragger: drag atIndex: i].
	self create3!

create3
	| c |
	Transcript cr; show: '..adding the ruler'.
	self addGlyph: MacDrawRulerGlyph new.
	sparedragger _ FreeVariable value: 0.
	selfvariable _ FreeVariable value: self.
	Transcript cr; show: '..adding the existence constraints'.
	c _ Constraint names: #(exists offset ) methods: #('exists _ (offset = MacDrawDemo rightEdge) not' ).
	1 to: dashes size do: [:i | (c copy
			var: (dashes at: i) exists
			var: (draggers at: i) offset
			strength: #required)
			name: i printString , ':dash exists _ dragger atRight'].
	3 to: dashes size do: [:i | ((Constraint names: #(exists dashexists spare ) methods: (Array with: 'exists _ dashexists | (spare = ', i printString, ')'))
			var: (draggers at: i) exists
			var: (dashes at: i) exists
			var: sparedragger
			strength: #required)
			name: i printString , ':dragger exists _ dash exists or spare=', i printString].
	Transcript cr; show: '..initializing'.
	self cleanUpFor: nil and: nil.
	Transcript cr; show: 'finished'!

defaultFlexiForDash: aDash andDragger: aDragger atIndex: i 
	aDragger doDashDraggerAlignDefault: i!

initialize
	super initialize.
	self create1! !

!MacDrawDemo methodsFor: 'public'!

open
	"MacDrawDemo new open"

	| topView |
	topView _ SpecialSystemView
				model: nil
				label: 'MacDraw II Dialog Box'
				minimumSize: 600 @ 400.
	topView borderWidth: 1; addSubView: (MacDrawDemoView new initialize model: self).
	topView controller open! !

!MacDrawDemo methodsFor: 'access'!

lastdash
	| l |
	l _ dashes inject: nil into: [:last :dash | dash exists value
					ifTrue: [dash]
					ifFalse: [last]].
	"l == dashes last ifFalse: [Transcript cr; show: 'Notice: lastdash ~~ dashes last']."
	^l!

seconddash
	^dashes at: 2! !

!MacDrawDemo methodsFor: 'direct manipulation'!

cleanUpFor: aDragger and: aDash 
	| i |
	aDragger notNil
		ifTrue: 
			[i _ dashes indexOf: aDash.
			self defaultFlexiForDash: aDash andDragger: aDragger atIndex: i].
	dashes do: 
		[:each | 
		each right1 value: each right0 value.
		each right2 value: each right1 value.
		each right3 value: each right2 value.
		each length1 value: each length0 value.
		each length2 value: each length1 value.
		each length3 value: each length2 value.
		each left1 value: each left0 value.
		each left2 value: each left1 value.
		each left3 value: each left2 value]!

computeSpare: ignore
	| i |
	i _ dashes indexOf: self lastdash.
	^i = dashes size
				ifTrue: [0]
				ifFalse: [i + 1]!

editConstraints1For: aDragger and: aDash at: idx into: cons
	"== == == == == == == == == == == == == == == == == == == == == == == == 
							mouse
								|
								v
	dash3		dash3		dash3*		dash3		dash3"
	cons addFirst: ((XMouseConstraint
			var: aDash right3
			strength: #required
			offset: aDragger offset value - Sensor mousePoint x) name: 'on ', idx printString).!

editConstraints2For: aDragger and: aDash at: idx into: cons
	"== == == == == == == == == == == == == == == == == == == == == == == == 
							dragger
								^
								|
	dash1		dash1		dash1*		dash1		dash1"
	((aDash == self lastdash | aDragger isSpare) and: [(aDash == self seconddash) not])
		ifTrue: [aDragger doDashDraggerAlignMovement: idx].!

editConstraints3For: aDragger and: aDash at: idx into: cons
	"== == == == == == == == == == == == == == == == == == == == == == == == 
							spare
								^
								|
	dash0		dash0		dash0*		dash0		dash0"
	CalculateSpareConstraint isNil ifTrue: [CalculateSpareConstraint _ (Constraint
		names: #(spare scene offset)
		methods: #('spare _ scene computeSpare: offset'))
		name: 'spare computation' ].
	cons add: (CalculateSpareConstraint copy
				var: sparedragger
				var: selfvariable
				var: aDash exists
				strength: #required).!

editConstraints4For: aDragger and: aDash at: idx into: cons
	| each |
	"== == == == == == == == == == == == == == == == == == == == == == == == 
	dash3		dash3		dash3*		dash3		dash3
	stay		stay					stay		stay

	dash2		dash2		dash2*		dash2		dash2
	stay		stay					stay		stay

	dash1		dash1		dash1*		dash1		dash1
	stay		stay					stay		stay

	dash0		dash0		dash0*		dash0		dash0
	stay		stay					stay		stay"
	1 to: dashes size do: [:i | each _ dashes at: i.
		each == aDash
			ifFalse: 
				[cons add: ((StayConstraint var: each length3 strength: #required) name: i printString, ':length3 stay').
				cons add: ((StayConstraint var: each length2 strength: #required) name: i printString, ':length2 stay').
				cons add: ((StayConstraint var: each length1 strength: #required) name: i printString, ':length1 stay').
				cons add: ((StayConstraint var: each length0 strength: #required) name: i printString, ':length0 stay').]].!

editConstraints5For: aDragger and: aDash at: idx into: cons
	"== == == == == == == == == == == == == == == == == == == == == == == == 
	dash3		dash3		dash3*		dash3		dash3
								| minimum length
								v
	dash2		dash2		dash2*		dash2		dash2"
	MinLengthConstraint isNil ifTrue: [MinLengthConstraint _ Constraint
		names: #(v pv )
		methods: #('v _ pv max: MacDrawDemo minDash' )].
	cons add: ((MinLengthConstraint copy
			var: aDash length2
			var: aDash length3
			strength: #required) name: idx printString, ': length2 = min length3').!

editConstraints6For: aDragger and: aDash at: idx into: cons
	"== == == == == == == == == == == == == == == == == == == == == == == == 
	dash1		dash1		dash1*		dash1		dash1
								| maximum length
								v
	dash0		dash0		dash0*		dash0		dash0"
	MaxLengthConstraint isNil ifTrue: [MaxLengthConstraint _ Constraint
		names: #(v pv )
		methods: #('v _ pv min: MacDrawDemo maxDash' )].
	cons add: ((MaxLengthConstraint copy
			var: aDash length0
			var: aDash length1
			strength: #required) name: idx printString, ': length0 = min max length1').!

editConstraints7For: aDragger and: aDash at: idx into: cons
	"== == == == == == == == == == == == == == == == == == == == == == == == 
	dash2		dash2		dash2*		dash2		dash2
														| not beyond right edge
														v
	dash1		dash1		dash1*		dash1		dash1"
	MinRightConstraint isNil ifTrue: [MinRightConstraint _ Constraint
		names: #(v pv )
		methods: #('v _ pv min: MacDrawDemo rightEdge' )].
	MinRight2Constraint isNil ifTrue: [MinRight2Constraint _ Constraint
		names: #(v pv )
		methods: #('v _ pv min: MacDrawDemo rightEdge - 1' )].
	aDragger isSpare
		ifTrue: [cons add: ((MinRightConstraint copy
					var: aDragger dash right1
					var: aDragger dash right2
					strength: #required) name: idx printString, ': right1 = min right2')]
		ifFalse:[aDash == self lastdash
					ifTrue: [cons add: ((MinRightConstraint copy
							var: self lastdash right1
							var: self lastdash right2
							strength: #required)
							name: idx printString, ': right1 = min right2')]
					ifFalse: [cons add: ((MinRight2Constraint copy
							var: self lastdash right1
							var: self lastdash right2
							strength: #required)
							name: idx printString, ': right1 = min-1 right2')]].!

editConstraintsFor: aDragger and: aDash 
	| cons idx |
	cons _ OrderedCollection new.
	idx _ dashes indexOf: aDash.
	self editDebugFor: aDragger and: aDash mark: 0.
	self editConstraints1For: aDragger and: aDash at: idx into: cons.
	self editDebugFor: aDragger and: aDash mark: 1.
	self editConstraints2For: aDragger and: aDash at: idx into: cons.
	self editDebugFor: aDragger and: aDash mark: 2.
	self editConstraints3For: aDragger and: aDash at: idx into: cons.
	self editDebugFor: aDragger and: aDash mark: 3.
	self editConstraints4For: aDragger and: aDash at: idx into: cons.
	self editDebugFor: aDragger and: aDash mark: 4.
	self editConstraints5For: aDragger and: aDash at: idx into: cons.
	self editDebugFor: aDragger and: aDash mark: 5.
	self editConstraints6For: aDragger and: aDash at: idx into: cons.
	self editDebugFor: aDragger and: aDash mark: 6.
	self editConstraints7For: aDragger and: aDash at: idx into: cons.
	self editDebugFor: aDragger and: aDash mark: 7.
	^cons!

editDebugFor: aDragger and: aDash mark: aMark
	| collec st s0 s1 s2 s3 d | 
true ifTrue: [^self].
collec _ Array
	with: (Array with: 5 with: (dashes at: 5))
	with: (Array with: 6 with: (dashes at: 6)).
st _ String new writeStream. st nextPut: $[. aMark printOn: st. st nextPut: $].
s0 _ String new writeStream. s0 nextPutAll: '0:'.
s1 _ String new writeStream. s1 nextPutAll: '1:'.
s2 _ String new writeStream. s2 nextPutAll: '2:'.
s3 _ String new writeStream. s3 nextPutAll: '3:'.
collec do: [:each |
d _ (each at: 2).
st tab; tab. (each at: 1) printOn: st. st tab; tab.
s3 tab. d left3 value printOn: s3. s3 tab.
d length3 value printOn: s3. s3 tab.
d right3 value printOn: s3. s3 tab.
s2 tab. d left2 value printOn: s2. s2 tab.
d length2 value printOn: s2. s2 tab.
d right2 value printOn: s2. s2 tab.
s1 tab. d left1 value printOn: s1. s1 tab.
d length1 value printOn: s1. s1 tab.
d right1 value printOn: s1. s1 tab.
s0 tab. d left0 value printOn: s0. s0 tab.
d length0 value printOn: s0. s0 tab.
d right0 value printOn: s0. s0 tab].
aMark = 0 ifTrue: [Transcript nextPutAll: '--------------------------'; cr].
Transcript nextPutAll: st contents; cr.
Transcript nextPutAll: s3 contents; cr; nextPutAll: s2 contents; cr.
Transcript nextPutAll: s1 contents; cr; nextPutAll: s0 contents; cr.
Transcript show: ''! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

MacDrawDemo class
	instanceVariableNames: 'draggerBoxForm '!


!MacDrawDemo class methodsFor: 'class initialization'!

initialize
	"MacDrawDemo initialize."

	draggerBoxForm _ Form extent: self dragBox extent.
	draggerBoxForm white.
	draggerBoxForm border: draggerBoxForm boundingBox width: 1.
	draggerBoxForm offset: (MacDrawDemo dragBox width // -2 @ (MacDrawDemo dragBox height // -2)).! !

!MacDrawDemo class methodsFor: 'layout constants'!

dashBottom
	^self dashTop + 20!

dashTop
	^250!

dragBottom
	^self dashTop - 20!

dragBox
	^0@0 extent: 10@10!

draggerBoxForm
	^draggerBoxForm!

dragTop
	^self dragBottom - 100!

leftEdge
	^50!

maxDash
	^125!

minDash
	^5!

rightEdge
	^550! !

!MacDrawDemo class methodsFor: 'constraint release'!

releaseConstraints
	"MacDrawDemo releaseConstraints"

	MinLengthConstraint _ MaxLengthConstraint _ MinRightConstraint _ MinRight2Constraint _ DashDragAlignConstraint _ CalculateSpareConstraint _ nil! !

!MacDrawDemo class methodsFor: 'access'!

infoSize
	^700@330! !

MacDrawDemo initialize!

GestureController subclass: #SceneController
	instanceVariableNames: 'myMenu lastMenuItem running lastPartsMenuString partsMenuCache thePlan '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Minstrel-View'!


!SceneController methodsFor: 'control defaults'!

controlActivity
	"Process user mouse and keyboard activity."

	(sensor keyboardPressed) ifTrue: [^self readKeyboard].
	(sensor yellowButtonPressed) ifTrue: [^self menuActivity].

	"The following code allows click, drag, and sweep gestures even in 'operate' mode:"
	(sensor redButtonPressed) ifTrue: [^self possibleClickAt: sensor cursorPoint].

	"Note: replace the previous code with the following to disable click, drag, and sweep gestures in 'operate' mode. This is good for naive users and quick response."
	"(sensor redButtonPressed) ifTrue:
		[(running)
			ifTrue: [^self processMouseAt: sensor cursorPoint]
			ifFalse: [^self possibleClickAt: sensor cursorPoint]]."

	"model backgroundTask: view."
	thePlan notNil
		ifTrue: 
			[thePlan execute.
			view displayFeedback]!

controlInitialize
	super controlInitialize.
	model isAnimated
		ifTrue: [thePlan isNil
				ifTrue: 
					[thePlan _ model computeBackgroundPlan.
					view computeBackground]]
		ifFalse: [thePlan _ nil]! !

!SceneController methodsFor: 'direct manipulation'!

while: testBlock move: pointsToMove refPoint: refPoint mergeWith: mergeGlyph 
	"Move the given points using mouse constraints. Any glyphs attached to the  
	points will follow the mouse until testBlock is false. If mergeGlyph is not nil, try  
	to merge it with the glyph (if any) at its new location."

	| mergeable mouseConstraints offset views mousePoint oldMousePoint target starterConstraints |
	mergeGlyph notNil
		ifTrue: 
			[mergeable _ OrderedCollection new: 100.
			model selectableGlyphsDo: [:g | (g includesObjectIn: pointsToMove)
					ifFalse: [mergeable add: g]]].
	mouseConstraints _ OrderedCollection new.
	pointsToMove do: 
		[:p | 
		offset _ p - refPoint.
		mouseConstraints add: (XMouseConstraint
				var: p xVar
				strength: #preferred
				offset: offset x); add: (YMouseConstraint
				var: p yVar
				strength: #preferred
				offset: offset y)].
	thePlan notNil ifTrue: [].
	model isAnimated
		ifTrue: [starterConstraints _ mouseConstraints , model initialAnimationConstraints]
		ifFalse: [starterConstraints _ mouseConstraints].
	thePlan _ Planner extractPlanFromInputConstraints: starterConstraints.
	"views _ SceneView allInstances select: [: v | v isAlive].  
	views do: [: v | v computeBackground]."
	view computeBackground.
	[testBlock value]
		whileTrue: 
			[mousePoint _ sensor cursorPoint.
			(oldMousePoint ~= sensor cursorPoint or: [model isAnimated])
				ifTrue: 
					[target _ nil.
					mergeGlyph notNil ifTrue: [mergeable do: [:g | ((g containsPoint: mousePoint + offset)
								and: [(g canMergeWith: mergeGlyph)
										or: [mergeGlyph canMergeWith: g]])
								ifTrue: [target _ g]]].
					thePlan execute.
					"views do:  
					[: v |  
					 ((target notNil) and: [v == view])  
					ifTrue:  
					[v	displayFeedbackWithBox:  
					(target boundingBox expandBy: 6)  
					width: 2]  
					ifFalse: [v displayFeedback]]]."
					target notNil
						ifTrue: [view displayFeedbackWithBox: (target boundingBox expandBy: 6)
								width: 2]
						ifFalse: [view displayFeedback]].
			oldMousePoint _ mousePoint].
	mouseConstraints do: [:c | c destroyConstraint].
	target notNil ifTrue: [self mergeGlyphs: (OrderedCollection with: target with: mergeGlyph)].
	view computeEnclosingRectangle.
	view displayScene.
	model isAnimated
		ifTrue: 
			[thePlan _ model computeBackgroundPlan.
			view computeBackground]
		ifFalse: [thePlan _ nil]! !

!SceneController methodsFor: 'keyboard'!

readKeyboard
	"Keystrokes are sent to all selected Things that are interested in keyboard 
	input. "

	| selected interested char editVars editConstraints |
	selected _ model selected.
	interested _ IdentitySet new: 10.
	editVars _ IdentitySet new: 10.
	model inputGlyphsDo: [:g | (g wantsKeystrokes and: [selected includes: g])
			ifTrue: 
				[interested add: g.
				editVars addAll: g keystrokeVars]].
	editConstraints _ editVars collect: [:var | EditConstraint var: var strength: #preferred].
	thePlan notNil ifTrue: [].
	thePlan _ Planner extractPlanFromInputConstraints: editConstraints.
	view computeBackground.
	[sensor keyboardPressed]
		whileTrue: 
			[self resetTimer.
			char _ sensor keyboard.
			interested do: [:thing | thing handleKeystroke: char view: view].
			[(self timeOut: 300)
				| sensor keyboardPressed]
				whileFalse: ["wait a bit in case there is another character"
					].
			sensor keyboardPressed
				ifFalse: 
					[thePlan execute.
					view displayFeedback]].
	editConstraints do: [:c | c destroyConstraint].
	"SceneView allInstancesDo: 
	[: v | 
	 (v isAlive) ifTrue: 
	[v displaySafe: [v displayScene]]]."
	view isAlive ifTrue: [view displaySafe: [view displayScene]].
	model isAnimated
		ifTrue:
			[thePlan _ model computeBackgroundPlan.
			view computeBackground]
		ifFalse: [thePlan _ nil]! !

Scene subclass: #RaisingDemo
	instanceVariableNames: 'fakemouse '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Minstrel-SIGGRAPH'!


!RaisingDemo methodsFor: 'initialize-release'!

create
	| hl vl m c |
	Transcript cr; show: 'Building the ' , self class name , '..'.
	Transcript cr; show: '..adding the components'.
	m _ FakeMouseGlyph new initialize.
	hl _ LineGlyph new.
	hl moveTo: 100 @ 100.
	vl _ LineGlyph new.
	vl moveTo: 100 @ 150.
	self addGlyph: m; addGlyph: hl; addGlyph: vl.
	Transcript cr; show: '..adding the consistency constraints'.
	EqualityConstraint
		var: hl p1 yVar
		var: hl p2 yVar
		strength: #weakDefault.
	EqualityConstraint
		var: vl p1 xVar
		var: vl p2 xVar
		strength: #required.
	(Constraint names: #(y1 y1p y2 y2p)
		methods: #('y1 _ y1p' 'y2 _ y2p'))
			var: vl p1 yVar
			var: vl p1 yVar last
			var: vl p2 yVar
			var: vl p2 yVar last
			strength: #required.
	EqualityConstraint
		var: hl p1 yVar
		var: vl p1 yVar
		strength: #required.
	EqualityConstraint
		var: hl p1 xVar
		var: vl p1 xVar
		strength: #required.
	EqualityConstraint
		var: vl p2 xVar
		var: m xVar
		strength: #required.
	EqualityConstraint
		var: vl p2 yVar
		var: m yVar
		strength: #required.
	"c _ Constraint names: #(new old ) methods: #('new _ ((old + SplittingDemo nextRandom) min: 350) max: 5' ).
	fakemouse _ Array with: (c copy
					var: m xVar
					var: m xVar last
					strength: #default)
				with: (c copy
						var: m yVar
						var: m yVar last
						strength: #default)."
	fakemouse _ Array new: 2.
	fakemouse at: 1 put: ((Constraint
		names: #(new old )
		methods: #('new _ SplittingDemo nextRandomX' ))
			var: m xVar
			var: m xVar last
			strength: #default).
	fakemouse at: 2 put: ((Constraint
		names: #(new old )
		methods: #('new _ SplittingDemo nextRandomY' ))
			var: m yVar
			var: m yVar last
			strength: #default).
	Transcript cr; show: 'finished'!

initialize
	super initialize.
	self create! !

!RaisingDemo methodsFor: 'public'!

open
	"RaisingDemo new open"

	| topView |
	topView _ SpecialSystemView
				model: nil
				label: 'Raising'
				minimumSize: 400 @ 400.
	topView borderWidth: 1; addSubView: (SceneView new initialize model: self).
	topView controller open! !

!RaisingDemo methodsFor: 'testing'!

isAnimated
	^true! !

!RaisingDemo methodsFor: 'background processing'!

computeBackgroundPlan
	^Planner extractPlanFromInputConstraints: fakemouse!

initialAnimationConstraints
	^fakemouse! !

Glyph subclass: #MacDrawDashGlyph
	instanceVariableNames: 'left0 left1 left2 left3 length0 length1 length2 length3 right0 right1 right2 right3 color exists '
	classVariableNames: 'LengthConstraint '
	poolDictionaries: ''
	category: 'Minstrel-SIGGRAPH'!


!MacDrawDashGlyph methodsFor: 'initialize-release'!

initialize
	self initialize: '?'!

initialize: i 
	"MacDrawDashGlyph releaseConstraints"

	super initialize.
	left0 _ FreeVariable value: 10.
	left1 _ FreeVariable value: 10.
	left2 _ FreeVariable value: 10.
	left3 _ FreeVariable value: 10.
	right0 _ FreeVariable value: 50.
	right1 _ FreeVariable value: 50.
	right2 _ FreeVariable value: 50.
	right3 _ FreeVariable value: 50.
	length0 _ FreeVariable value: 40.
	length1 _ FreeVariable value: 40.
	length2 _ FreeVariable value: 40.
	length3 _ FreeVariable value: 40.
	color _ FreeVariable value: true.
	exists _ FreeVariable value: true.
	LengthConstraint isNil ifTrue: [LengthConstraint _ Constraint names: #(left length right ) methods: #('right _ left + length' 'length _ right - left' 'left _ right - length' )].
	(LengthConstraint copy
		var: left3
		var: length3
		var: right3
		strength: #required)
		name: i printString , ':dash length3 = left3 - right3'.
	(LengthConstraint copy
		var: left2
		var: length2
		var: right2
		strength: #required)
		name: i printString , ':dash length2 = left2 - right2'.
	(LengthConstraint copy
		var: left1
		var: length1
		var: right1
		strength: #required)
		name: i printString , ':dash length1 = left1 - right1'.
	(LengthConstraint copy
		var: left0
		var: length0
		var: right0
		strength: #required)
		name: i printString , ':dash length0 = left0 - right0'! !

!MacDrawDashGlyph methodsFor: 'accessing'!

color
	^color!

exists
	^exists!

left
	^self halt: 'use a different left'!

left0 ^left0!

left1 ^left1!

left2 ^left2!

left3 ^left3!

length
	^self halt: 'use different length'!

length0 ^length0!

length1 ^length1!

length2 ^length2!

length3 ^length3!

right
	^self halt: 'use different right'!

right0 ^right0!

right1 ^right1!

right2 ^right2!

right3 ^right3! !

!MacDrawDashGlyph methodsFor: 'glyph protocol'!

displayOn: aDisplayMedium at: aDisplayPoint clip: clipBox 
	| box |
	exists value
		ifTrue: 
			[box _ left0 value @ MacDrawDemo dashTop corner: right0 value @ MacDrawDemo dashBottom.
			box translateBy: aDisplayPoint.
			color value
				ifTrue: [aDisplayMedium fill: box mask: Form black]
				ifFalse: 
					["aDisplayMedium border: box width: 1."
					self
						hLineFrom: left0 value rounded @ MacDrawDemo dashTop
						length: length0 value rounded
						on: aDisplayMedium
						at: aDisplayPoint
						clip: clipBox.
					self
						hLineFrom: left0 value rounded @ (MacDrawDemo dashBottom - 1)
						length: length0 value rounded
						on: aDisplayMedium
						at: aDisplayPoint
						clip: clipBox]]!

locationPoints
	^Array with: left0 value + right0 value // 2 @ (MacDrawDemo dashTop + MacDrawDemo dashBottom // 2)! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

MacDrawDashGlyph class
	instanceVariableNames: ''!


!MacDrawDashGlyph class methodsFor: 'classification'!

glyphCategory
	^'SIGGRAPH'! !

!MacDrawDashGlyph class methodsFor: 'constraint release'!

releaseConstraints
	"MacDrawDashGlyph releaseConstraints"

	LengthConstraint _ nil! !

Scene subclass: #SplittingDemo
	instanceVariableNames: 'fakemouse '
	classVariableNames: 'RandomStream '
	poolDictionaries: ''
	category: 'Minstrel-SIGGRAPH'!
SplittingDemo comment:
'							***** Constraint on Objects (Multi-User Application) *****

These demos illustrate two features of constraint systems: (one) constraints can be useful in the development of today''s multi-user, multi-media, multi-buzzword applications, and (two) constraints on complex objects can be implemented in a number of ways.  These demos illustrate two mechanisms: splitting (decomposing a constraint on a whole object into separate constraints on each of its parts) and raising (moving constraints on an object''s parts "up" to become constraints on the whole object).  Numerous other mechanisms also exist.

In these examples, we assume a two-user, two-mouse interactive graphical editor.  Here, however, the second user is simulated by the computer.  Note that even while the second user is busy editting her objects, the first user (you) can still edit yours.  Again, this is because all interactions are implemented with constraints and the system can solve many constraints just as easily as it can solve a few.

Each of these demos has a horizontal line and a vertical line.  The first user (you) are supposed to drag the right end of the horizontal line and the second user to drag the bottom end of the vertical line.  This works well in the splitting demo.  In the raising demo, however, the system has raised the constraints too far and has removed precious degrees of freedom from the objects.  Thus the constraints (you, the second user, horizontal, vertical) cannot all be solved simultaneously.
'!


!SplittingDemo methodsFor: 'initialize-release'!

create
	| hl vl m c |
	Transcript cr; show: 'Building the ' , self class name , '..'.
	Transcript cr; show: '..adding the components'.
	m _ FakeMouseGlyph new initialize.
	hl _ LineGlyph new.
	hl moveTo: 100 @ 100.
	vl _ LineGlyph new.
	vl moveTo: 100 @ 150.
	self addGlyph: m; addGlyph: hl; addGlyph: vl.
	Transcript cr; show: '..adding the consistency constraints'.
	EqualityConstraint
		var: hl p1 yVar
		var: hl p2 yVar
		strength: #required.
	EqualityConstraint
		var: vl p1 xVar
		var: vl p2 xVar
		strength: #required.
	EqualityConstraint
		var: hl p1 yVar
		var: vl p1 yVar
		strength: #required.
	EqualityConstraint
		var: hl p1 xVar
		var: vl p1 xVar
		strength: #required.
	EqualityConstraint
		var: vl p2 xVar
		var: m xVar
		strength: #required.
	EqualityConstraint
		var: vl p2 yVar
		var: m yVar
		strength: #required.
	"c _ Constraint names: #(new old ) methods: #('new _ ((old + SplittingDemo nextRandom) min: 350) max: 5' ).
	fakemouse _ Array with: (c copy
					var: m xVar
					var: m xVar last
					strength: #default)
				with: (c copy
						var: m yVar
						var: m yVar last
						strength: #default)."
	fakemouse _ Array new: 2.
	fakemouse at: 1 put: ((Constraint
		names: #(new old )
		methods: #('new _ SplittingDemo nextRandomX' ))
			var: m xVar
			var: m xVar last
			strength: #default).
	fakemouse at: 2 put: ((Constraint
		names: #(new old )
		methods: #('new _ SplittingDemo nextRandomY' ))
			var: m yVar
			var: m yVar last
			strength: #default).
	Transcript cr; show: 'finished'!

initialize
	super initialize.
	self create! !

!SplittingDemo methodsFor: 'public'!

open
	"SplittingDemo new open"

	| topView |
	topView _ SpecialSystemView
				model: nil
				label: 'Splitting'
				minimumSize: 400 @ 400.
	topView borderWidth: 1; addSubView: (SceneView new initialize model: self).
	topView controller open! !

!SplittingDemo methodsFor: 'testing'!

isAnimated
	^true! !

!SplittingDemo methodsFor: 'background processing'!

computeBackgroundPlan
	^Planner extractPlanFromInputConstraints: fakemouse!

initialAnimationConstraints
	^fakemouse! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

SplittingDemo class
	instanceVariableNames: ''!


!SplittingDemo class methodsFor: 'class initialization'!

initialize
	"SplittingDemo initialize"

	RandomStream _ Random new.
	RandomStream _ Array with: 1 with: 113@210 with: self pathArray!

pathArray
	| a |
	a _ OrderedCollection new.
	a add: 113 @ 211.
	a add: 113 @ 212.
	a add: 113 @ 217.
	a add: 113 @ 221.
	a add: 115 @ 225.
	a add: 115 @ 229.
	a add: 119 @ 233.
	a add: 123 @ 233.
	a add: 127 @ 237.
	a add: 131 @ 241.
	a add: 132 @ 241.
	a add: 133 @ 241.
	a add: 134 @ 241.
	a add: 135 @ 241.
	a add: 139 @ 242.
	a add: 143 @ 242.
	a add: 147 @ 242.
	a add: 151 @ 244.
	a add: 155 @ 244.
	a add: 159 @ 244.
	a add: 163 @ 244.
	a add: 167 @ 244.
	a add: 171 @ 244.
	a add: 175 @ 244.
	a add: 179 @ 245.
	a add: 183 @ 245.
	a add: 187 @ 247.
	a add: 191 @ 247.
	a add: 195 @ 249.
	a add: 197 @ 251.
	a add: 201 @ 255.
	a add: 203 @ 259.
	a add: 207 @ 261.
	a add: 209 @ 265.
	a add: 211 @ 269.
	a add: 213 @ 273.
	a add: 215 @ 277.
	a add: 216 @ 281.
	a add: 216 @ 285.
	a add: 218 @ 289.
	a add: 218 @ 293.
	a add: 218 @ 297.
	a add: 218 @ 301.
	a add: 218 @ 305.
	a add: 216 @ 309.
	a add: 216 @ 313.
	a add: 212 @ 317.
	a add: 212 @ 321.
	a add: 208 @ 325.
	a add: 204 @ 329.
	a add: 200 @ 333.
	a add: 198 @ 337.
	a add: 197 @ 338.
	a add: 196 @ 338.
	a add: 192 @ 340.
	a add: 191 @ 340.
	a add: 187 @ 340.
	a add: 183 @ 340.
	a add: 179 @ 340.
	a add: 175 @ 339.
	a add: 171 @ 339.
	a add: 167 @ 339.
	a add: 163 @ 337.
	a add: 159 @ 333.
	a add: 155 @ 331.
	a add: 151 @ 327.
	a add: 149 @ 323.
	a add: 147 @ 319.
	a add: 145 @ 315.
	a add: 145 @ 311.
	a add: 141 @ 307.
	a add: 139 @ 303.
	a add: 139 @ 299.
	a add: 137 @ 295.
	a add: 135 @ 291.
	a add: 133 @ 287.
	a add: 129 @ 283.
	a add: 125 @ 279.
	a add: 121 @ 275.
	a add: 117 @ 275.
	a add: 113 @ 271.
	a add: 112 @ 271.
	a add: 111 @ 271.
	a add: 107 @ 270.
	a add: 103 @ 270.
	a add: 99 @ 270.
	a add: 95 @ 268.
	a add: 91 @ 268.
	a add: 87 @ 268.
	a add: 83 @ 270.
	a add: 79 @ 270.
	a add: 75 @ 270.
	a add: 71 @ 270.
	a add: 67 @ 270.
	a add: 63 @ 270.
	a add: 59 @ 270.
	a add: 55 @ 270.
	a add: 51 @ 266.
	a add: 47 @ 266.
	a add: 43 @ 262.
	a add: 39 @ 260.
	a add: 35 @ 258.
	a add: 31 @ 254.
	a add: 29 @ 250.
	a add: 29 @ 246.
	a add: 27 @ 242.
	a add: 27 @ 238.
	a add: 27 @ 234.
	a add: 27 @ 230.
	a add: 27 @ 226.
	a add: 26 @ 222.
	a add: 26 @ 218.
	a add: 26 @ 214.
	a add: 26 @ 210.
	a add: 30 @ 206.
	a add: 30 @ 202.
	a add: 31 @ 198.
	a add: 33 @ 194.
	a add: 35 @ 190.
	a add: 37 @ 186.
	a add: 39 @ 182.
	a add: 41 @ 180.
	a add: 45 @ 176.
	a add: 49 @ 174.
	a add: 51 @ 172.
	a add: 55 @ 168.
	a add: 61 @ 165.
	a add: 65 @ 162.
	a add: 71 @ 159.
	a add: 77 @ 156.
	a add: 80 @ 150.
	a add: 86 @ 147.
	a add: 92 @ 145.
	a add: 96 @ 145.
	a add: 102 @ 143.
	a add: 106 @ 143.
	a add: 110 @ 143.
	a add: 116 @ 143.
	a add: 122 @ 143.
	a add: 128 @ 143.
	a add: 132 @ 145.
	a add: 136 @ 147.
	a add: 138 @ 151.
	a add: 142 @ 153.
	a add: 144 @ 155.
	a add: 146 @ 159.
	a add: 148 @ 161.
	a add: 152 @ 165.
	a add: 152 @ 169.
	a add: 156 @ 173.
	a add: 156 @ 177.
	a add: 156 @ 181.
	a add: 154 @ 185.
	a add: 154 @ 189.
	a add: 150 @ 193.
	a add: 148 @ 197.
	a add: 144 @ 201.
	a add: 144 @ 205.
	a add: 140 @ 207.
	a add: 139 @ 208.
	a add: 138 @ 208.
	a add: 137 @ 209.
	a add: 136 @ 209.
	a add: 135 @ 210.
	a add: 134 @ 210.
	a add: 133 @ 210.
	a add: 132 @ 211.
	a add: 131 @ 211.
	a add: 130 @ 211.
	a add: 129 @ 211.
	a add: 128 @ 212.
	a add: 127 @ 212.
	a add: 126 @ 212.
	a add: 125 @ 212.
	a add: 124 @ 212.
	a add: 124 @ 211.
	a add: 123 @ 211.
	a add: 122 @ 211.
	a add: 121 @ 210.
	a add: 120 @ 210.
	a add: 119 @ 210.
	a add: 118 @ 210.
	^a asArray! !

!SplittingDemo class methodsFor: 'random numbers'!

nextRandom
	| v |
	v _ (RandomStream next * 20.0) truncated - 4.
	v > 4 ifTrue: [v _ 0].
	^v!

nextRandomX
	| i |
	i _ RandomStream at: 1.
	i > (RandomStream at: 3) size ifTrue: [i _ RandomStream at: 1 put: 1].
	RandomStream at: 2 put: ((RandomStream at: 3) at: i).
	RandomStream at: 1 put: (i + 1).
	^(RandomStream at: 2) x!

nextRandomY
	^(RandomStream at: 2) y! !

!SplittingDemo class methodsFor: 'access'!

infoSize
	^700@280! !

SplittingDemo initialize!


ScriptGlyph subclass: #TwoProngTextGlyph
	instanceVariableNames: 'textGlyph left right offset '
	classVariableNames: 'CenterOffsetConstraint '
	poolDictionaries: ''
	category: 'Minstrel-SIGGRAPH'!


!TwoProngTextGlyph methodsFor: 'initialize-release'!

initialize
	"TwoProngTextGlyph releaseConstraints"

	super initialize.
	textGlyph _ TextGlyph new initialize.
	left _ PointGlyph new initialize.
	right _ PointGlyph new initialize.
	left moveTo: 10 @ 10.
	right moveTo: 100 @ 10.
	textGlyph moveTo: 40 @ 15.
	offset _ PointGlyph new initialize.
	offset moveTo: 10 @ 40.
	CenterOffsetConstraint isNil ifTrue: [CenterOffsetConstraint _ (Constraint names: #(out left right off ) methods: #('out _ ((left + right) // 2) - off' 'off _ ((left + right) // 2) - out' ))
					name: 'center offset'].
	StayConstraint
		var: offset xVar
		strength: #default.
	CenterOffsetConstraint copy
		var: textGlyph box leftVar
		var: left xVar
		var: right xVar
		var: offset xVar
		strength: #required.
	StayConstraint
		var: offset yVar
		strength: #default.
	CenterOffsetConstraint copy
		var: textGlyph box topVar
		var: left yVar
		var: right yVar
		var: offset yVar
		strength: #required!

left: l right: r string: s
	| stays |  
	stays _ Set new.
	stays add: (StayConstraint
		var: textGlyph box leftVar
		strength: #strongPreferred).
	stays add: (StayConstraint
		var: textGlyph box topVar
		strength: #strongPreferred).
	EqualityConstraint
		var: l xVar
		var: left xVar
		strength: #required.
	EqualityConstraint
		var: l yVar
		var: left yVar
		strength: #required.
	EqualityConstraint
		var: r xVar
		var: right xVar
		strength: #required.
	EqualityConstraint
		var: r yVar
		var: right yVar
		strength: #required.
	stays do: [:each | each destroyConstraint].
	textGlyph text: s! !

!TwoProngTextGlyph methodsFor: 'accessing'!

left ^left!

right ^right!

text
	^textGlyph! !

!TwoProngTextGlyph methodsFor: 'glyph protocol'!

boundingBox
	^textGlyph boundingBox!

displayOn: aDisplayMedium at: aDisplayPoint clip: clipBox 
	| r |
	r _ textGlyph box asRectangle moveBy: aDisplayPoint.
	(Line
		from: left asPoint
		to: r left @ r center y
		withForm: (Form extent: 1 @ 1) black)
		displayOn: aDisplayMedium
		at: aDisplayPoint.
	(Line
		from: right asPoint
		to: r right @ r center y
		withForm: (Form extent: 1 @ 1) black)
		displayOn: aDisplayMedium
		at: aDisplayPoint.
	aDisplayMedium fill: (r insetBy: -1 @ -1) mask: Form white.
	textGlyph
		displayOn: aDisplayMedium
		at: aDisplayPoint
		clip: clipBox.
	aDisplayMedium border: (r insetBy: -3 @ -3)
		width: 2.
	false ifTrue: [self stilltodo]!

isSelectable
	^true!

locationPoints
	^Array
		with: textGlyph box center"
		with: left asPoint
		with: right asPoint"! !

!TwoProngTextGlyph methodsFor: 'enumeration'!

selectableGlyphsDo: aBlock 
	aBlock value: self.
	aBlock value: textGlyph.
aBlock value: left.
aBlock value: right!

visibleGlyphsDo: aBlock 
	aBlock value: self.
	aBlock value: textGlyph! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

TwoProngTextGlyph class
	instanceVariableNames: ''!


!TwoProngTextGlyph class methodsFor: 'classification'!

glyphCategory
	^'SIGGRAPH'! !

!TwoProngTextGlyph class methodsFor: 'constraint release'!

releaseConstraints
	"TwoProngTextGlyph releaseConstraints"

	CenterOffsetConstraint _ nil! !


!UnaryConstraint methodsFor: 'initialize-release'!

var: aVariable primstrength: s
	strength _ s.
	output _ aVariable.
	satisfied _ false.
	self addConstraint.! !

TextGlyph subclass: #BoxTextGlyph
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Minstrel-SIGGRAPH'!


!BoxTextGlyph methodsFor: 'glyph protocol'!

boundingBox
	"Answer my bounding box."

	^((box left - 4)@(box top - 4)) corner:
		((box right + 4)@(box bottom + 4))!

displayOn: aDisplayMedium at: aDisplayPoint clip: clipBox
	| scanner  r |
	r _ box asRectangle moveBy: aDisplayPoint.
	scanner _ QuickPrint
		newOn: aDisplayMedium
		box: ((r topLeft) corner: clipBox bottomRight)
		font: font value.
	aDisplayMedium fill: (r insetBy: -1 @ -1) mask: Form white.
	aDisplayMedium border: (r insetBy: -3 @ -3)
		width: 2.
	scanner drawString: text value.! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

BoxTextGlyph class
	instanceVariableNames: ''!


!BoxTextGlyph class methodsFor: 'classification'!

glyphCategory
	^'SIGGRAPH'! !

Plus1Demo subclass: #Plus2Demo
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Minstrel-SIGGRAPH'!


!Plus2Demo methodsFor: 'initialize-release'!

createDefaults
	| ss |
	ss _ #(3 3 4 4 5 5 6 ).
	values with: ss do: [:each :s | StayConstraint new var: each primstrength: (Strength new initializeWith: 'special' , s printString and: s)]! !

!Plus2Demo methodsFor: 'public'!

open
	"Plus2Demo new open"

	| topView |
	topView _ SpecialSystemView
				model: nil
				label: 'Plus Demo With Hierarchy'
				minimumSize: 400 @ 300.
	topView borderWidth: 1; addSubView: (SceneView new initialize model: self).
	topView controller open! !

PointGlyph subclass: #SIGGRAPHAnchorGlyph
	instanceVariableNames: ''
	classVariableNames: 'AnchorForm '
	poolDictionaries: ''
	category: 'Minstrel-SIGGRAPH'!


!SIGGRAPHAnchorGlyph methodsFor: 'glyph protocol'!

boundingBox

	^(self rounded - (4@3)) extent: 6@6!

displayOn: aDisplayMedium at: aDisplayPoint clip: clipBox 
	AnchorForm
		displayOn: aDisplayMedium
		at: aDisplayPoint + self asPoint
		clippingBox: clipBox
		rule: Form paint
		mask: Form black! !

!SIGGRAPHAnchorGlyph methodsFor: 'merging'!

canMergeWith: aGlyph 
	^false!

changing
	"This is a hack to prevent the ugly black can-merge box from showing up around 
	my anchor."

	^true! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

SIGGRAPHAnchorGlyph class
	instanceVariableNames: ''!


!SIGGRAPHAnchorGlyph class methodsFor: 'class initialization'!

initialize
	"SIGGRAPHAnchorGlyph initialize."

	AnchorForm _ Form
			extent: 18 @ 19
			fromArray: #(480 0 1008 0 1008 0 480 0 192 0 192 0 192 0 192 0 192 0 8385 0 28867 32768 63687 49152 24769 32768 24769 32768 28867 32768 14535 0 7902 0 4092 0 1008 0 )
			offset: -10 @ -2.! !

!SIGGRAPHAnchorGlyph class methodsFor: 'classification'!

glyphCategory
	^'SIGGRAPH'! !

SIGGRAPHAnchorGlyph initialize!


Scene subclass: #ThreePlanetDemo
	instanceVariableNames: 'theta1 r1 theta2 r2 '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Minstrel-SIGGRAPH'!
ThreePlanetDemo comment:
'							***** Animation (Orbiting Planetoids) *****

Constraints are especially useful for two aspects of graphics: static layout and dynamic behavior.  Constraints can be used to declaratively specify the layout of various graphical objects to ensure that positioning and other relations are maintained.  Perhaps more interesting, though, is the use of constraints to define dynamic behavior, e.g., animations.  Constraints are a natural mechanism for describing physical laws (even imaginary "Wiley E. Coyote" ones).  

These two demos illustrate the use of simple animation constraints.  In the fake-gravity demo, the slides control the orbit radius of the two planets and simple computation is used to find the next position of each planet.  Interestingly enough, the animation can continue while the user is interacting with the system---after all, the user''s interaction is implemented by constraints and the animation is implemented by constraints, thus the system can automatically solve the two sets together.  Thus the user can move the slider while the planets orbit.  However, the user can also grab any planet and drag it around and the other planets will continue their orbits, although now centered on the user''s planet.  This "re-centering" is because the user''s interaction constraint is stronger than the rest.

In the real-gravity demo, the slider control gravity and the four vectors illustrate the acceleration and velocity of the two planets.  All of the constraints are multi-directional, thus if the planets are dragged around, the vectors will indicate the velocity and acceleration of the mouse!!  And, if the velocity vector is dragged around, the acceleration and planet motion will match, and so on.  Unfortunately, it is very difficult to get the planets to orbit (or to do anything at all) which is why the fake-gravity demo is also supplied.
'!


!ThreePlanetDemo methodsFor: 'initialize-release'!

create
	| p1 p2 p3 h1 h2 c2 c3 |
	Transcript cr; show: 'Building the ', self class name, '..'.
	theta1 _ FreeVariable value: 0.0.
	r1 _ FreeVariable value: 100.0.
	theta2 _ FreeVariable value: 0.0.
	r2 _ FreeVariable value: 40.0.
	Transcript cr; show: '..adding planets'.
	p1 _ PlanetGlyph new initialize.
	p1 form1.
	p1 moveTo: 250 @ 210.
	p2 _ PlanetGlyph new initialize.
	p2 form2.
	p2 moveTo: 150 @ 210.
	p3 _ PlanetGlyph new initialize.
	p3 form3.
	p3 moveTo: 110 @ 210.
	self addGlyph: p1; addGlyph: p2; addGlyph: p3.
	Transcript cr; show: '..adding control sliders'.
	h1 _ (HSliderGlyph on: r1) minVal: 0.1; maxVal: 200.0; value: 100.0; moveTo: 150 @ 400.
	h2 _ (HSliderGlyph on: r2) minVal: 0.1; maxVal: 200.0; value: 40.0; moveTo: 360 @ 400.
	self addGlyph: h1; addGlyph: h2.
	Transcript cr; show: '..adding interface constraints'.
	StayConstraint var: p1 xVar strength: #default.
	StayConstraint var: p1 yVar strength: #default.
	c2 _ Constraint
			names: #(theta r xp xs )
			methods: #('xp _ xs + (r * theta cos)' 'xs _ xp - (r * theta cos)' ).
	c3 _ Constraint
			names: #(theta r yp ys )
			methods: #('yp _ ys + (r * theta sin)' 'ys _ yp - (r * theta sin)' ).
	(Constraint
			names: #(theta pretheta r )
			methods: #('theta _ pretheta + (5.0/r)' ))
		var: theta1 var: theta1 last var: r1 strength: #required.
	c2 copy var: theta1 var: r1 var: p1 xVar var: p2 xVar strength: #required.
	c3 copy var: theta1 var: r1 var: p1 yVar var: p2 yVar strength: #required.
	(Constraint
			names: #(theta pretheta r )
			methods: #('theta _ pretheta + (10.0/r)' ))
		var: theta2 var: theta2 last var: r2 strength: #required.
	c2 copy var: theta2 var: r2 var: p2 xVar var: p3 xVar strength: #required.
	c3 copy var: theta2 var: r2 var: p2 yVar var: p3 yVar strength: #required.
	Transcript cr; show: 'finished'!

initialize
	super initialize.
	self create! !

!ThreePlanetDemo methodsFor: 'public'!

open
	"ThreePlanetDemo new open"

	| topView |
	topView _ SpecialSystemView
				model: nil
				label: 'Planet Demo (Fake Gravity)'
				minimumSize: 525 @ 425.
	topView borderWidth: 1; addSubView: (SceneView new initialize model: self).
	topView controller open! !

!ThreePlanetDemo methodsFor: 'testing'!

isAnimated
	^true! !

!ThreePlanetDemo methodsFor: 'background processing'!

computeBackgroundPlan
	^Planner extractPlanFromVariables: (Array with: theta1 with: theta2)! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

ThreePlanetDemo class
	instanceVariableNames: ''!


!ThreePlanetDemo class methodsFor: 'access'!

infoSize
	^600@360! !


!Strength methodsFor: 'private'!

initializeWith: symVal and: numVal
	symbolicValue _ symVal.
	arithmeticValue _ numVal! !

Scene subclass: #AnchorLine2Demo
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Minstrel-SIGGRAPH'!


!AnchorLine2Demo methodsFor: 'initialize-release'!

create
	| l f |
	Transcript cr; show: 'Building the ' , self class name , '..'.
	Transcript cr; show: '..adding the components'.
	f _ SIGGRAPHAnchorGlyph new initialize.
	l _ LineGlyph new.
	l moveTo: 100 @ 100.
	self addGlyph: f; addGlyph: l.
	Transcript cr; show: '..adding the consistency constraints'.
	EqualityConstraint
		var: l p1 yVar
		var: l p2 yVar
		strength: #required.
	EqualityConstraint
		var: l p1 xVar
		var: f xVar
		strength: #required.
	EqualityConstraint
		var: l p1 yVar
		var: f yVar
		strength: #required.
	StayConstraint var: f xVar strength: #strongPreferred.
	StayConstraint var: f yVar strength: #strongPreferred.
	Transcript cr; show: 'finished'!

initialize
	super initialize.
	self create! !

!AnchorLine2Demo methodsFor: 'public'!

open
	"AnchorLine2Demo new open"

	| topView |
	topView _ SpecialSystemView
				model: nil
				label: 'Horizontal Line, Anchor'
				minimumSize: 300 @ 200.
	topView borderWidth: 1; addSubView: (SceneView new initialize model: self).
	topView controller open! !

SceneController subclass: #MacDrawDemoController
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Minstrel-SIGGRAPH'!

