
#include "global.h"


/*
 *  Stack functions for path consistency where only edges have to be stored.
 *  Push stores an edge on the stack and marks it as being on the stack.  If it
 *  is already on the stack, it is not added again.  Pop removes the top edge
 *  from the stack and unmarks it appropriately.  The stack_empty macro returns
 *  whether the stack is empty or not.
 */
#define push(x,y)	{\
				if( !on_stack[x][y] ) {\
					top++;\
					stack[top][0] = x;\
					stack[top][1] = y;\
					on_stack[x][y] = 1;\
					on_stack[y][x] = 1;\
				}\
			}

#define pop(x,y)	{\
				x = stack[top][0];\
				y = stack[top][1];\
				on_stack[x][y] = 0;\
				on_stack[y][x] = 0;\
				top--;\
			}

#define init_stack()	{\
				top = 0;\
				for( i = 1; i <= n; i++ )\
				for( j = 1; j <= n; j++ )\
					on_stack [i][j] = 0;\
			}

#define stack_empty()	(top == 0)


static int stack[(N*(N+1))/2][2], on_stack[N][N], top = 0;


static int
compose_and_intersect( C, i, k, j, d )
	NETWORK	C;
	int	i, k, j, d;
{
	register int	a, b, c, result;
	int		changes = 0;


	for( a = 0; a < d; a++ )
	for( b = 0; b < d; b++ ) {
		if( C [i][j][a][b] == 1 ) {

			result = (C [i][k][a][0] &
				  C [k][k][0][0] &
				  C [k][j][0][b]);

			for( c = 1; !result && c < d; c++ )
				result /*|*/= (C [i][k][a][c] &
					   C [k][k][c][c] &
					   C [k][j][c][b]);

			if( result == 0 ) {
				changes++;
				C [i][j][a][b] = 0;
				C [j][i][b][a] = 0;	/* inverse */
			}
		}
	}

	return( changes );
}


static void
detUs( C, U, n, k )
	NETWORK	C;
	int	U [N][N], n, k;
{
	int	i, j, a, b, all_ones;

	for( i = 1; i <= n; i++ )
	for( j = 1; j <= n; j++ ) {

		all_ones = 1;
		for( a = 0; a < k; a++ )
		for( b = 0; b < k && all_ones; b++ )
			all_ones = all_ones & (C [i][j][a][b] == 1);

		U [i][j] = all_ones;
	}
}


/*
 *  Path consistency algorithm.
 */
int
pre_path( C, n, d )
	NETWORK	C;
	int	n, d;
{
	int	i, j, k, a, U [N][N];


	init_stack();

	detUs( C, U, n, d );

	/*
	 *  First apply Floyd-Warshall version of path consistency,
	 *  pushing any edges that have changed.
	 */
	for( k = 1; k <= n; k++ )
	for( i = 1; i <= n; i++ ) if( !U [i][k] )
	for( j = i; j <= n; j++ ) if( !U [k][j] ) {

		if( compose_and_intersect( C, i, k, j, d ) ) {
			push( i, j );
			U [i][j] = 0;
			U [j][i] = 0;
		}
	}

	/*
	 *  Now process the edges that were pushed.
	 */
	while( !stack_empty() ) {
		pop( i, j );
		for( k = 1; k <= n; k++ ) {
			if( !U [j][k] &&
			    compose_and_intersect( C, i, j, k, d ) ) {
				push (i, k);
				U [i][k] = 0;
				U [k][i] = 0;
			}

			if( !U [k][i] &&
			    compose_and_intersect( C, k, i, j, d ) ) {
				push( k, j );
				U [k][j] = 0;
				U [j][k] = 0;
			}
		}
	}

	for( k = 1; k <= n; k++ ) {
		count = 0;
		for (a = 0; a < d; a++)
			count += C[k][k][a][a];
		if (count == 0)
			return(0);
	}

	return( 1 );
}

