
#include "global.h"


/*
 *  Generate a consistent random (n x n) adjacency matrix representation,
 *  C, of a constraint satisfaction problem.  Each entry of C is a (k x k)
 *  binary matrix.  The CSP has n variables with domains of size k.
 *  An edge is labeled with a non-trivial constraint with independent
 *  probability p/100 and is labeled with U with probability (1-p/100).
 *  A non-trivial constraint is a random (0,1)-matrix where each entry
 *  is a 1 with independent probability q/100, and a 0 with probability
 *  (1-q/100).
 */
void
generate_S( C, n, k, p, q )
	NETWORK	C;
	int	n, k, p, q;
{
	int	i, j;
	int	soln [N];
	long	random();


	/*
	 *  generate a (possibly) inconsistent csp
	 */
	generate_R( C, n, k, p, q );

	/*
	 *  generate a random instantiation
	 */
	for( i = 1; i <= n; i++ )
		soln[i] = (random() % k);

	/*
	 *  adjust the constraints so that the
	 *  instantiation is a solution
	 */
	for( i = 1;   i <  n; i++ )
	for( j = i+1; j <= n; j++ ) {
		C[i][j][soln[i]][soln[j]] = 1;
		C[j][i][soln[j]][soln[i]] = 1;
	}
}

