
#include "global.h"


/*
 *  Generate the CSP for the n-queens problem.
 */
void
generate_Q( C, n, k )
	NETWORK	C;
	int	n, k;
{
	int	i, j, a, b;

	if (n > N || k > K) {
		printf("n or k too large\n");
		exit(6);
	}

	/*
	 *  Initialize the (0,1)-matrices.
	 */
	for( i = 1; i <= n; i++ )
	for( j = 1; j <= n; j++ )
		if( i == j ) {
			/*
			 *  Diagonal, so initialize to I.
			 */
			for( a = 0; a < k; a++ )
			for( b = 0; b < k; b++ ) {
				if( a == b )
					C [i][i][a][b] = 1;
				else
					C [i][i][a][b] = 0;
			}
		}
		else {
			/*
			 *  Initialize constraint.
			 */
			for( a = 0; a < k; a++ )
			for( b = 0; b < k; b++ ) {
				/* row attack or diagonal attack */
				if( a == b || abs(a-b) == abs(i-j) )
					C [i][j][a][b] = 0;
				else
					C [i][j][a][b] = 1;
			}
		}
}

