
#include "global.h"


/*
 *  Calculate the values of p and q of a constraint satisfaction
 *  network, C, where p is the percentage of edges that are labeled
 *  with non-trivial constraints and q is the average percentage of
 *  ones in the non-trivial constraints.  (A non-trivial constraint
 *  is a constraint with a last one zero in it.)
 */
void
analyze( C, n, k, p, q )
	NETWORK	C;
	int	n, k;
	double	*p, *q;
{
	int i, j, a, b, p_count, q_count, count;

	p_count = 0;
	q_count = 0;

	for( i = 1; i <= n; i++ )
	for( j = 1; j <  i; j++ ) {

		count = 0;
		for( a = 0; a < k; a++ )
		for( b = 0; b < k; b++ )
			count += C[i][j][a][b];

		if( count != (k * k) ) {
			p_count++;
			q_count += count;
		}
	}

	*p = (double)(100 * 2 * p_count) / (double)(n * (n - 1));
	if( p_count == 0 )
		*q = 0.0;
	else
		*q = (double)(100 * q_count) / (double)(p_count * k * k);
}

