#include "global.h"

 
 
/*
 * Comparison function for q_sort to order in descending order.  This ensures
 * that the variables with the larger heuristic values are processed first
 * by the backtracking algorithm.
 */
static int sort_compare(a, b)
struct info *a, *b;
{
    if (a->value > b->value)
        return(-1);
    else if (a->value < b->value)
        return(1);
    else return(0);
}


/*
 * Apply the heuristic to the actual graph by reordering the graph such that
 * solving the new graph in sequential order corresponds to solving the problem
 * in the order specified by the heuristic.  Note that the resulting graph is
 * copied back to the original graph.
 */
void apply_order(C, n, order)
NETWORK C;
int n;
struct info order[N];
{
    NETWORK temp;
    int i, j;

    for (i = 1; i <= n; i++)
        for (j = 1; j <= n; j++)
            temp[i][j] = C[order[i].index][order[j].index];
    for (i = 1; i <= n; i++)
        for (j = 1; j <= n; j++)
            C[i][j] = temp[i][j];
}


/*
 * Create an order to instantiate the variables by applying a heuristic to the
 * original problem.  First, calculate the heuristic value for each edge and
 * keep a running total for each variable as well.  Then order the variables
 * according to a one time sort.  Then, call the routine to actually change the
 * "C" matrix according to the results of the previous step.
 */
void order_variables(C, n)
NETWORK C;
int n;
{
    int i, j;
    struct info order[N];

    for (i = 1; i <= n;  i++) {
        order[i].index = i;
        order[i].value = 0;
        for (j = 1; j <= n; j++)
            if (C[i][j] == NE)
                order[i].value++;
    }
    qsort((char *)&order[1], n, sizeof(struct info), sort_compare);
    apply_order(C, n, order);
}
