#ifndef GLOBAL_H
#define GLOBAL_H


/*
 * General include files.
 */
#include <stdio.h>
#include <stdlib.h>


/* 
 * Change "VARS" to represent the maximum number of variables and change "K"
 * to the maximum domain sizes for each network.
 */
#define VARS      100
#define N         VARS + 1
#define K         5


/* 
 * Abstract data types to represent the constraint network, the constraints
 * along each edge, and the solution.
 */
typedef int   NETWORK[N][N];
typedef int   SOLUTION[N];


/* 
 * Type definition for the two types of timer available in the program.
 */
typedef enum type_timer {REAL, VIRTUAL} TIMER_TYPE;


/*
 * Definitions for the different type of constraints available for an edge.
 * An "I" means an identity constraint, a NE means an identity constraint with
 * the 0's and 1's switched, and a U means a constraint with all 1's.
 */
#define I    -1
#define NE    0
#define U     1


/* 
 * Structure to hold information for heuristics with variable ordering.
 */
struct info {
    int index, value;
};


/* 
 * Truncated function prototyping for the available backtracking methods.
 * These methods should not be called directly but rather through the
 * "backtrack" function.
 */
int FC_GBJ();
int FC_arc();


/* 
 * Other function prototypes for cross-file compilation.
 */
int time_expired();
void backtrack();
void order_variables();
void generate();
void process_solution();
void start_time();
double stop_time();


/* 
 * External declarations for cross-file access to global variables.
 */
extern unsigned int checks;


#endif
