/*
Copyright (C) 1992 University of Maryland.

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies, and
that both that copyright notice and this permission notice appear
in supporting documentation.  The author makes no representations
about the suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty. Your use of
this software signifies that you are willing to take the risks of
using this software by yourself.

THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE
USE OR PERFORMANCE OF THIS SOFTWARE.
*/

/* tonum.c */

/* This program sort and convert state symbols to state numbers. */

#include <stdio.h>

char board[500][6], temp[6];
int stack[6];
int states = 8, count, used;
int svalue();
int val();

char *symbols[] = {
".", "%", "x", "+", "@", "$", "o", "#", ";", ":"
};

main(argc, argv)
int argc;
char *argv[];
{
  int i, j, k, save;
  int nn;
  char buf[100];
  
  for (i=1; i<argc; i++) {
    if (*argv[i] == '-')
      switch (argv[i][1]) {
      case 'n':
	i++;
	for (j=0; j<10 && argv[i][j]!='\0'; j++)
	  *(symbols[j]) = argv[i][j];
	if (argv[i][j]!='\0')
	  printf("%s: extra symbols %s ignored (max. 10 states allowed)!\n",
		 argv[0], &(argv[i][j]));
	states = j;
	continue;
      case 'i':
	i++;
	nn = atoi(argv[i]);
	continue;
      }
    printf("%s: unknown option %s ignored.\n", argv[0], argv[i]);
  }

  count = 0; used = 0;
  while (fgets(buf, 100, stdin)) {
    if (strncmp(buf+6, "->", 2)==0) {
      sscanf(buf, "%c%c%c%c%c -> %c", &temp[0], &temp[1], &temp[2], 
	     &temp[3], &temp[4], &temp[5]);
      for (i=0; i<6; i++)
	board[count][i] = svalue(temp[i]);
      count++;
    }
  }
  for (i=0; i<6; i++)
    board[count][i] = -1;

  for (i=0; i<count-1; i++)
    for (j=i+1; j<count; j++)
      if (val(i) > val (j)) {
 	for (k=0; k<6; k++)
	  temp[k] = board[i][k];
	for (k=0; k<6; k++)
	  board[i][k] = board[j][k];
	for (k=0; k<6; k++)
	  board[j][k] = temp[k];
      }
  for (j=0, i=0; i<count; i++) {
    printf("%d", val(i));
    printf("\t%d\n", board[i][5]);
    j++;
  }
}

int svalue(i)
char i;
{
  int j;

  for (j=0; j<states; j++)
    if (*symbols[j]==i) 
      return j;
  printf("unrecognized symbol %c in svalue!\n", i);
  exit(0);
}

int val(i)
int i;
{
  return (((int)board[i][0]) |
    ((int)board[i][1] <<3) |
    ((int)board[i][2] <<6) | 
    ((int)board[i][3] <<9) |
    ((int)board[i][4] <<12));
}


