/*
Copyright (C) 1992 University of Maryland.

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies, and
that both that copyright notice and this permission notice appear
in supporting documentation.  The author makes no representations
about the suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty. Your use of
this software signifies that you are willing to take the risks of
using this software by yourself.

THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE
USE OR PERFORMANCE OF THIS SOFTWARE.
*/

/* par.c */

/* This is an implementation of another rule compression algorithm. */
 /* This should run faster than ck, but the result is not as good as */
 /* that of ck. It doesn't use exhaustive recursive search. */

 /* Provided for reference only. It is not recommended to use this */
 /* program. */

#include <stdio.h>

char board[500][6], temp[6];
int stack[6];
int states = 8, count, used;
int svalue();
void par();

char *symbols[] = {
".", "*", "L", "+", "-", "X", "O", "#", ";", ":"
};

main(argc, argv)
int argc;
char *argv[];
{
  int i, j, save;
  char buf[100];
  
  for (i=1; i<argc; i++) {
    if (*argv[i] == '-')
      switch (argv[i][1]) {
      case 'n':
	i++;
	for (j=0; j<10 && argv[i][j]!='\0'; j++)
	  *(symbols[j]) = argv[i][j];
	if (argv[i][j]!='\0')
	  printf("%s: extra symbols %s ignored (max. 10 states allowed)!\n",
		 argv[0], &(argv[i][j]));
	states = j;
	continue;
      }
    printf("%s: unknown option %s ignored.\n", argv[0], argv[i]);
  }

  count = 0; used = 0;
  while (fgets(buf, 100, stdin)) {
    if (strncmp(buf+6, "->", 2)==0) {
      sscanf(buf, "%c%c%c%c%c -> %c", &temp[0], &temp[1], &temp[2], 
	     &temp[3], &temp[4], &temp[5]);
      for (i=0; i<6; i++)
	board[count][i] = svalue(temp[i]);
      count++;
    }
  }
  for (i=0; i<6; i++)
    board[count][i] = -1;
/*
  for (i=count-1, save = count; i>=0; i--)
    if (board[i][0] == board[i][5]) {
      save--;
      for (j=0; j<6; j++) {
	temp[j] = board[i][j]; board[i][j] = board[save][j];
	board[save][j] = temp[j];
      }
    }
*/
  stack[0] = 5;
  par(0, count, 0, 5);
/*
  for (i=0; i<count; i++) {
    printf("%c%c%c%c%c -> %c\n", *symbols[board[i][0]], *symbols[board[i][1]],
	   *symbols[board[i][2]], *symbols[board[i][3]], 
	   *symbols[board[i][4]], *symbols[board[i][5]]);
  }
*/
  fprintf(stderr, "count = %d, used = %d\n", count, used);
}

int svalue(i)
char i;
{
  int j;

  for (j=0; j<states; j++)
    if (*symbols[j]==i) 
      return j;
  printf("unrecognized symbol %c in svalue!\n", i);
  exit(0);
}

void par(l, r, d, key)
int l, r, d, key;
{
  int i, j, a, longer[6], max, sc[10], ll, rr;
  char sym;

  for (i=l; i<r-1; i++)
    for (j=i+1; j<r; j++)
      if (board[i][key]>board[j][key]) {
	for (a=0; a<6; a++) {
	  temp[a] = board[i][a]; board[i][a] = board[j][a];
	  board[j][a] = temp[a];
	}
      }
  if (d>=5) {
    for (i=l; i<r; i++)
      printf("%c%c%c%c%c -> %c\n", *symbols[board[i][0]], 
	     *symbols[board[i][1]],
	     *symbols[board[i][2]], *symbols[board[i][3]], 
	     *symbols[board[i][4]], *symbols[board[i][5]]);
    used += r-l;
    return;
  }
  ll=rr=l;
  while (rr<r) {
    sym = board[ll][key];
    while (board[rr][key]==sym && rr<r) rr++;
    if (key!=5) {
      sym = board[ll][5]; a = 0;
      for (i=0; i<count; i++)
	if (board[i][5]!=sym) {
	  for (j=1; j<=d; j++)
	    if (board[i][stack[j]]!=board[ll][stack[j]])
	      break;
	  if (j>d) {
	    a = 1; break;
	  }
	}
      if (a==0) {
	for (i=0; i<6; i++)
	  longer[i]=0;
	for (i=0; i<=d; i++)
	  longer[stack[i]] = 1;
	for (i=0; i<5; i++)
	  if (longer[i])
	    printf("%c", *symbols[board[ll][i]]);
	  else
	    printf("_");
	printf(" -> %c\n", *symbols[board[ll][5]]);
	ll = rr;
	used++;
	continue;
      }
    }
    for (i=0; i<6; i++)
      longer[i]=0;
    for (i=0; i<6; i++) {
      for (j=0, a=0; j<=d; j++)
	if (stack[j] == i) {
	  a = 1;
	  break;
	}
      if (a) 
	continue;
      for (j=0; j<states; j++)
	sc[j]=0;
      for (j=ll; j<rr; j++)
	sc[board[j][i]]++;
      for (max=0, j=0; j<states; j++)
	if (sc[j]>max)
	  max = sc[j];
      longer[i]=max;
    }
    for (i=0, j=0, max=0; i<6; i++)
      if (longer[i]>max) {
	max = longer[i];
	j = i;
      }
    stack[d+1] = j;
    par(ll, rr, d+1, j);
    ll = rr;
  }
}

