/*
 * File: heat.v256.c
 *   By: Dave Hiebeler
 *       hiebeler@turing.cs.rpi.edu
 *       August 1989
 *
 * The "heat" rule in the von-Neumann neighborhood.  See the "heat.m256.c"
 * file for more information on the heat rule itself.
 *
 * Try this with parm1 = 100 and parm2 = 2, starting from the "heat.64x"
 * image.
 */

#include "nborhood.h"

byte vonn_heat();

void
init_function()
{
    update_function = vonn_heat;
}


byte
vonn_heat(nbors)
vonn_nbors *nbors;
{
    int heat_avg;

    Get_vonn_nbors;
    
    heat_avg = (l + c + r + t + b) / 5;
    return (c + (heat_avg - c) * parm1 / 100 + parm2) % 256;
}
