(* Terminal Symbols *)

(* Interface between lexer and parser *)
(* Author: Frank Pfenning <fp@cs.cmu.edu> *)

signature TERMINAL =
sig

datatype terminal =
         LPAREN | RPAREN | LBRACE | RBRACE
       | EQ | COLON | COMMA | BAR | RIGHTARROW | LEFTARROW | SEMICOLON
       | LOLLI | STAR | PLUS | AMPERSAND | ONE
       | SEND | RECV | FWD | CALL
       | TYPE | PROC | EXEC | FAIL
       | IDENT of string | TAG of string
       | EOF | LEX_ERROR

val toString : terminal -> string

end

structure Terminal :> TERMINAL =
struct

datatype terminal =
         LPAREN | RPAREN | LBRACE | RBRACE
       | EQ | COLON | COMMA | BAR | RIGHTARROW | LEFTARROW | SEMICOLON
       | LOLLI | STAR | PLUS | AMPERSAND | ONE
       | SEND | RECV | FWD | CALL
       | TYPE | PROC | EXEC | FAIL
       | IDENT of string | TAG of string
       | EOF | LEX_ERROR

fun toString t =
    case t
     of LPAREN => "(" | RPAREN => ")"
      | LBRACE => "{" | RBRACE => "}"
      | EQ => "=" | COLON => ":" | COMMA => "," | BAR => "|" | RIGHTARROW => "=>"
      | LEFTARROW => "<-" | SEMICOLON => ";"
      | LOLLI => "->" | STAR => "*" | PLUS => "+" | AMPERSAND => "&" | ONE => "1"
      | SEND => "send" | RECV => "recv" | FWD => "fwd" | CALL => "call"
      | TYPE => "type" | PROC => "proc" | EXEC => "exec" | FAIL => "fail"
      | IDENT(s) => s | TAG(k) => "'" ^ k
      | EOF => "<eof>" | LEX_ERROR => "<lex error>"

end (* structure Terminal *)
