(* Flags *)
(* Author: Frank Pfenning <fp@cs.cmu.edu> *)

(*
 * User option given on the command line or in the
 * #options pragma in the source file, plus the
 * version number and date
 *)

signature FLAGS =
sig
    val subtp : bool ref
    val depth : int option ref
    val parseDepth : string -> int option

    val verbosity : int ref
    val help : bool ref

    (* reset all flags to their default value *)
    val reset : unit -> unit

    val version : string
end  (* signature FLAGS *)

structure Flags :> FLAGS =
struct

val verbosity = ref 1           (* ~1 = print nothing, 0 = quiet, 1 = normal, 2 = verbose, 3 = debug *)
val help = ref false

val subtp = ref false           (* true = admit subtyping *)
val depth : int option ref = ref NONE (* SOME(d) = only observe results to depth d *)
fun parseDepth str = Int.fromString str (* negative: no depth *)

fun reset () =
    ( verbosity := 1
    ; subtp := false
    ; depth := NONE
    ; help := false )

val version = "sax v0.1 (Nov 2 2023)"

end (* structure Flags *)
