(* Flags *)
(* Author: Frank Pfenning <fp@cs.cmu.edu> *)

(*
 * User option given on the command line or in the
 * #options pragma in the source file, plus the
 * version number and date
 *)

signature FLAGS =
sig
    val verbosity : int ref
    val help : bool ref

    (* reset all flags to their default value *)
    val reset : unit -> unit

    val version : string
end  (* signature FLAGS *)

structure Flags :> FLAGS =
struct

val verbosity = ref 1           (* ~1 = print nothing, 0 = quiet, 1 = normal, 2 = verbose, 3 = debug *)
val help = ref false

fun reset () =
    ( verbosity := 1
    ; help := false )

val version = "mpass v0.2 (Sep 19 2023)"

end (* structure Flags *)
