
structure ExtSyn =
struct

type tpname = string
type label = string
type procname = string
type varname = string
type ext = Mark.ext option      (* option extent = source region info *)

datatype chan = Var of varname

datatype tp = TpName of tpname
            | Plus of (label * tp) list
            | Tensor of tp * tp
            | One
            | With of (label * tp) list
            | Lolli of tp * tp

datatype msg = Label of label
             | Unit
             | Channel of chan

datatype proc = Send of chan * msg * proc option
              | Recv of chan * match
              | Fwd of chan * chan
              | Call of procname * chan * chan list
              | Cut of chan * tp option * proc * proc
              | Marked of proc Mark.marked

     and match = MatchLabel of (label * proc) list
               | MatchUnit of proc
               | MatchChannel of chan * proc

datatype parm = Tp of chan * tp

datatype def = TpDef of tpname * tp * ext
             | ProcDef of procname * parm * parm list * proc * ext
             | Exec of procname * ext
             | Fail of def * ext
             | Error of ext

type env = def list

end (* structure ExtSyn *)
