(* The autograder will give "optimistic" points if
 * you give NONE as an answer to a tasks, since no
 * all tasks have solutions.  You will note this in
 * your hw2.pdf file.
 *
 * task0 is not a real task, but it gives you a template.
 * You can find more examples in src/test.sml
 *)

structure HW2 :> HW2 =
struct

open Ordered

val A = Atom("A")
val B = Atom("B")
val C = Atom("C")

(*
 * examples by playing through Lambek's law
 * Task 0: A -> (B -> C) -||- B -> (A -> C)
 * Ordered version that is provable in both directions
 * A \ (C / B) -||- (A \ C) / B
 *
 * You can test the first one, for example, with

% cd src
% sml

CM.make "sources.cm";
open Ordered;
val A = Atom("A");
val B = Atom("B");
val C = Atom("C");
val left_to_right = 
    entails [Avail("acb", Under(A, Over(C, B)))]
            (OverR(Bind("b",UnderR(Bind("a",UnderL("acb", Id("a"),
                Bind("cb", OverL("cb", Id("b"), Bind("c", Id("c"))))))))))
            (Over(Under(A,C),B));

 *
 * this prints the base sequent followed by the proof term
 *

(acb : A \ (C / B)) |- (A \ C) / B
/R (b. \R (a. \L acb (Id a) (cb. /L cb (Id b) (c. Id c))))

 *
 *)

val task0a = SOME([Avail("acb", Under(A, Over(C, B)))],
                  OverR(Bind("b",UnderR(Bind("a",UnderL("acb", Id("a"),
                    Bind("cb", OverL("cb", Id("b"), Bind("c", Id("c"))))))))),
                  Over(Under(A,C),B))
val task0b = SOME([Avail("acb",Over(Under(A,C),B))],
                  UnderR(Bind("a",OverR(Bind("b",OverL("acb", Id("b"),
                    Bind("ac", UnderL("ac", Id("a"), Bind("c", Id("c"))))))))),
                  Under(A, Over(C, B)))

val task1a = NONE
val task1b = NONE

val task2a = NONE
val task2b = NONE

val task3a = NONE
val task3b = NONE

val task4a = NONE
val task4b = NONE

val task5a = NONE
val task5b = NONE

end
