signature TRANS =
sig

    val o2l : Ordered.prop -> Linear.prop
    val o2lp : Ordered.proof -> Linear.proof
    val O2L : Ordered.state -> Linear.state

    val l2s : Linear.prop -> Structural.prop
    val l2sp : Linear.proof -> Structural.proof
    val L2S : Linear.state -> Structural.state

    val o2s : Ordered.prop -> Structural.prop
    val o2sp : Ordered.proof -> Structural.proof
    val O2S : Ordered.state -> Structural.state

    val approx : Ordered.prop -> Structural.prop -> bool

end

structure Trans :> TRANS =
struct

structure O = Ordered
structure L = Linear
structure S = Structural

fun o2l (O.Atom(P)) = L.Atom(P)
  | o2l (O.Under(A,B)) = L.Lolli(o2l A, o2l B)
  | o2l (O.Over(B,A)) = L.Lolli(o2l A,o2l B)
  | o2l (O.Fuse(A,B)) = L.Tensor(o2l A, o2l B)
  | o2l (O.Twist(A,B)) = L.Tensor(o2l A, o2l B)
  | o2l (O.With(A,B)) = L.With(o2l A, o2l B)
  | o2l (O.One) = L.One
  | o2l (O.Plus(A,B)) = L.Plus(o2l A, o2l B)

fun o2lp (O.Id(x)) = L.Id(x)
  | o2lp (O.UnderR(xM)) = L.LolliR(o2lb xM)
  | o2lp (O.UnderL(x,M,yP)) = L.LolliL(x, o2lp M, o2lb yP)
  | o2lp (O.OverR(xM)) = L.LolliR(o2lb xM)
  | o2lp (O.OverL(x,M,yP)) = L.LolliL(x, o2lp M, o2lb yP)
  | o2lp (O.FuseR(M,N)) = L.TensorR(o2lp M, o2lp N)
  | o2lp (O.FuseL(x,yzP)) = L.TensorL(x, o2lbb yzP)
  | o2lp (O.TwistR(M,N)) = L.TensorR(o2lp M, o2lp N)
  | o2lp (O.TwistL(x,O.Bind2(z,y,P))) = L.TensorL(x, L.Bind2(y, z, o2lp P))
  | o2lp (O.WithR(M,N)) = L.WithR(o2lp M, o2lp N)
  | o2lp (O.WithL1(x,yP)) = L.WithL1(x, o2lb yP)
  | o2lp (O.WithL2(x,yP)) = L.WithL2(x, o2lb yP)
  | o2lp (O.OneR) = L.OneR
  | o2lp (O.OneL(x,M)) = L.OneL(x, o2lp M)
  | o2lp (O.PlusR1(M)) = L.PlusR1(o2lp M)
  | o2lp (O.PlusR2(N)) = L.PlusR2(o2lp N)
  | o2lp (O.PlusL(x,yP,zQ)) = L.PlusL(x, o2lb yP, o2lb zQ)
and o2lb (O.Bind(x,M)) = L.Bind(x, o2lp M)
and o2lbb (O.Bind2(x,y,M)) = L.Bind2(x,y, o2lp M)

fun o2la (O.Avail(x,A)) = L.Avail(x,o2l A)

fun O2L Omega = List.map o2la Omega

fun l2s (L.Atom(P)) = S.Atom(P)
  | l2s (L.Lolli(A,B)) = S.Implies(l2s A, l2s B)
  | l2s (L.Tensor(A,B)) = S.And(l2s A, l2s B)
  | l2s (L.With(A,B)) = S.And(l2s A, l2s B)
  | l2s (L.One) = S.True
  | l2s (L.Plus(A,B)) = S.Or(l2s A, l2s B)

fun l2sp (L.Id(x)) = S.Id(x)
  | l2sp (L.LolliR(xM)) = S.ImpliesR(l2sb xM)
  | l2sp (L.LolliL(x,M,yP)) = S.ImpliesL(x, l2sp M, l2sb yP)
  | l2sp (L.TensorR(M,N)) = S.AndR(l2sp M, l2sp N)
  | l2sp (L.TensorL(x, yzP)) = S.AndL(x, l2sbb yzP)
  | l2sp (L.WithR(M,N)) = S.AndR(l2sp M, l2sp N)
  | l2sp (L.WithL1(x,yP)) = S.AndL1(x, l2sb yP)
  | l2sp (L.WithL2(x,yP)) = S.AndL2(x, l2sb yP)
  | l2sp (L.OneR) = S.TrueR
  | l2sp (L.OneL(x,M)) = S.TrueL(x, l2sp M)
  | l2sp (L.PlusR1(M)) = S.OrR1(l2sp M)
  | l2sp (L.PlusR2(N)) = S.OrR2(l2sp N)
  | l2sp (L.PlusL(x,yP,zQ)) = S.OrL(x, l2sb yP, l2sb zQ)
and l2sb (L.Bind(x,M)) = S.Bind(x, l2sp M)
and l2sbb (L.Bind2(x,y,M)) = S.Bind2(x, y, l2sp M)

fun l2sa (L.Avail(x,A)) = S.Ante(x, l2s A)

fun L2S Delta = List.map l2sa Delta

val o2s = l2s o o2l
val o2sp = l2sp o o2lp
val O2S = L2S o O2L

fun approx (O.Atom(P)) (S.Atom(Q)) = (P = Q)
  | approx (O.Under(A1,A2)) (S.Implies(B1,B2)) = approx A1 B1 andalso approx A2 B2
  | approx (O.Over(A2,A1)) (S.Implies(B1,B2)) = approx A1 B1 andalso approx A2 B2
  | approx (O.Fuse(A1,A2)) (S.And(B1,B2)) = (approx A1 B1 andalso approx A2 B2)
                                            orelse (approx A1 B2 andalso approx A2 B1)
  | approx (O.Twist(A1,A2)) (S.And(B1,B2)) = (approx A1 B1 andalso approx A2 B2)
                                             orelse (approx A1 B2 andalso approx A2 B1)
  | approx (O.With(A1,A2)) (S.And(B1,B2)) = approx A1 B1 andalso approx A2 B2
  | approx (O.One) (S.True) = true
  | approx (O.Plus(A1,A2)) (S.Or(B1,B2)) = approx A1 B1 andalso approx A2 B2
  | approx A B = false

end (* structure Trans *)
