(* other tests *)
(* still to be unified with test.sml *)

structure LinearTest =
struct

open Linear

val A = Atom("A")
val B = Atom("B")
val C = Atom("C")
val a = "a"
val b = "b"
val c = "c"

val A1 = Lolli(A, A)
val M1 = LolliR(Bind("a", Id("a")))
val Delta1 = check [] M1 A1
val () = print (pp_proof M1 ^ " : " ^ pp_prop A1 ^ "\n")

val false = entails [Avail("ab",Tensor(A,B))] (TensorL("ab", Bind2("a", "b", TensorR(Id("a"), Id("b"))))) (Tensor(B,A))
            handle Fail(msg) => (TextIO.print(msg ^ "\n") ; false)
val true = entails [Avail("ab",Tensor(A,B))] (TensorL("ab", Bind2("a", "b", TensorR(Id("a"), Id("b"))))) (Tensor(A,B))

val true = entails [Avail("ab",With(A,B))] (WithR(WithL2("ab",Bind("b",Id("b"))), WithL1("ab", Bind("a",Id("a")))))
                   (With(B,A))

val true = entails [Avail("ac", Lolli(A, Lolli(One, C)))]
                   (LolliR(Bind("o", LolliR(Bind("a",
                       OneL("o", LolliL("ac", Id("a"), Bind("oc", LolliL("oc", OneR, Bind(c, Id(c)))))))))))
                   (Lolli(One, Lolli(A, C)))

val false = entails [Avail("ac", Lolli(A, Lolli(One, C)))]
                   (LolliR(Bind("o", LolliR(Bind("a",
                       LolliL("ac", Id("a"), Bind("oc", LolliL("oc", OneR, Bind(c, Id(c))))))))))
                   (Lolli(One, Lolli(A, C)))
            handle Fail(msg) => ( print (msg ^ "\n") ; false )

val true = entails [Avail("ac", Lolli(A, Lolli(One, C)))]
                   (LolliR(Bind("o", LolliR(Bind("a",
                       LolliL("ac", Id("a"), Bind("oc", LolliL("oc", OneR, Bind(c, OneL("o", Id(c)))))))))))
                   (Lolli(One, Lolli(A, C)))
            handle Fail(msg) => ( print (msg ^ "\n") ; false )

val false = entails [Avail("oab", Tensor(One, Plus(A, B)))]
                    (TensorL("oab", Bind2("o", "ab", PlusL("ab", Bind("a", PlusR1(Id("a"))), Bind("b", OneL("o", PlusR2(Id("b"))))))))
                    (Plus(A,B))
            handle Fail(msg) => ( print (msg ^ "\n") ; false )

val true = entails [Avail("oab", Tensor(One, Plus(A, B)))]
                    (TensorL("oab", Bind2("o", "ab", PlusL("ab", Bind("a", OneL("o", PlusR1(Id("a")))),
                                                       Bind("b", OneL("o", PlusR2(Id("b"))))))))
                    (Plus(A,B))

end (* structure LinearTest *)

structure StructuralTest =
struct

open Structural

val A = Atom("A")
val B = Atom("B")
val C = Atom("C")
val a = "a"
val b = "b"
val c = "c"
val ab = "ab"
val ac = "ac"
val oc = "oc"

val A1 = Implies(A, A)
val M1 = ImpliesR(Bind("a", Id("a")))
val Gamma1 = check [] M1 A1
val () = print (pp_proof M1 ^ " : " ^ pp_prop A1 ^ "\n")

val false = entails [Ante("ab",And(A,B))] (AndL("ab", Bind2("a", "b", AndR(Id("a"), Id("b"))))) (And(B,A))
            handle Fail(msg) => (TextIO.print(msg ^ "\n") ; false)
val true = entails [Ante("ab",And(A,B))] (AndL("ab", Bind2("a", "b", AndR(Id("a"), Id("b"))))) (And(A,B))

val true = entails [Ante("ab",And(A,B))] (AndR(AndL2("ab",Bind("b",Id("b"))), AndL1("ab", Bind("a",Id("a")))))
                   (And(B,A))

val true = entails [Ante("ac", Implies(A, Implies(True, C)))]
                   (ImpliesR(Bind("o", ImpliesR(Bind("a",
                       TrueL("o", ImpliesL("ac", Id("a"), Bind("oc", ImpliesL("oc", TrueR, Bind(c, Id(c)))))))))))
                   (Implies(True, Implies(A, C)))

val true = entails [Ante("ac", Implies(A, Implies(True, C)))]
                   (ImpliesR(Bind("o", ImpliesR(Bind("a",
                       ImpliesL("ac", Id("a"), Bind("oc", ImpliesL("oc", TrueR, Bind(c, Id(c))))))))))
                   (Implies(True, Implies(A, C)))
            handle Fail(msg) => ( print (msg ^ "\n") ; false )

val true = entails [Ante("ac", Implies(A, Implies(True, C)))]
                   (ImpliesR(Bind("o", ImpliesR(Bind("a",
                       ImpliesL("ac", Id("a"), Bind("oc", ImpliesL("oc", TrueR, Bind(c, TrueL("o", Id(c)))))))))))
                   (Implies(True, Implies(A, C)))
            handle Fail(msg) => ( print (msg ^ "\n") ; false )

val true = entails [Ante("oab", And(True, Or(A, B)))]
                    (AndL("oab", Bind2("o", "ab", OrL("ab", Bind("a", OrR1(Id("a"))), Bind("b", TrueL("o", OrR2(Id("b"))))))))
                    (Or(A,B))
            handle Fail(msg) => ( print (msg ^ "\n") ; false )

val true = entails [Ante("oab", And(True, Or(A, B)))]
                    (AndL("oab", Bind2("o", "ab", OrL("ab", Bind("a", TrueL("o", OrR1(Id("a")))),
                                                       Bind("b", TrueL("o", OrR2(Id("b"))))))))
                    (Or(A,B))

end (* structure StructuralTest *)
