//////////////////////////////////////////////////////////
// File  : universal.cc
// Desc. : info structures for non-deterministic 
//         search
// Author: Rune M. Jensen
// Date  : 5/7/02
//////////////////////////////////////////////////////////

#include <bdd.h>
#include "bddLayout.hpp"
#include "universal.hpp"


//////////////////////////////////////////////////////////
//
// ActInfo
//
//////////////////////////////////////////////////////////

// builds BDD rep of the set of action vars
void ActInfo::initialize(NADLNonDetbddLayout& layout) {  

  Avars = bddtrue;
  
  for (int i = 0; i < layout.actID.length; i++)
      Avars &= bdd_ithvar(layout.actID.current[i]);
  
  if ( layout.envActive )
    {
      AvarsEnv = bddtrue;
      
      for (int i = 0; i < layout.actIDenv.length; i++)
	AvarsEnv &= bdd_ithvar(layout.actIDenv.current[i]);
    }    
}




