////////////////////////////////////////////////////////
// File  : time.cc  
// Desc. : Simple functions for measuring run times, 
//         runtime must be less than 10 hours.
//         (see man setitimer for description).
//         Obs: these timers interfer with the gproff
//         profiling tool 
// Author: Rune M. Jensen, CS, CMU
// Date  : 04/07/02
////////////////////////////////////////////////////////

#include <sys/time.h>
#include  <stream.h>
#include "timer.hpp"

void resettimers() {
  // resets the decrementing process timer
  // timer must be reset every 10 hours
  struct itimerval reset;
  reset.it_interval.tv_sec = 0;
  reset.it_interval.tv_usec = 0;
  reset.it_value.tv_sec = 10*60*60;
  reset.it_value.tv_usec = 0;
  setitimer(ITIMER_PROF, &reset, NULL);
}


// start a timer
void timer::start() {
    getitimer(ITIMER_PROF, &startt);
}

// stop timer and print result
double timer::stop() {

  struct itimerval stopp;
  double elapsedtime;

  getitimer(ITIMER_PROF, &stopp);
  elapsedtime = 
  ( 1e+6*(startt.it_value.tv_sec) + startt.it_value.tv_usec -
    1e+6*(stopp.it_value.tv_sec) - stopp.it_value.tv_usec ) / 1e+6;

  return elapsedtime;
}
