//////////////////////////////////////////////////////////
// File  : symbolicHeuristic.hpp
// Desc. : symbolic encoding of the heuristic function
//         h(v,x) as used by pure-BDDA* and BDDA*
// Author: Rune M. Jensen
// Date  : 5/7/02
//////////////////////////////////////////////////////////

#ifndef SYMBOLICHEURISTICHPP
#define SYMBOLICHEURISTICHPP

#include<bdd.h>
#include "bddLayout.hpp"
#include "reachInfo.hpp"
#include "numDomain.hpp"
#include "partition.hpp"

//externs
extern int totalFormulaSize;


// structure holding quantification info
// of F and H variables
struct FHinfo {
  bdd Fcurrent;
  //  bdd Fnext;    
  // bddPair *Fcurrent2next;
  // bddPair *Fnext2current;  
  bdd Hcurrent;
  bdd Hnext;
  bddPair *Hcurrent2next;
  bddPair *Hnext2current;
  bddPair *Hcurrent2Fcurrent;

  void initialize(PDDLbddBDDAlayout& layout);
  void initialize(NADLbddBDDAlayout& layout);
};


// BDDA* Published
// structure holding quantification info
// of F and H variables
struct PubFHinfo {
  bdd Fcurrent;
  bdd Fnext;    
  bddPair *Fcurrent2next;
  bddPair *Fnext2current;  
  bdd Hcurrent;
  bdd Hnext;
  bddPair *Hcurrent2next;
  bddPair *Hnext2current;
  bddPair *Hcurrent2Fcurrent;

  void initialize(PDDLbddPubBDDAlayout& layout);
  void initialize(NADLbddPubBDDAlayout& layout);
};




// Published BDDA*
// structure holding quantification info
// needed by BDDA*
struct BDDAinfo {
  set< pair<int,int> > stateVarPairs;
                          // currentVar nextVar pairs
  bdd currentVars;        // current BDD vars
  bdd nextVars;           // next BDD vars
  bddPair *current2next;  // current to next substitution set
  bddPair *next2current;  // next to current substitution set
  vector<bdd> formulaBackward;    // f = (fmin + 1) + h - h'
  vector<bdd> formulaForward;     // f = (fmin - 1) + h - h'
  void initialize(PDDLbddBDDAlayout& layout);
  void initialize(NADLbddBDDAlayout& layout);
};



// Published BDDA*
// structure holding quantification info
// needed by BDDA*
struct PubBDDAinfo {
  set< pair<int,int> > stateVarPairs;
                          // currentVar nextVar pairs
  bdd currentVars;        // current BDD vars
  bdd nextVars;           // next BDD vars
  bddPair *current2next;  // current to next substitution set
  bddPair *next2current;  // next to current substitution set
  bdd formulaBackward;    
  bdd formulaForward;     
  void initialize(PDDLbddPubBDDAlayout& layout);
  void initialize(NADLbddPubBDDAlayout& layout);
};


// Prototypes
bdd PDDLSymbolicHSPr(PDDLbddBDDAlayout& layout,reachInfo& rInfo,numDomain& numDom,FHinfo& fhInfo);
bdd PubPDDLSymbolicHSPr(PDDLbddPubBDDAlayout& layout,reachInfo &rInfo,numDomain &numDom, PubFHinfo& fhInfo);
bdd NADLSymbolicManhattan(NADLbddBDDAlayout& layout, FHinfo& fhInfo);
bdd PubNADLSymbolicManhattan(NADLbddPubBDDAlayout& layout, PubFHinfo& fhInfo);
bdd symbolicMinHamming(NADLbddBDDAlayout& layout, FHinfo& fhInfo, bdd goal);
bdd PubSymbolicMinHamming(NADLbddPubBDDAlayout& layout, PubFHinfo& fhInfo, bdd goal);
int fMin(PDDLbddBDDAlayout& layout,bdd& min,bdd& open);
int fMin(NADLbddBDDAlayout& layout,bdd& min,bdd& open);
int PubfMin(PDDLbddPubBDDAlayout& layout,bdd& min,bdd& open);
int PubfMin(NADLbddPubBDDAlayout& layout,bdd& min,bdd& open);
int hMin(PDDLbddBDDAlayout& layout,bdd& min,bdd& open);
int PubhMin(PDDLbddPubBDDAlayout& layout,bdd& min,bdd& open);
int bvecEcoding2int(int varLength, int* var,bdd state);
void IVextend(BDDAinfo& bddaInfo,TRel& T);
bdd preImageOpen(BDDAinfo& bddaInfo, FHinfo& fhInfo, TRel& T, bdd h, bdd hm, bdd min, int fMin);
bdd PubPreImageOpen(PubBDDAinfo& bddaInfo, PubFHinfo& fhInfo, TRel& T, bdd h, bdd hm, bdd min);
bdd imageOpen(BDDAinfo& bddaInfo, FHinfo& fhInfo, TRel& T, bdd h, bdd hm, bdd min, int fMin);
bdd PubImageOpen(PubBDDAinfo& bddaInfo, PubFHinfo& fhInfo, TRel& T, bdd h, bdd hm, bdd min);
bdd successorOfActOpen(BDDAinfo& bddaInfo, FHinfo& fhInfo, TRel& T, bdd h, bdd hm, bdd min, int fMin, int act);
bdd predecessorOfActOpen(BDDAinfo& bddaInfo, FHinfo& fhInfo, TRel& T, bdd h, bdd hm, bdd min, int fMin, int act);




#endif


