//////////////////////////////////////////////////////////
// File  : singleState.search.hpp
// Desc. : single state search algorithms based on PDDL
//         and STL hashset manipulation
// Author: Rune M. Jensen
// Date  : 05/03/02
//////////////////////////////////////////////////////////

#ifndef SINGLESTATESEARCHHPP
#define SINGLESTATESEARCHHPP

#include <set>
#include <string>
#include "set.hpp"
#include "numDomain.hpp"
#include "reachInfo.hpp"
#include "singleState.actions.hpp"

// statistics externs
extern double Tsearch;
extern double Textract;
extern int    maxSearchQueueSize;
extern int    iterationNum;
extern int    timeout;


// Priority queue
struct singleQvalue {
  double f;
  int g;
  int h;
  int actionNo;
  singleQvalue *parent;   // pointer to the parent node
  set<int> state;
  singleQvalue(double fi,int gi,int hi,int actionNoi,
	       singleQvalue *parenti, set<int> statei) 
  {f = fi; g = gi; h = hi; actionNo = actionNoi;
  parent = parenti; state = statei;} 
  singleQvalue() {} // default
};





// lowest f value gets highest priority
// ties are broken in favor of lowest h value
struct singleQvaluecmp {
  bool operator() (singleQvalue v1,singleQvalue v2) 
  {if (v1.f == v2.f) 
    return (v1.h > v2.h);
  else return (v1.f > v2.f);}
};


// prototypes

list<string> Astar(numDomain& numDom, reachInfo& rInfo,vector<singleStateAction> &action, set<int> init, set<int> goal,int hinit,double w);

list<string> AstarBackward(numDomain& numDom, reachInfo& rInfo,vector<singleStateAction> &action, 
			   set<int> init, set<int> goal,int hinit,double wg,double wh);


#endif  
