//////////////////////////////////////////////////////////
// File  : singleState.actions.hpp
// Desc. : Functions for making grounded actions for 
//         single state search algorithms
// Author: Rune M. Jensen
// Date  : 05/03/02
//////////////////////////////////////////////////////////

#ifndef SINGLESTATEACTIONSHPP
#define SINGLESTATEACTIONSHPP

#include <hash_set.h>
#include <string>
#include "main.hpp"
#include "numDomain.hpp"
#include "reachInfo.hpp"



// Action struct
struct singleStateAction {
  string name;
  set<int> pre;
  set<int> add;
  set<int> del;
  int dg;
  int dh;
  void print(numDomain& numDom, reachInfo& rInfo);
};



// Prototypes
void printFactHashSet(set<int> s,int predShift, int objShift,
		  int predMask,int objMask, vector<int> predArity,
		      numDomain &numDom);
void mkActions(vector<singleStateAction> &action,numDomain &numDom, reachInfo &rInfo, heuristicType heuristic);
set<int> init2intSet(reachInfo &rInfo);
set<int> goal2intSet(reachInfo &rInfo,vector< vector<int> > &goal);
int hHSPrSingle(reachInfo &rInfo,vector< vector<int> > s);



#endif  
