///////////////////////////////////////////////////////
// File  : searchAlgAuxFunc.hpp  
// Desc. : Header for searchAlgAuxFunc.cc
// Author: Rune M. Jensen CS, CMU
// Date  : 1/13/02 (non-det 8/28/02)
///////////////////////////////////////////////////////

#ifndef SEARCHALGAUXFUNCHPP
#define SEARCHALGAUXFUNCHPP

#include <list>
#include <utility>
#include <queue>

#include "bddLayout.hpp"
#include "partition.hpp"
#include "universal.hpp"
#include "searchQueue.hpp"


///////////////////////////////////////////////////////
// Statistic externs
///////////////////////////////////////////////////////

extern double Tsearch;
extern double Textract;
extern double aveFringeSize;
extern int    maxSearchQueueSize;
extern int    forwardExpansionNum;
extern int    backwardExpansionNum;
extern int    iterationNum;
extern int    timeout;


///////////////////////////////////////////////////////
// function prototypes
///////////////////////////////////////////////////////

// general aux functions

bdd preImage(TRel& T, bdd v);
bdd image(TRel& T, bdd v);
bdd predecessorOfAct(TRel& Tact,bdd set1,bdd set2,int act);
bdd successorOfAct(TRel& Tact,bdd set1,bdd set2,int act);

// det search aux functions
bdd pruneStates(bdd preImage, bdd v);
bdd preImage(TRel& T, bdd v);
bdd image(TRel& T, bdd v);
bdd predecessorOfAct(TRel& Tact,bdd set1,bdd set2,int act);
bdd successorOfAct(TRel& Tact,bdd set1,bdd set2,int act);
bdd partitionImage(TRel& T, bdd v, int i);
bdd partitionPreImage(TRel &T, bdd v, int i);

// nondet search aux functions
bdd nextStates(TRel& T, bdd sa, ActInfo& Ainfo);
bdd strongPreImage(TRel& T, bdd s);
bdd States(ActInfo& Ainfo,bdd SA);
bdd OneStepBack(TRel& T, ActInfo& Ainfo,bdd G,bdd SA);
bdd PruneOutgoing(TRel& T, ActInfo& Ainfo,bdd G,bdd SA);
bdd PruneUnconnected(TRel& T, ActInfo& Ainfo,bdd G,bdd SA);
bdd App(TRel& Tenv, ActInfo& Ainfo);
bdd PruneUnfair(TRel& T,TRel& Tenv,ActInfo& Ainfo,bdd A, bdd C,bdd SA);

void insertPrunedChildren(TRel& T,ghSCQueue& searchQueue,bdd parentS,
			  int parentG,int parentH, bdd pruneStates);
void SCfixedPoint(TRel& T, ActInfo& Ainfo,bdd& preCompSA,bdd& preCompS,
		  bdd preCompCandSA,bdd preCompCandS,bdd coveredStates);

void computeUSfrontier(TRel& Teff, map<int,bdd>& USpart, bdd US, map<int,bdd>& USfrontier);
void extendRSA2(TRel& Teff, ActInfo& Ainfo, bdd& RSA, bdd& RS, bdd& USAPreCompCandSerr);
void extendRSA3(TRel& Teff, ActInfo& Ainfo, bdd& RSA, bdd& RS, bdd& USAPreCompCandSerr);

#endif  
