%token DEFINE
%token DOMAIN REQUIREMENTS PREDICATES 
%token PROBLEM OBJECTS INIT
%token ACTION PARAMETERS PRECONDITION EFFECT
%token AND 
%token NOT GOAL
%token ID VAR

%%
/****************************************************** 
 * File  : pddl.y   
 * Desc. : Yacc file for strict STRIPS PDDL domains 
 *         and problems (that is: only the strips requirment
 *         assumed to be included in the PDDL requirements list,
 *         no equality relation!)
 * Author: Rune M. Jensen
 * Date  : 12/07/01
 ******************************************************/


pddl : domain
     | problem
;

domain : '(' DEFINE '(' DOMAIN id ')' requirements predicates actionlist ')' { 
  
  string *str = (string*) $5; 
  PDDLdom.name = *str;
  delete str;
  PDDLdom.pred = litLstp2Vec((list<literal>*) $8);
  PDDLdom.act  = actLstp2Vec((list<PDDLaction>*) $9); }


requirements : '(' ':' REQUIREMENTS ':' id  ')' 

predicates : '(' ':' PREDICATES litlist ')' {
  $$ = $4; }

problem : '(' DEFINE '(' PROBLEM id ')' '(' ':' DOMAIN id ')' objectlist initexpr goalexpr  ')' {
  string *str = (string*) $5; 
  PDDLprob.name = *str;
  delete str;
  PDDLprob.obj  = strLstp2Vec((list<string>*) $12); 
  PDDLprob.init = litLstp2Vec((list<literal>*) $13);
  PDDLprob.goal = litLstp2Vec((list<literal>*) $14); }		       
			    
objectlist : '(' ':' OBJECTS arglist ')' { $$ = $4; }

initexpr : '(' ':' INIT litlist ')' { $$ = $4; }

goalexpr : '(' ':' GOAL '(' AND litlist ')' ')' { $$ = $6; }

actionlist : action {
             list<PDDLaction> *actLst = new list<PDDLaction>;
	     PDDLaction *act = (PDDLaction*) $1;
             actLst->push_back(*act);
	     delete act;
             $$ = (int) actLst; }
           | action actionlist {
	     PDDLaction *act = (PDDLaction*) $1;
	     list<PDDLaction>* actLst = (list<PDDLaction>*) $2;
	     actLst->push_front(*act);
	     delete act;
	     $$ = (int) actLst; }


action :   '(' ':' ACTION id parameters precondition effect ')' {
             PDDLaction *act = new PDDLaction;
             string *str = (string*) $4;
	     act->name = *str;
	     delete str;
	     act->param = strLstp2Vec((list<string>*) $5); 
	     act->pre = litLstp2Vec((list<literal>*) $6); 
	     vector<literal> eff = litLstp2Vec((list<literal>*) $7);
	     for (int i=0; i<eff.size(); i++)	     
	       if (eff[i].isTrue)
		 act->add.push_back(eff[i]);
	       else
		 {
		   eff[i].isTrue = true;
		   act->del.push_back(eff[i]);
		 }
             $$ = (int) act; }
         | '(' ':' ACTION id parameters effect ')' {
             PDDLaction *act = new PDDLaction;
	     string *str = (string*) $4;
	     act->name = *str;
	     delete str;
	     act->param = strLstp2Vec((list<string>*) $5); 
	     vector<literal> eff = litLstp2Vec((list<literal>*) $6);
	     for (int i=0; i<eff.size(); i++)	     
	       if (eff[i].isTrue)
		 act->add.push_back(eff[i]);
	       else
		 {
		   eff[i].isTrue = true;
		   act->del.push_back(eff[i]);
		 }
             $$ = (int) act; }

         | '(' ':' ACTION id precondition effect ')' {
             PDDLaction *act = new PDDLaction;
             string *str = (string*) $4;
	     act->name = *str;
	     delete str;
	     act->pre = litLstp2Vec((list<literal>*) $5); 
	     vector<literal> eff = litLstp2Vec((list<literal>*) $6);
	     for (int i=0; i<eff.size(); i++)	     
	       if (eff[i].isTrue)
		 act->add.push_back(eff[i]);
	       else
		 {
		   eff[i].isTrue = true;
		   act->del.push_back(eff[i]);
		 }
             $$ = (int) act; }

         | '(' ':' ACTION id effect ')' {
             PDDLaction *act = new PDDLaction;
	     string *str = (string*) $4;
	     act->name = *str;
	     delete str;
	     vector<literal> eff = litLstp2Vec((list<literal>*) $5);
	     for (int i=0; i<eff.size(); i++)	     
	       if (eff[i].isTrue)
		 act->add.push_back(eff[i]);
	       else
		 {
		   eff[i].isTrue = true;
		   act->del.push_back(eff[i]);
		 }
             $$ = (int) act; }

parameters : ':' PARAMETERS '(' arglist ')' { $$ = $4; }
       
precondition :   ':' PRECONDITION '(' AND litlist ')' { $$ = $5; }	
               | ':' PRECONDITION lit  { 
   	            list<literal> *litlst = new list<literal>;
	            literal *lit = (literal*) $3;
		    litlst->push_back(*lit);
		    delete lit;
	            $$ = (int) litlst; }

effect :   ':' EFFECT '(' AND litlist ')' { $$ = $5; }
         | ':' EFFECT lit { 
	        list<literal> *litLst = new list<literal>;
	        literal *lit = (literal*) $3;
		litLst->push_back(*lit);
		delete lit;
	        $$ = (int) litLst; }

arglist :        { list<string> *argLst = new list<string>;                   
                   $$ = (int) argLst; }
          | arg arglist {
            list<string> *argLst = (list<string>*) $2;
	    string *str = (string*) $1;	    
	    argLst->push_front(*str);
	    delete str;
           $$ = (int) argLst; }

arg :   id { $$ = $1; }     
      | variable { $$ = $1; }     

litlist :     { list<literal> *litLst = new list<literal>;
                $$ = (int) litLst; }
         | lit litlist { 
           list<literal> *litLst = (list<literal>*) $2;
	   literal *lit = (literal*) $1;
	   litLst->push_front(*lit);
	   delete lit;
	   $$ = (int) litLst; } 
       

lit :   '(' NOT '(' id arglist ')' ')' {
           literal *lit = new literal;
           string *str = (string*) $4;
	   lit->name = *str;
	   delete str;
	   lit->arg = strLstp2Vec((list<string>*) $5);
	   lit->isTrue = false;
           $$ = (int) lit; }
      | '(' id arglist ')' {
           literal *lit = new literal;
           string *str = (string*) $2;
	   lit->name = *str;
	   delete str;
	   lit->arg = strLstp2Vec((list<string>*) $3);
	   lit->isTrue = true;
           $$ = (int) lit; }

variable : VAR { string *str = new string;
           xxtext[0] = '$'; 
           *str = xxtext; 
	   $$ = (int) str; }

id : ID {  string *str = new string;
           *str = xxtext; 
	   $$ = (int) str; }

%%
#include <stdio.h>
#include <list>
#include <vector>
#include <string>
#include "common.hpp"
#include "pddl.hpp" 

int xxlex (void);
int xxerror(char * s);

extern char* xxtext;
extern int xxlineno;

PDDLdomain  PDDLdom;  
PDDLproblem PDDLprob; 

int xxerror(char * s) {
  fprintf(stderr,"%s\n",s);
  fprintf(stderr,"Error occurred at or near line %d\n", xxlineno);
  exit(1);
}

vector<literal> litLstp2Vec(list<literal> *litList) {
  vector<literal> res;
     
  for (list<literal>::iterator li = litList->begin(); li != litList->end(); ++li)
    res.push_back(*li);
  delete litList;

  return res;
}

vector<string> strLstp2Vec(list<string> *strList) {
  vector<string> res;
     
  for (list<string>::iterator li = strList->begin(); li != strList->end(); ++li)
    res.push_back(*li);
  delete strList;

  return res;
}

vector<PDDLaction> actLstp2Vec(list<PDDLaction> *actList) {
  vector<PDDLaction> res;
     
  for (list<PDDLaction>::iterator li = actList->begin(); li != actList->end(); ++li)
    res.push_back(*li);
  delete actList;

  return res;
}
