%{
/****************************************************** 
 * File  : pddl.l   
 * Desc. : lex file for strict strips PDDL domain
 *         and problem descriptions  
 * Author: Rune M. Jensen, CMU
 * Date  : 10/13/99
 ******************************************************/

#include "x.tab.h"

int xxlineno = 0;

%}

ID [a-zA-Z0-9_=-]+ 
VAR "?"{ID}
comment ;.*$

%option caseless

%%
"(" {return '(';}
")" {return ')';}
"define" { return DEFINE; }
"domain" { return DOMAIN; }
"requirements" { return REQUIREMENTS; }
"predicates" { return PREDICATES; }
"action" { return ACTION; }
"parameters" { return PARAMETERS; }
"precondition" { return PRECONDITION; }
"effect" { return EFFECT; }
"and" { return AND; }
"not" { return NOT; }
"problem" { return PROBLEM; }
"objects" { return OBJECTS; }
"init" { return INIT; }
"goal" { return GOAL; }
":" { return ':'; }

{ID} { return ID; }
{VAR} {return VAR; }

[ \t]+ ;
{comment} ;
\n xxlineno++;

%%

