////////////////////////////////////////////////////////
// File  : pddl.hpp   
// Desc. : Strips PDDL STL representation
// Author: Rune M. Jensen
// Date  : 12/06/01
////////////////////////////////////////////////////////

#ifndef PDDLHPP
#define PDDLHPP

#include <vector>
#include <list>
#include <string>
#include "common.hpp"

////////////////////////////////////////////////////////
// Domain data structure                            
////////////////////////////////////////////////////////


struct literal {
  string name;
  bool isTrue;
  vector<string>  arg;
  void print();
};

struct PDDLaction {
  string name;
  vector<string> param;
  vector<literal> pre;
  vector<literal> add;
  vector<literal> del;
  void print();
};

struct PDDLdomain {
  string name;
  vector<literal> pred;
  vector<PDDLaction> act;
  void print();
};


////////////////////////////////////////////////////////
// Problem data structure                           
////////////////////////////////////////////////////////

struct PDDLproblem {
  string name;
  vector<string> obj;
  vector<literal> init;
  vector<literal> goal;
  void print();
};

///////////////////////////////////////////////////////
//  function prototypes 
///////////////////////////////////////////////////////

int xxparse();


#endif
