////////////////////////////////////////////////////////
// File  : pddl.cc   
// Desc. : pddl.hpp implementation
// Author: Rune M. Jensen
// Date  : 12/06/01
////////////////////////////////////////////////////////

#include <stream.h>
#include "common.hpp"
#include "pddl.hpp"
   

void printStrVec(vector<string> str) {
  for(int i=0; i<str.size();i++)
    {
      cout << str[i];
      if (i < str.size()-1) cout << ",";
    }
}  

void literal::print()  {
  if (!isTrue) cout << "~";
  cout << name << "(";
  printStrVec(arg);  
  cout << ")";
}

void printLitVec(vector<literal> lit) {
  for(int i=0; i<lit.size();i++)
    {
      lit[i].print();
      if (i < lit.size()-1) cout << ",";
    }
}

void PDDLaction::print()  {
  cout << "  " << name << endl;
  cout << "    Param: ";printStrVec(param);cout << endl;
  cout << "    Pre: ";printLitVec(pre);cout << endl;  
  cout << "    Add: ";printLitVec(add);cout << endl;
  cout << "    Del: ";printLitVec(del);cout << endl;
}

void PDDLdomain::print() {
  cout << "Domain: " << name << endl;
  cout << "  Predicates: ";printLitVec(pred);cout << endl;
  cout << "  Actions:\n\n";
  for (int i=0; i<act.size(); i++)
    {
      act[i].print();
      cout << "\n\n";
    }
}

void PDDLproblem::print() {
  cout << "Problem: " << name << endl;
  cout << "  Objects: ";printStrVec(obj);cout << endl;
  cout << "  Init: ";printLitVec(init);cout << endl;
  cout << "  Goal: ";printLitVec(goal);cout << endl;
}
