////////////////////////////////////////////////////////
// File  : partition.hpp   
// Desc. : partioning functions 
// Author: Rune M. Jensen
// Date  : 1/12/02
////////////////////////////////////////////////////////

#ifndef PARTITIONHPP
#define PARTITIONHPP


#include <bdd.h>
#include <fstream.h>
#include <string>
#include <set>
#include <vector>
#include <list>
#include <map>
#include "pddl.hpp"
#include "main.hpp"
#include "numDomain.hpp"
#include "reachInfo.hpp"
#include "balancedInfo.hpp"
#include "bddLayout.hpp"
#include "universal.hpp"


////////////////////////////////////////////////////////
// structure  for representing disjunctive             
//  partitioned transition relations
////////////////////////////////////////////////////////

struct branchPartition {
  int dg;                 // delta g-value of actions in partition [0,1,2,...]
  int dh;                 // delta h-value of actions in partition [...,-1,0,1,2...]
  string actName;         // action name (if only a single action is associated with
                          // the partition)
  bdd exp;                // transition relation expression of this partition
  set< pair<int,int>  > modify;     
                          // BDD variables modified by action from current to next state
                          // (nadl = mod-set). Encoded as pairs (current state var * 
                          // next state var) since they also are used to make replace sets  
  bdd varSetf;            // forward  quantification var set bdd rep.
  bdd varSetb;            // backward quantification var set bdd rep. (same as forward just next state vars)
  bddPair *subVarSetf;    // forward substition set
  bddPair *subVarSetb;    // backward substition set // same as forward, just marked 
  void print();
};


// partitioned disjunctive transition relation
struct TRel {
  vector<branchPartition> p;
  int size();
  void print();
};


// joint action identifier
struct jointAction {
  int envAct;  // env action no
  int envTr;  // env action transition grp. no
  int sysAct;  // sys action no
  int sysTr;  // sys action transition grp. no
  jointAction(int envActi,int envTri,int sysActi,int sysTri)
  { envAct = envActi; envTr = envTri; sysAct = sysActi; sysTr = sysTri; }
};


////////////////////////////////////////////////////////
// function prototypes
////////////////////////////////////////////////////////

// Shared functions
void optimize(TRel& T, TRel& optT, int threshold);
void splitTactPartitions(TRel& Tact,TRel& Tbranch,bdd goal);
void optimizeBranching(TRel& T, TRel& optT, int threshold);


// PDDL
bdd init2bdd(PDDLbddLayout& layout, numDomain& numDom,vector< vector<int> >& init);
bdd goal2bdd(PDDLbddLayout &layout, numDomain& numDom,vector< vector<int> >& goal);
void PDDLmkTact(PDDLbddLayout& layout,reachInfo& rInfo,numDomain& numDom,
		TRel& Tact,heuristicType heuristic);
void FminModify(TRel& T,double wg,double wh);
void NADLFminModify(TRel& T,double wg,double wh);

void pureFminModify(TRel& T);


// NADL
// deterministic search
void NADLmkTact(NADLbddLayout& layout,TRel& Tact);
void modifyTact15puzzle(TRel& Tact);

// non-deterministic search			    
void NADLNonDetmkT(NADLNonDetbddLayout& layout,TRel& T);
void abstractEnvAct(TRel& T,ActInfo& Ainfo);
void NADLNonDetmkTErr(NADLNonDetbddLayout& layout,TRel& T);
void NADLNonDetHeumkT(NADLNonDetbddLayout& layout,TRel& T);
#endif
