//////////////////////////////////////////////////////// 
// File  : numDomain.hpp
// Desc. : A numerical representation of PDDL domains
// Author: Rune M. Jensen, CS, CMU
// Date  : 12/8/01
//////////////////////////////////////////////////////// 

#ifndef NUMDOMAINHPP
#define NUMDOMAINHPP


#include<map>
#include<vector>
#include"pddl.hpp"

// predicate rep: predicate names are refered by their number, arguments are positive
// if they refer to a constant object and otherwise the negative of the paramno
// they refer to. 
struct numAction {
  string name;
  int paramNum; 
  vector< vector<int> > pre; 
  vector< vector<int> > add;
  vector< vector<int> > del;
  numAction(PDDLaction act);
  numAction(PDDLaction &act, map<string,int> &predno, 
	    map<string,int> &objno, vector<literal> &dompred);
  void print();
};

struct numDomain {
  vector<string> pred;
  vector<string> obj;
  int predNum;
  int objNum;
  int maxArity;
  vector<int> predArity;
  vector<numAction> act;
  vector< vector<int> > init;
  vector< vector<int> > goal;
  void initialize(PDDLdomain &dom, PDDLproblem &prob);
  void print();
};


//prototypes
void printPredList(vector< vector<int> > predLst);


#endif


