///////////////////////////////////////////////////////
// File  : nonDetSearchAlg.hpp  
// Desc. : Header for nonDetSearchAlg.cc
// Author: Rune M. Jensen CS, CMU
// Date  : 10/28/02
///////////////////////////////////////////////////////

#ifndef SEARCHHPP
#define SEARCHHPP

#include <list>
#include <utility>
#include <queue>

#include "bddLayout.hpp"
#include "partition.hpp"
#include "universal.hpp"
#include "searchQueue.hpp"
#include "searchAlgAuxFunc.hpp"

// prototypes
int strongSearch(TRel& T, ActInfo& Ainfo, bdd init, bdd goal, bdd& universalPlan);
int strongHeuristicSearch(TRel& T, ActInfo& Ainfo, bdd init, bdd goal, bdd& universalPlan,
			  int hGoal,int u);
int strongCyclicSearch(TRel& T, ActInfo& Ainfo,bdd init,bdd goal,bdd& universalPlan);
int strongCyclicHeuristicSearch(TRel& T, ActInfo& Ainfo, bdd init,bdd goal, 
				bdd& universalPlan,int hGoal,int u);
int weakSearch(TRel& T, ActInfo& Ainfo, bdd init, bdd goal, bdd& universalPlan);
int weakHeuristicSearch(TRel& T, ActInfo& Ainfo, bdd init, bdd goal, bdd& universalPlan,
			int hGoal,int u);


int strongCyclicAdversarialSearch(TRel& T,TRel& Tenv, ActInfo& Ainfo,bdd init,bdd goal,bdd& universalPlan);



int faultTolerantSearch(TRel& Teff, TRel& Terr, ActInfo& Ainfo, bdd init, bdd goal, 
			bdd& USA, bdd& RSA);
int faultTolerantSearchOpt(TRel& Teff, TRel& Terr, ActInfo& Ainfo, bdd init, bdd goal, 
			   bdd& USA, bdd& RSA);
int guidedFaultTolerantSearch1(TRel& Teff, TRel& Terr, ActInfo& Ainfo, bdd init, bdd goal, 
			       bdd& USA, bdd& RSA, int hGoal,int u);

int guidedFaultTolerantSearch2(TRel& Teff, TRel& Terr, ActInfo& Ainfo, bdd init, bdd goal, 
			       bdd& USA, bdd& RSA, int hGoal,int u);
int guidedFaultTolerantSearch3(TRel& Teff, TRel& Terr, ActInfo& Ainfo, bdd init, bdd goal, 
			       bdd& USA, bdd& RSA, int hGoal,int u);
#endif  
