%token SYSTEM ENVIRONMENT INITIALLY NADLGOAL 
%token PRE EFF MOD DG DH ERR AGT NAT ARROW TRUE FALSE
%token NE NADLID NUMBER VARIABLES BOOL
%token BIIMPL IMPL NADLAND NADLOR 

%nonassoc ARROW
%left BIIMPL IMPL
%left NADLOR
%left NADLAND
%nonassoc '~' 
%left '+' '-'

%start problem
%%
////////////////////////////////////////////////////////
// File  : extNADL.y
// Desc. : Yacc file for extNADL language
//         Abstract Syntax described in extNADL.hpp
//         See also lex file extNADL.l
// Author: Rune M. Jensen, CS, CMU 
// Date  : 10/12/02
////////////////////////////////////////////////////////

problem:     VARIABLES vardecls SYSTEM agtdecls envoption INITIALLY formula hoption NADLGOAL formula hoption
                    { 
		      list<varDecl>* v  = (list<varDecl>*) $2;
		      list<agent>*   s  = (list<agent>*)   $4;
		      list<agent>*   e  = (list<agent>*)   $5;
		      int*           hi = (int*)           $8;
		      int*           hg = (int*)           $11;
		      extNADLprob.initialize(v,s,e,(formula*) $7,hi,(formula*) $10,hg);
		      delete v;
		      delete s;
		      delete e;
		      delete hi;
		      delete hg;
		    }              
                ;


envoption:          { $$ = 0; }          
              | ENVIRONMENT agtdecls
                    { $$ = $2; }
                ;

vardecls:       
                    { $$ = (int) new list<varDecl>; } 
              | varlst vardecls
	            { varDecl* varDec     = (varDecl*)       $1;
		      list<varDecl>* vars = (list<varDecl>*) $2;
		      vars->push_front(*varDec); 
		      delete varDec;
		      $$ = (int) vars; }
                ;

varlst:         vartype idlst
                    { varType*     varT   =  (varType*)     $1;
		      set<string>* ids    =  (set<string>*) $2;
		      varDecl* varDec = new varDecl(varT,ids);
		      delete varT;
		      delete ids;
		      $$ = (int) varDec; }                
                ;

vartype:        BOOL 
	            { varType* vaType = new varType(vt_bool,0);
		      $$ = (int) vaType; }                
              | NAT '(' number ')'
	            { varType* vaType = new varType(vt_nat,(int) $3);
		      $$ = (int) vaType; }                
                ;

idlst:        
	            { $$ = (int) new set<string>; }
              | idlst1
		    { $$ = $1; }  
                ;

idlst1:         id
                    { char*        idt = (char*) $1;
		      set<string>* ids = new set<string>;
                      ids->insert(idt);
		      delete idt;
		      $$ = (int) ids; }          
              | id ',' idlst1
                    { char*        idt = (char*)        $1;
                      set<string>* ids = (set<string>*) $3;
                      ids->insert(idt);
		      delete idt;
		      $$ = (int) ids; }          
                ;

agtdecls: 
	            { $$ = (int) new list<agent>; }  
              | AGT id actiondecls agtdecls
		    { char*                   name = (char*)                $2;
  		      list<extNADLaction>* actions = (list<extNADLaction>*) $3; 
		      list<agent>*          agtDec = (list<agent>*)         $4;
		      agent agt(name,actions);
		      delete name;
		      delete actions;
                      agtDec->push_front(agt);
                      $$ = (int) agtDec; }
                ;

actiondecls:    actiondecl
                    { 
		      extNADLaction* act = (extNADLaction*) $1;
		      list<extNADLaction>* actDec = new list<extNADLaction>;
		      actDec->push_front(*act);
		      delete act;
		      $$ = (int) actDec; }
              | actiondecl actiondecls
		    { list<extNADLaction>* actDec = (list<extNADLaction>*) $2;
		      extNADLaction*          act = (extNADLaction*)       $1;
                      actDec->push_front(*act);
		      delete act;
                      $$ = (int) actDec; } 
                ;

actiondecl:     id trandecls
		    { 
		      char*               name = (char*) $1;
		      list<extNADLtran>* trans = (list<extNADLtran>*) $2;
		      extNADLaction* act = new extNADLaction(name,trans);
		      delete name;
		      delete trans;
                      $$ = (int) act; } 
                ;

trandecls:      trandecl
                    { extNADLtran* tran = (extNADLtran*) $1;
                      list<extNADLtran>* tranDec = new list<extNADLtran>;
		      tranDec->push_front(*tran);
		      delete tran;
		      $$ = (int) tranDec; }
              | trandecl trandecls
		    { extNADLtran*          tran = (extNADLtran*)       $1;
                      list<extNADLtran>* tranDec = (list<extNADLtran>*) $2;		      
                      tranDec->push_front(*tran);
		      delete tran;
                      $$ = (int) tranDec; } 
                ;



trandecl:       goption hoption MOD idlst PRE formula EFF formula erroption
                    { int*          dg = (int*)         $1;
                      int*          dh = (int*)         $2;
                      set<string>*  mod = (set<string>*) $4;
		      extNADLtran* tran = new extNADLtran(dg,dh,mod,(formula*) $6,(formula*) $8,(formula*) $9); 
		      delete dg;
		      delete dh;
		      delete mod;
		      $$ = (int) tran; }
                ;

hoption:     
                    { $$ = 0; }
              | DH number
                    { int* num = new int;
		      *num = (int) $2;
		      $$ = (int) num; }
              | DH '-' number
                    { int* num = new int;
		      *num = (int) $3;
		      *num = -(*num);
		      $$ = (int) num; }
                ;


goption:     
                    { $$ = 0; }
              | DG number
                    { int* num = new int;
		      *num = (int) $2;
		      $$ = (int) num; }
                ;


erroption:     
                    { $$ = 0; }
              | ERR formula
                    { $$ = $2; }
                ;



formula:        formula1 ARROW formula1 ',' formula1
                    { $$ = (int) new formula(ft_ite,NULL,(formula*) $1,(formula*) $3,(formula*) $5); }
              | formula1
                    { $$ = $1; } 
                ;

formula1:       formula1 IMPL formula1
                    { $$ = (int) new formula(ft_impl,NULL,(formula*) $1,(formula*) $3,NULL); }
              | formula1 BIIMPL formula1
                    { $$ = (int) new formula(ft_biImpl,NULL,(formula*) $1,(formula*) $3,NULL); }
              | formula1 NADLOR formula1
                    { $$ = (int) new formula(ft_or,NULL,(formula*) $1,(formula*) $3,NULL); }
              | formula1 NADLAND formula1
                    { $$ = (int) new formula(ft_and,NULL,(formula*) $1,(formula*) $3,NULL); }
              | '~' formula1
                    { $$ = (int) new formula(ft_neg,NULL,(formula*) $2,NULL,NULL); }
              | '(' formula ')'
                    { $$ = (int) new formula(ft_paren,NULL,(formula*) $2,NULL,NULL); }
              | TRUE
                    { $$ = (int) new formula(ft_true,NULL,NULL,NULL,NULL); }
              | FALSE
                    { $$ = (int) new formula(ft_false,NULL,NULL,NULL,NULL); }
              | atom
                    { $$ = (int) new formula(ft_atom,(atom*) $1,NULL,NULL,NULL); }
                ;

atom:           id 
                    { char* s = (char*) $1;
                      int i = 0; 
                      while (s[i])
                        i++;
                      if (s[i-1] == '\'')
                        {
                          s[i-1] = 0;
                          $$ = (int) new atom(at_boolVarNext,NULL,s); 
                        }
                      else
                        $$ = (int) new atom(at_boolVarCur,NULL,s); }
              | numprop
		    { $$ = (int) new atom(at_numProp,(numberProp*) $1,""); }
                ;

numprop:        numberexp relop numberexp 
                    { $$ = (int) new numberProp((relOp) $2,(numberExp*) $1,(numberExp*) $3); }
                ;

relop:          '=' 
                    { $$ = (int) ro_eq; } 
              | NE 
                    { $$ = (int) ro_ne; } 
              | '>' 
                    { $$ = (int) ro_gt; } 
              | '<'
                    { $$ = (int) ro_lt; } 
                ;

numberexp:      id
                   { char* s = (char*) $1;
                     int i = 0; 
                     while (s[i])
                       i++;
                     if (s[i-1] == '\'')
                       {
                         s[i-1] = 0;
                         $$ = (int) new numberExp(nt_varNext,0,NULL,NULL,s); 
                       }
                     else
                       $$ = (int) new numberExp(nt_varCur,0,NULL,NULL,s); } 
              | number
                    { $$ = (int) new numberExp(nt_number,(int) $1,NULL,NULL,""); }
              | numberexp '+' numberexp
                    { $$ = (int) new numberExp(nt_plus,0,(numberExp*) $1,(numberExp*) $3,""); }
              | numberexp '-' numberexp 
                    { $$ = (int) new numberExp(nt_minus,0,(numberExp*) $1,(numberExp*) $3,""); }
                ;       

id:             NADLID
                    { char* s = new char[MAXNAMELENGTH];
                      strcpy(s,yytext);
                      $$ = (int) s; }
                ;

number:         NUMBER
                    { $$ = (int) atoi(yytext);  }
                ;

%%
#include <stdio.h>
#include <stdlib.h>
#include <list>
#include <string>
#include <set>
#include "common.hpp"
#include "extNADL.hpp"

// externs
extern char *yytext;  // defined in extNADL.l
extern int yylineno;  // defined in extNADL.l

// globals
extNADLproblem    extNADLprob; 

/* prototypes */

int yylex(void);

void yyerror(char *s) {
  fflush(stdout);
  printf("\n%s! lineno:%d at:\"%s\"\n", s, yylineno, yytext);
}





