Number                  [0-9]+
Id                      [a-zA-Z_][0-9A-Za-z_]*'?

%{
/****************************************************** 
 * File  : extNADL.l
 * Desc. : lex file for extNADL Language 
 * Author: Rune M. Jensen 
 * Date  : 10/12/02, CS,CMU
 ******************************************************/

#include "y.tab.h"

int yylineno = 1;

%}

%option caseless

%%
"%".*                   /* ignore comments, (rest of line from %) */ ;
[\t ]+                  /* ignore whitespace */ ;
\n                      { yylineno++; }
"system"                { return(SYSTEM); }
"environment"           { return(ENVIRONMENT); }
"variables"             { return(VARIABLES); }
"initially"             { return(INITIALLY); }
"goal"                  { return(NADLGOAL); }
"bool"                  { return(BOOL); }
"nat"                   { return(NAT); }
"agt:"                  { return(AGT); }
"process:"              { return(AGT); }
"pre:"                  { return(PRE); }
"eff:"                  { return(EFF); }
"mod:"                  { return(MOD); }
"dg:"                   { return(DG); }
"val:"                  { return(DG); }
"dh:"                   { return(DH); }
"heu:"                  { return(DH); }
"err:"                  { return(ERR); }
"true"                  { return(TRUE); }
"false"                 { return(FALSE); }
"<=>"                   { return(BIIMPL); }
"=>"                    { return(IMPL); }
"->"                    { return(ARROW); }
"/\\"                   { return(NADLAND); }
"\\/"                   { return(NADLOR); }
"<>"                    { return(NE); }
"~"                     { return('~'); }
"="                     { return('='); }
">"                     { return('>'); }
"<"                     { return('<'); }
"+"                     { return('+'); }
"-"                     { return('-'); }
","                     { return(','); }
"("                     { return('('); }
")"                     { return(')'); }
{Id}                    { return(NADLID); }
{Number}                { return(NUMBER); }
%%



