////////////////////////////////////////////////////////
// File  : extNADL.cc   
// Desc. : extNADL domain member functions
// Author: Rune M. Jensen
// Date  : 10/12/02
////////////////////////////////////////////////////////

#include <stream.h>
#include <set>
#include <string>
#include "set.hpp"
#include "extNADL.hpp"

////////////////////////////////////////////////////////
//           long constructor functions                         
////////////////////////////////////////////////////////


extNADLtran::extNADLtran(int* dgi,int* dhi, set<string>* m, formula* p, formula* e,formula* er) {
  if (dgi == NULL)
    dgOpt = false;
  else
    {
      dgOpt = true;
      dg = *dgi;
    }
  if (dhi == NULL)
    dhOpt = false;
  else
    {
      dhOpt = true;
      dh = *dhi;
    }


  if (er == NULL)
    errOpt = false;
  else
    {
      errOpt = true;
      err = er;
    }
  
  mod = *m; 
  pre = p; 
  eff = e;
}


void extNADLproblem::initialize(list<varDecl>* v, list<agent>* s, list<agent>* e, 
				formula* i,int* hoi, formula* g,int* hog) {
  vars = *v; 
  sys = *s; 
  if (e == NULL)
    envOpt = false;
  else
    {
      envOpt = true;
      env = *e;
    }
  init = i; 
  if (hoi == NULL)
    heuOptInit = false;
  else
    {
      heuOptInit = true;
      heuInit = *hoi;
    }
  goal = g;
  if (hog == NULL)
    heuOptGoal = false;
  else
    {
      heuOptGoal = true;
      heuGoal = *hog;
    }
}



////////////////////////////////////////////////////////
//           print functions                         
////////////////////////////////////////////////////////

void numberExp::print() {
  switch (type) {
  case nt_number:
    cout << number;
    break;
  case nt_plus:
    cout << "(";
    left->print();
    cout << " + ";
    right->print();
    cout << ")";
    break;
  case nt_minus:
    cout << "(";
    left->print();
    cout << " - ";
    right->print();
    cout << ")";
    break;
  case nt_varCur:
    cout << var;
    break;
  case nt_varNext:
    cout << var << "'";
    break;
  }
}


void numberProp::print() {
  left->print();
  switch (op) {
  case ro_lt:
    cout << " < ";
    break;
  case ro_gt:
    cout << " > ";
    break;
  case ro_eq:
    cout << " = ";
    break;
  case ro_ne:
    cout << " <> ";
    break;
  }
  right->print();
}  



void atom::print() {
  switch (type) {
  case at_numProp:
    cout << "[";
    prop->print();
    cout << "]";
    break;
  case at_boolVarCur:
    cout << var;
    break;
  case at_boolVarNext:
    cout << var << "'";
    break;
  }
}
    


void formula::print() {
  switch (type) {
  case ft_atom:
    atomic->print();
    break;
  case ft_neg:
    cout << "~";
    cout << "{";
    f1->print();
    cout << "}";
    break;
  case ft_and:
    cout << "{";
    f1->print();
    cout << " /\\ ";
    f2->print();
    cout << "}";
    break;
  case ft_or:
    cout << "{";
    f1->print();
    cout << " \\/ ";
    f2->print();
    cout << "}";
    break;
  case ft_impl:
    cout << "{";
    f1->print();
    cout << " => ";
    f2->print();
    cout << "}";
    break;
  case ft_biImpl:
    cout << "{";
    f1->print();
    cout << " <=> ";
    f2->print();
    cout << "}";
    break;
  case ft_ite:
    cout << "{";
    f1->print();
    cout << " -> ";
    f2->print();
    cout << " , ";
    f3->print();
    cout << "}";
    break;
  case ft_true:
    cout << "true";
    break;
  case ft_false:
    cout << "false";
    break;
  case ft_paren:
    cout << "(";
    f1->print();
    cout << ")";
    break;

  }
}    



void extNADLaction::print() {
  cout << "      " << name << "\n";
  for (list<extNADLtran>::iterator ti= trans.begin(); ti != trans.end(); ++ti)
    {
      ti->print();
      cout << "\n\n";
    }  
}


void extNADLtran::print() {
  if (dhOpt)
    cout << "        dh: " << dh << endl;
  if (dgOpt)
    cout << "        dg: " << dg << endl;
  cout << "        mod: ";
  setPrint(mod);
  cout << "\n        pre: ";
  pre->print();
  cout << "\n        eff: ";
  eff->print();
  if (errOpt)
    {
      cout << "\n        err: ";
      err->print();
    }
}


void agent::print() {
  cout << "    agt: " << name << "\n\n";
    
  list<extNADLaction>::iterator i;
  for (i=actions.begin(); i != actions.end(); ++i)
    {
      i->print();
      cout << "\n\n";
    }
}


void varType::print() {
  if (type == vt_bool)
    cout << "    bool  ";
  else
    cout << "    nat(" << range << ")  ";
}




void varDecl::print() {
  type.print();
  setPrint(ids);
  cout << endl;
}



void extNADLproblem::print() {
  cout << "\nvariables\n\n";
  list<varDecl>::iterator i;
  for (i=vars.begin(); i != vars.end(); ++i) 
    i->print();
  cout << "\n\nsystem\n\n";
  list<agent>::iterator j;
  for (j=sys.begin(); j != sys.end(); ++j) 
    j->print();
  if (envOpt)
    {
      cout << "\n\nenvironment\n\n";
      for (j=env.begin(); j != env.end(); ++j) 
	j->print();
    }
  cout << "\n\ninit\n";
  init->print();
  if (heuOptInit)
    cout << "\n heu: " << heuInit;
  cout << "\n\ngoal\n";
  goal->print();
  if (heuOptGoal)
    cout << "\n heu: " << heuGoal;
  cout << "\n";
}







////////////////////////////////////////////////////////
//        functions for converting +- expressions   
//        to + expressions                               
////////////////////////////////////////////////////////


// IN
//  this : numberprop
// OUT
//  numberprop with all '-' expressions eliminated
void numberProp::minus2plus() {
  numberExp *l,*r,*a,*b,*c,*d;

  left->minus2plus();
  right->minus2plus();
    
    if (left->type == nt_number || left->type == nt_varCur || 
	left->type == nt_varNext || left->type == nt_plus)
      {
	if (right->type == nt_number || right->type == nt_varCur || 
	    right->type == nt_varNext || right->type == nt_plus)
	  {
	    // left: +exp,   right: +exp 
	    // already ok: nothing to do
	  }
	else
	  {
	    // org left: +exp,   right: -exp
	    a = left;
	    b = right->left;
	    r = right;
	    r->type = nt_plus;
	    r->left = a;
	    l = b;
	    left = r;
	    right = l;
	  }
      }
    else
      {
	if (right->type == nt_number || right->type == nt_varCur || 
	    right->type == nt_varNext || right->type == nt_plus)
	  {
	    // left: -exp,   right: +exp 
	    a = left->left;
	    c = right;
	    l = left;
 	    l->type = nt_plus;
	    l->left = c;
	    r = a;
	    left = r;
	    right = l;
	  }
	else
	  {
	    // left: -exp,   right: -exp 
	    b = left->right;
	    d = right->right;
	    l = left;
	    l->type = nt_plus;
	    l->right = d;
	    r = right;
	    r->type = nt_plus;
	    r->right = b;
	  }
      }
}




// IN
//  this : numberexp
// OUT
//  numberexp with only one top '-' expression
void numberExp::minus2plus() {
  numberExp *l,*r,*a,*b,*c,*d;

  switch (type) {
  case nt_number:
  case nt_varCur:
  case nt_varNext:
    // already ok: do nothing
    break;
  case nt_plus:
    left->minus2plus();
    right->minus2plus();
    if (left->type == nt_number || left->type == nt_varCur || 
	left->type == nt_varNext || left->type == nt_plus)
      {
	if (right->type == nt_number || right->type == nt_varCur || 
	    right->type == nt_varNext || right->type == nt_plus)
	  {
	    // org: +exp, left: +exp,   right: +exp 
	    // already ok: do nothing
	  }
	else
	  {
	    // org +exp, left: +exp,   right: -exp
	    a = left;
	    c = right->right;
	    l = c;
	    r = right;
	    r->right = a;
	    r->type = nt_plus;
            type = nt_minus;
	    left = r;
	    right = l;
	  }
      }
    else
      {
	if (right->type == nt_number || right->type == nt_varCur || 
	    right->type == nt_varNext || right->type == nt_plus)
	  {
	    // org: +exp, left: -exp,   right: +exp 
	    b = left->right;
	    c = right;
	    l = left;
	    l->right = c;
	    l->type = nt_plus;
	    r = b;
	    type = nt_minus;
	    left = l;
	    right = r;
	  }
	else
	  {
	    // org +exp, left: -exp,   right: -exp
	    b = left->right;
	    c = right->left;
	    l = left;
	    l->type = nt_plus;
	    l->right = c;
	    r = right;
	    r->type = nt_plus;
	    r->left = b;
	    type = nt_minus;
	  }
      }
    break;
  case nt_minus:
    left->minus2plus();
    right->minus2plus();
    if (left->type == nt_number || left->type == nt_varCur || 
	left->type == nt_varNext || left->type == nt_plus)
      {
	if (right->type == nt_number || right->type == nt_varCur || 
	    right->type == nt_varNext || right->type == nt_plus)
	  {
	    // org: -exp, left: +exp,   right: +exp
	    // already ok : do nothing
	  }
	else
	  {
	    // org -exp, left: +exp,   right: -exp
	    a = left;
	    b = right->left;
	    l = b;
	    r = right;
	    r->type = nt_plus;
	    l->left = a;
	    left = r;
	    right = l;
	  }
      }
    else
      {
	if (right->type == nt_number || right->type == nt_varCur || 
	    right->type == nt_varNext || right->type == nt_plus)
	  {
	    // org: -exp, left: -exp,   right: +exp 
	    a = left->left;
	    c = right;
	    l = left;
	    l->type = nt_plus;
	    l->left = c;
	    r = a;
	    left = r;
	    right = l;
	  }
	else
	  {
	    // org -exp, left: -exp,   right: -exp
	    b = left->right;
	    d = right->right;
	    l = left;
	    l->type = nt_plus;
	    l->right = d;
	    r = right;
	    r->type = nt_plus;
	    r->right = b;
	  }
      }
    break;
  }
}




