///////////////////////////////////////////////////////
// File  : detSearchAlg.hpp  
// Desc. : Header for detSearchAlg.cc
// Author: Rune M. Jensen CS, CMU
// Date  : 10/28/02
///////////////////////////////////////////////////////

#ifndef DETSEARCHALGHPP
#define DETSEARCHALGHPP

#include <list>
#include <utility>
#include <queue>

#include "bddLayout.hpp"
#include "partition.hpp"
#include "universal.hpp"
#include "searchQueue.hpp"
#include "searchAlgAuxFunc.hpp"



////////////////////////////////
// Prototypes
////////////////////////////////

// blind search
list<string> bidir(TRel& TAct,TRel& T,bdd init, bdd goal, bool frontierSimpl);
list<string> forward(TRel& TAct,TRel& T,bdd init, bdd goal, bool frontierSimpl);
list<string> backward(TRel& TAct,TRel& T,bdd init, bdd goal, bool frontierSimpl);

// heuristic search
list<string> SetAstar(TRel& TAct,TRel& T,bdd init, bdd goal, 
		      int hinit,int upperBound, double wg, double wh);
list<string> SetAstarBackward(TRel& Tact,TRel& T, bdd init, bdd goal,
		      int hinit,int upperBound, double wg, double wh);
list<string> FminAstar(TRel& Tact,TRel& T, bdd init, bdd goal,int hInit,int u, double wg, double wh);
list<string> FminAstarBackward(TRel& Tact,TRel& T, bdd init, bdd goal,int hInit,int u, double wg, double wh);
list<string> pureFminAstarBackward(TRel& Tact,TRel& T, bdd init, bdd goal,int hInit);

#endif  
