//////////////////////////////////////////////////////////
// File  : checkPlan.cc
// Desc. : This file implements a check function for 
//         plans for non-deterministic domains
// Author: Rune M. Jensen
// Date  : 10/30/02
//////////////////////////////////////////////////////////

#include <bdd.h>
#include "bddLayout.hpp"
#include "partition.hpp"
#include "universal.hpp"
#include "searchAlgAuxFunc.hpp"


//    Checking whether the only outgoing 
//    execution traces are to goal states.
bool planIsTotal(TRel T, ActInfo& Ainfo, bdd init, bdd goal, bdd& universalPlan) {

  bdd coveredStates = bdd_exist(universalPlan,Ainfo.Avars);
  bdd frontier = init;
  bdd reachedStates = init;

  // prune transitions from T that are not a part of the plan
  for (int i = 0; i < T.p.size(); i++)
    T.p[i].exp &= universalPlan;

  cout << "Checking whether the only outgoing execution traces are to goal states ";

  do 
    {
      frontier = bdd_exist(image(T,frontier),Ainfo.Avars);      
      // prune previously visited states
      frontier &= !reachedStates;
      // prune goal states
      frontier &= !goal;
      cout << ".";
      cout.flush();
      // check if any trace is outgoing      
      if ( (frontier & !coveredStates) != bddfalse )
	{
	  cout << " Found non-goal outgoing execution trace! Plan is not ok!\n";
	  return false;  
	}
      reachedStates |= frontier;
    }
  while (frontier != bddfalse);
  cout << " Plan is ok!\n";
  return true;
}    




//   Checking whether faults in USA are covered by RSA for a 1-fault 
//   execution traces are to goal states.
bool faultCovered(TRel Teff, TRel Terr, ActInfo& Ainfo, bdd init, bdd goal, bdd& USA, bdd& RSA) {

  bdd RS = bdd_exist(RSA,Ainfo.Avars) | goal;
  bdd frontier = init;
  bdd frontierErr;
  bdd reachedStates = init;

  // prune transitions from Teff and Terr that are not a part of the plan
  for (int i = 0; i < Teff.p.size(); i++)
    Teff.p[i].exp &= USA;
  for (int i = 0; i < Terr.p.size(); i++)
    Terr.p[i].exp &= USA;

  cout << "Checking whether all fault states are covered by RSA ";

  do 
    {
      frontierErr = bdd_exist(image(Terr,frontier),Ainfo.Avars);
      
      if ( (frontierErr & !RS) != bddfalse )
	{
	  cout << " Found non-covered fail state! Fault tolerant plan is not ok!\n";
	  return false;  
	}
      
      frontier = bdd_exist(image(Teff,frontier),Ainfo.Avars);

      // prune previously visited states
      frontier &= !reachedStates;
      // prune goal states
      frontier &= !goal;
      cout << ".";
      cout.flush();
      reachedStates |= frontier;
    }
  while (frontier != bddfalse);

  cout << " Plan is ok!\n";
  return true;
}    








