//////////////////////////////////////////////////////////
// File  : bdda.search.hpp
// Desc. : pure-BDDA* and BDDA* algorithm implementations
// Author: Rune M. Jensen
// Date  : 5/8/02
//////////////////////////////////////////////////////////
#ifndef BDDASEARCHHPP
#define BDDASEARCHHPP

#include <list>
#include <bdd.h>
#include "symbolicHeuristic.hpp"
#include "bddLayout.hpp"
#include "partition.hpp"

// externs statistics var
extern double Tsearch;
extern double Textract;
extern int    iterationNum;
extern int    timeout;

  
list<string> pureBDDAstarBackward(PDDLbddBDDAlayout& layout,FHinfo& fhInfo,
				  bdd heuristic,TRel &TAct,TRel &T,bdd init, bdd goal);
  
list<string> BDDAstarBackward(PDDLbddBDDAlayout& layout,FHinfo& fhInfo,BDDAinfo& bddaInfo,
			      bdd heuristic,TRel &Tact,TRel &T,bdd init, bdd goal);


list<string> BDDAstar(NADLbddBDDAlayout& layout,FHinfo& fhInfo,BDDAinfo& bddaInfo,
		      bdd heuristic,TRel &Tact,TRel &T,bdd init, bdd goal);


list<string> PubpureBDDAstarBackward(PDDLbddPubBDDAlayout& layout,PubFHinfo& fhInfo,
				     bdd heuristic,TRel &Tact,TRel &T,bdd init, bdd goal);


list<string> PubBDDAstarBackward(PDDLbddPubBDDAlayout& layout,PubFHinfo& fhInfo,PubBDDAinfo& bddaInfo,
				 bdd heuristic,TRel &Tact,TRel &T,bdd init, bdd goal);

list<string> PubBDDAstar(NADLbddPubBDDAlayout& layout,PubFHinfo& fhInfo,PubBDDAinfo& bddaInfo,
			 bdd heuristic,TRel &Tact,TRel &T,bdd init, bdd goal);


#endif


