////////////////////////////////////////////////////////
// File  : balancedInfo.hpp   
// Desc. : Functions for deriving sets of balanced 
//	   fluents of a domain
// Author: Rune M. Jensen
// Date  : 1/10/02
////////////////////////////////////////////////////////

#ifndef BALANCEDINFOHPP
#define BALANCEDINFOHPP
 
#include<set>
#include<map>
#include "numDomain.hpp"
#include "reachInfo.hpp"



// structure holding data produced and used
// by the balanced fluents algorithm
struct balancedInfo {

  // property bit vector rep. vars.
  int predShift;
  int predMask;

  map< int, set<int> >  propertyDom;     // domain of each property (property given as bitvector, 
                                         // domain: set of objects
  void analyse(reachInfo &reached,numDomain &numDom);      
                                         // initializes the vars above and
                                         // performes the analysis below

  set< set<int> > s;                     // set of balanced properties. Each element is set of
                                         // properties on bitvector form
  void makeCandidates();                 // step 1. make the candidate set, s
  
  set< set<int> > t;                     // all tried balanced properties
  set< set<int> > b;                     // set of balanced properties
  bool holdsInInit(set<int> bProperties,numDomain &numDom);
  bool holdsForActions(set<int> bProperties,numDomain &numDom); 
  void findBalanced(numDomain &numDom);  // step 2. inductive prove the set of balanced properties

  set< set<int> > c;                     // chosen set of balanced properties covering the predicates
  vector< set< vector<int> > > cv;       // expanded vectorform of c
  void coverPredicates();                // step 3. choose balanced sets covering domain predicates
  void print(numDomain &numDom);
};


// prototypes
inline int property2id(vector<int> &property,int &predShift);
inline void id2property(int &id, vector<int> &property, 
			int &predMask,
			int &predShift);


#endif  
