////////////////////////////////////////////////////////
// File  : SA.cc
// Desc. : routines for printing an OBDD representing
//         a set of state action rules
//
//         Assumes a single system agent !!!!!!!
//
// Author: Rune M. Jensen, CS, CMU 
// Date  : 10/28/02
////////////////////////////////////////////////////////

#include <iostream.h>
#include <fstream.h>
#include <stream.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include <set>
#include <map>
#include <string>
#include <vector>
#include "bddLayout.hpp"
#include "SA.hpp"
#include "common.hpp"


SA::SA(char *fileName,NADLNonDetbddLayout& layoutIn) { 
  strcpy(outFileName,fileName); 
  outFile.open(fileName,ios::out);
  layout = &layoutIn; 
} 



// reads one variable assignment
// of the bdd_printset format 
int parse(FILE* setFile,int* as,int asLen) {
  int varNo,value;
  char c;
  
  //check if file T or False
  c = getc(setFile);
  
  if ( c == 'F' || c == EOF )
    return 0;
  else 
    if ( c == 'T' )
      {
	// set all variables to -1 (any value)
	for (int i = 0; i < asLen; i++)
	  as[i] = -1;
	return 1;
      }
    else
      if ( c == '<' ) 
	{  
	  // there is an assignment to read

	  // set all variables to -1 (any value)
	  for (int i = 0; i < asLen; i++)
	    as[i] = -1;
	  
	  // read assignment 	  
	  while(c != '>') {
	    
	    // pre: pointer is at first digit
	    // in var. assignment
	    if (fscanf(setFile,"%d:%d",&varNo,&value) != 2)
	      {
		cout << "\nSA.cc parse: scan error";
		cout << "\nexiting\n";
	      }
	    as[varNo] = value;
	    // post: pointer is just after last difit
	    // in var. assignment 
	    c = getc(setFile);
	  }
	  return 1;
	}
}

	
  

// Aux. functiond for SA::print 


void mkSpace(ofstream &out,int n) {
  int i;
  for (i=0;i<n;i++)
    out << " ";
}

int max(int a,int b) {
  return a > b ? a : b;
} 

int bin2intStr(int* as,int* var,int length,char* buf) {
  int i,exp,res;
  
  res = 0;
  exp = length - 1;
  for (i= 0; i < length; i++)
    if (as[var[i]] < 0) 
      return 0;
    else
      res += as[var[i]]*int(pow(2,exp--));
    sprintf(buf,"%d",res);
    return 1;
}
  

char *rawRep(int *as,int *var,int length,char *buf) {
  int i;
 
  strcpy(buf,"");
  for (i=0; i<length; i++)
    switch (as[var[i]]) {
    case 0 : 
      strcat(buf,"0");
      break;
    case 1 :
      strcat(buf,"1");
      break;
    default:
      strcat(buf,"*");
      break;
    }
  return buf;
}
    



void SA::print(bdd b) {
   
  char        buf[MAXNAMELENGTH];         


  // open outputfile for bdd_printset
  if ( (setFile = fopen("deleteme.txt","w+")) == NULL)
    {
      cout << "SA.cc SA::print: ";
      cout << "cannot open \"deleteme.txt\"\nexiting\n\n";
      exit(1);
    }

  // make the set
  bdd_fprintset(setFile,b);
  fflush(setFile);
  rewind(setFile);


  /////////////////////
  // write action info
  /////////////////////
  outFile << "Sys Agent: ";
  for (int i = 0; i < layout->agt.act.size(); i++)
    outFile << layout->agt.act[i].name << "(" << i << ") ";
  outFile << "\n";

  if (layout->envActive)
    {
      outFile << "Env Agent: ";
      for (int i = 0; i < layout->agtEnv.act.size(); i++)
	outFile << layout->agtEnv.act[i].name << "(" << i << ") ";
      outFile << "\n";
    }

  outFile << "\n";
    
  
  ////////////////
  // write header
  ////////////////

  int actLenEnv = 6;
  // write environement action
  if (layout->envActive)
    {
      outFile << "EnvAct";
      // find action name needing most space
      for (int i = 0; i < layout->agtEnv.act.size(); i++)
	actLenEnv = max(actLenEnv, layout->agtEnv.act[i].name.size()); 
      actLenEnv += 2;
      mkSpace(outFile,actLenEnv - 6);
    }


  outFile << "SysAct";
  // find action name needing most space
  int actLenSys = 6;
  for (int i = 0; i < layout->agt.act.size(); i++)
    actLenSys = max(actLenSys, layout->agt.act[i].name.size()); 
  actLenSys += 2;
  mkSpace(outFile,actLenSys - 6);


  // write state variables
  for (int i = 0; i < layout->var.size(); i++)
    {
      NADLvarDef var(layout->var[i]);
      outFile << var.name;
      mkSpace(outFile,
	      max(var.name.length() + 2,(var.length + 1)*2) - var.name.length());
    }
  outFile << "\n";

  // Init assignment table
  int asLen = layout->bddVarNum;
  int* as = new int[asLen]; 

  // go through all lines in the table
  while (parse(setFile,as,asLen))
    {
      // write the environment action if environment is active
      if (layout->envActive)
	{
	  NADLvarDef var(layout->actIDenv);        
	  if (bin2intStr(as,var.current,var.length,buf))
	    {
	      if ( atoi(buf) < layout->agtEnv.act.size() )
		{
		  // action can be written by its name
		  outFile << (layout->agtEnv.act[atoi(buf)].name);
		  mkSpace(outFile,actLenEnv - layout->agtEnv.act[atoi(buf)].name.length());
		}
	      else
		{
		  // action doesn't exist write the number
		  outFile << buf;
		  mkSpace(outFile,actLenEnv - strlen(buf));
		}
	    }
	  else
	    {
	      // the line defines a set of actions
	      // we have to write the number pattern
	      outFile << rawRep(as,var.current,var.length,buf);
	      mkSpace(outFile,actLenEnv - strlen(buf));
	    }
	}


      
      // write the system action
      NADLvarDef var(layout->actID);        
      if (bin2intStr(as,var.current,var.length,buf))
	{
	  if ( atoi(buf) < layout->agt.act.size() )
	    {
	      // action can be written by its name
	      outFile << (layout->agt.act[atoi(buf)].name);
	      mkSpace(outFile,actLenSys - layout->agt.act[atoi(buf)].name.length());
	    }
	  else
	    {
	      // action doesn't exist write the number
	      outFile << buf;
	      mkSpace(outFile,actLenSys - strlen(buf));
	    }
	}
      else
	{
	  // the line defines a set of actions
	  // we have to write the number pattern
	  outFile << rawRep(as,var.current,var.length,buf);
	  mkSpace(outFile,actLenSys - strlen(buf));
	}
      
      
      // write individual variable info
      for (int k = 0; k < layout->var.size(); k++)
	{
	  NADLvarDef var(layout->var[k]);   

	  int len = max(var.name.length() + 2, (var.length + 1)*2);
	  int plen = 0;
    	  if (var.type == bt_bool)
	    {
	      outFile << rawRep(as,var.current,var.length,buf) << " ";
	      outFile << rawRep(as,var.next,var.length,buf);
	      mkSpace(outFile,len - 3);
	    }
	  else
	    {
	      // variable is integer
	      // write current state integer variable
	      if (bin2intStr(as,var.current,var.length,buf))
		{
		  // integer can be represented as a number
		  outFile << buf << " ";
		  plen += strlen(buf) + 1;
		}
	      else
		{
		  // integer must be represented by its number pattern
		  outFile << rawRep(as,var.current,var.length,buf) << " ";
		  plen += strlen(buf) + 1;
		}


	      // write next state integer variable
	      if (bin2intStr(as,var.next,var.length,buf))
		{
		  // integer can be represented as a number
		  outFile << buf << " ";
		  plen += strlen(buf) + 1;
		}
	      else
		{
		  // integer must be represented by its number pattern
		  outFile << rawRep(as,var.next,var.length,buf) << " ";
		  plen += strlen(buf) + 1;
		}
	      mkSpace(outFile,len - plen);
	    }
	}
      // next line
      outFile << "\n";
    }
  outFile.flush();
  
  
  // remove outputfile for bdd_printset
  system("rm -f deleteme.txt");
  fclose(setFile);
}
	      



