/****************************************************** 
 * File  : ltdiningphil.cc   
 * Desc. : Generator program for NADL dining philosophers
 *         domain (n is the number of philosephors)
 *         dining at a longtable
 * Author: Rune M. Jensen CS, CMU
 * Date  : 1/12/01
 ******************************************************/

#include <math.h>
#include <iostream.h>
#include <fstream.h>
#include <stdlib.h>


int main(int argc, char **argv) {
  
  int i,j;
  int n;

  // check input
  if (argc != 3)
    {
      cout << "Usage: ltdiningphil <n:even nat> <domain>.nadl\n";
      exit(1);
    }

  ofstream  out(argv[2],ios::out);
  n = atoi(argv[1]);

  if (n % 2 != 0)
    {
      cout << "Usage: ltdiningphil <n:even nat> <domain>.nadl\n";
      cout << "       n must be an even number !!\n";
      exit(1);
    }
      
  // write head
  out << "\% File:   " << argv[2] << "\n";
  out << "\% Desc:   " << n << " Dining philosophers at a long table\n";
  out << "\% Date:   01\n";
  out << "\% Auth:   Rune M. Jensen CS, CMU\n";

  // write variables
  out << "\nVARIABLES\n";
  out << "\% pil : fork in philosopher i's left hand\n";
  out << "\% pir : fork in philosopher i's right hand\n";

  out << "  bool ";
  for (i=0; i<n; i++) {
    if (i != 0) out << ",\n       ";
    out << "pl" << i << ", pr" << i;
  }

  // write actions
  out << "\n\n\nSYSTEM\n";
  out << "\n  agt: Action";


  out << "\n\n";

  // philosopher 0
  out << "   TakeRight0\n";
  out << "     con: pr0\n";
  out << "     pre: ~pr0 /\\ ~pl1\n";
  out << "     eff: pr0'\n\n";
  
  out << "   TakeLeft0\n";
  out << "     con: pl0\n";
  out << "     pre: ~pl0\n";
  out << "     eff: pl0'\n\n";

  out << "   PutRight0\n";
  out << "     con: pr0\n";
  out << "     pre: pr0\n";
  out << "     eff: ~pr0'\n\n";
  
  out << "   PutLeft0\n";
  out << "     con: pl0\n";
  out << "     pre: pl0\n";
  out << "     eff: ~pl0'\n\n";
    
  
  // philosopher 1 - n-1  
  for (i=1; i < n-1; i++) {
    
    out << "\n\n";
    
    out << "   TakeRight" << i << endl;
    out << "     con: pr" << i << endl;
    out << "     pre: ~pr" << i << " /\\ ~pl" << i+1 <<   endl;
    out << "     eff: pr" << i << "'\n\n";
    
    out << "   TakeLeft" << i << endl;
    out << "     con: pl" << i << endl;
    out << "     pre: ~pl" << i << " /\\ ~pr" << i-1 <<   endl;
    out << "     eff: pl" << i << "'\n\n";

    out << "   PutRight" << i << endl;
    out << "     con: pr" << i << endl;
    out << "     pre: pr" << i << endl;
    out << "     eff: ~pr" << i << "'\n\n";
    
    out << "   PutLeft" << i << endl;
    out << "     con: pl" << i << endl;
    out << "     pre: pl" << i << endl;
    out << "     eff: ~pl" << i << "'\n\n";

  }

  // philosopher n
  out << "\n\n";
  
  out << "   TakeRight" << n-1 << endl;
  out << "     con: pr" << n-1 << endl;
  out << "     pre: ~pr" << n-1<< endl;
  out << "     eff: pr" << n-1 << "'\n\n";
  
  out << "   TakeLeft" << n-1 << endl;
  out << "     con: pl" << n-1 << endl;
  out << "     pre: ~pl" << n-1 << " /\\ ~pr" << n-2 << endl;
  out << "     eff: pl" << n-1 << "'\n\n";
  
  out << "   PutRight" << n-1 << endl;
  out << "     con: pr" << n-1 << endl;
  out << "     pre: pr" << n-1 << endl;
  out << "     eff: ~pr" << n-1 << "'\n\n";
  
  out << "   PutLeft" << n-1 << endl;
  out << "     con: pl" << n-1 << endl;
  out << "     pre: pl" << n-1 << endl;
  out << "     eff: ~pl" << n-1 << "'\n\n";



  out << "ENVIRONMENT\n\n";

  out << "INITIALLY\n";
  for (i=0; i < n/2; i++) {
    if (i != 0)
      out << "   /\\ ";
    else
      out << "      ";
    out << "pr" << 2*i << " /\\ pl" << 2*i << "\n";
  }

  for (i=0; i < n/2; i++) {
      out << "";
    out << "   /\\ ~pr" << 2*i+1 << " /\\ ~pl" << 2*i+1 << "\n";
  } 
  
  out << "\nGOAL\n";
  for (i=0; i < n/2; i++) {
    if (i != 0)
      out << "   /\\ ";
    else
      out << "      ";
    out << "pr" << 2*i+1 << " /\\ pl" << 2*i+1 << "\n";
  }

}

