
;;;
;;; SOKOBAN TRANSLATED MAP:
;;;
;;; x: 9, y: 10
;;;
;;;     
;;; 
;;;  ####
;;;  #@ #
;;;  #  #
;;; ##. ####
;;; # $$. .#
;;; #  $ ###
;;; ###  #
;;;   ####
;;; 


(define (problem translated-sokoban)
   (:domain typed-sokoban)
   (:objects
      up down left right
      ball0 ball1 ball2 
      f2-3f f3-3f 
      f2-4f f3-4f 
      f2-5f f3-5f 
      f1-6f f2-6f f3-6f f4-6f f5-6f f6-6f 
      f1-7f f2-7f f3-7f f4-7f 
      f3-8f f4-8f 
   )

   (:init
      (direction up) 
      (direction down) 
      (direction left) 
      (direction right)
      (ball ball0) 
      (ball ball1) 
      (ball ball2) 
      (navigable f2-3f)	 
      (navigable f2-4f)	 
      (navigable f2-5f)	 
      (navigable f1-6f)	   
      (navigable f1-7f)	   
      (navigable f3-8f)	 
      (navigable f3-3f)
      (navigable f3-4f)
      (navigable f3-5f)
      (navigable f2-6f)
      (navigable f2-7f)
      (navigable f4-8f)
      (navigable f3-6f)
      (navigable f3-7f)
      (navigable f4-6f)
      (navigable f4-7f)
      (navigable f5-6f)	
      (navigable f6-6f)	
      (adjacent f2-3f f3-3f right)
      (adjacent f2-3f f2-4f down)
      (adjacent f3-3f f2-3f left)
      (adjacent f3-3f f3-4f down)
      (adjacent f2-4f f3-4f right)
      (adjacent f2-4f f2-5f down)
      (adjacent f2-4f f2-3f up)
      (adjacent f3-4f f2-4f left)
      (adjacent f3-4f f3-5f down)
      (adjacent f3-4f f3-3f up)
      (adjacent f2-5f f3-5f right)
      (adjacent f2-5f f2-6f down)
      (adjacent f2-5f f2-4f up)
      (adjacent f3-5f f2-5f left)
      (adjacent f3-5f f3-6f down)
      (adjacent f3-5f f3-4f up)
      (adjacent f1-6f f2-6f right)
      (adjacent f1-6f f1-7f down)
      (adjacent f2-6f f3-6f right)
      (adjacent f2-6f f1-6f left)
      (adjacent f2-6f f2-7f down)
      (adjacent f2-6f f2-5f up)
      (adjacent f3-6f f4-6f right)
      (adjacent f3-6f f2-6f left)
      (adjacent f3-6f f3-7f down)
      (adjacent f3-6f f3-5f up)
      (adjacent f4-6f f5-6f right)
      (adjacent f4-6f f3-6f left)
      (adjacent f4-6f f4-7f down)
      (adjacent f5-6f f6-6f right)
      (adjacent f5-6f f4-6f left)
      (adjacent f6-6f f5-6f left)
      (adjacent f1-7f f2-7f right)
      (adjacent f1-7f f1-6f up)
      (adjacent f2-7f f3-7f right)
      (adjacent f2-7f f1-7f left)
      (adjacent f2-7f f2-6f up)
      (adjacent f3-7f f4-7f right)
      (adjacent f3-7f f2-7f left)
      (adjacent f3-7f f3-8f down)
      (adjacent f3-7f f3-6f up)
      (adjacent f4-7f f3-7f left)
      (adjacent f4-7f f4-8f down)
      (adjacent f4-7f f4-6f up)
      (adjacent f3-8f f4-8f right)
      (adjacent f3-8f f3-7f up)
      (adjacent f4-8f f3-8f left)
      (adjacent f4-8f f4-7f up)

      (empty f3-3f)
      (empty f2-4f)
      (empty f3-4f)
      (empty f2-5f)
      (empty f3-5f)
      (empty f1-6f)
      (empty f4-6f)
      (empty f5-6f)
      (empty f6-6f)
      (empty f1-7f)
      (empty f2-7f)
      (empty f4-7f)
      (empty f3-8f)
      (empty f4-8f)

      (at ball0 f2-6f)
      (at ball1 f3-6f)
      (at ball2 f3-7f)

      (at-robot f2-3f)
   )

   (:goal
      (and
      (at-robot f2-3f)
      (at ball0 f2-5f)
      (at ball1 f4-6f)
      (at ball2 f6-6f)
	(empty f2-4f)	 
	(empty f1-6f)	   
	(empty f1-7f)	   
	(empty f3-8f)	 
	(empty f3-3f)
	(empty f3-4f)
	(empty f3-5f)
	(empty f2-6f)
	(empty f2-7f)
	(empty f4-8f)
	(empty f3-6f)
	(empty f3-7f)
	(empty f4-7f)
	(empty f5-6f)	
      )
   )
)

