
;;;
;;; SOKOBAN TRANSLATED MAP:
;;;
;;; x: 9, y: 9
;;;
;;;     
;;; 
;;; ########
;;; #.   . #
;;; # # #  #
;;; #@$  $.#
;;; ##### $#
;;;     #  #
;;;     ####
;;; 


(define (problem translated-sokoban)
   (:domain typed-sokoban)
   (:objects
      up down left right
      ball0 ball1 ball2 
      f1-3f f2-3f f3-3f f4-3f f5-3f f6-3f 
      f1-4f f3-4f f5-4f f6-4f 
      f1-5f f2-5f f3-5f f4-5f f5-5f f6-5f 
      f5-6f f6-6f 
      f5-7f f6-7f
   )

   (:init
      (direction up) 
      (direction down) 
      (direction left) 
      (direction right)
      (ball ball0) 
      (ball ball1) 
      (ball ball2) 
      (navigable f1-3f)	     
      (navigable f1-4f)		 
      (navigable f1-5f)	     
      (navigable f5-6f)	 
      (navigable f5-7f)	
      (navigable f2-3f)
      (navigable f3-4f)
      (navigable f2-5f)
      (navigable f6-6f)
      (navigable f6-7f)
      (navigable f3-3f)
      (navigable f5-4f)
      (navigable f3-5f)
      (navigable f4-3f)
      (navigable f6-4f)
      (navigable f4-5f)
      (navigable f5-3f)		  
      (navigable f5-5f)
      (navigable f6-3f)	    
      (navigable f6-5f)
      (adjacent f1-3f f2-3f right)
      (adjacent f1-3f f1-4f down)
      (adjacent f2-3f f3-3f right)
      (adjacent f2-3f f1-3f left)
      (adjacent f3-3f f4-3f right)
      (adjacent f3-3f f2-3f left)
      (adjacent f3-3f f3-4f down)
      (adjacent f4-3f f5-3f right)
      (adjacent f4-3f f3-3f left)
      (adjacent f5-3f f6-3f right)
      (adjacent f5-3f f4-3f left)
      (adjacent f5-3f f5-4f down)
      (adjacent f6-3f f5-3f left)
      (adjacent f6-3f f6-4f down)
      (adjacent f1-4f f1-5f down)
      (adjacent f1-4f f1-3f up)
      (adjacent f3-4f f3-5f down)
      (adjacent f3-4f f3-3f up)
      (adjacent f5-4f f6-4f right)
      (adjacent f5-4f f5-5f down)
      (adjacent f5-4f f5-3f up)
      (adjacent f6-4f f5-4f left)
      (adjacent f6-4f f6-5f down)
      (adjacent f6-4f f6-3f up)
      (adjacent f1-5f f2-5f right)
      (adjacent f1-5f f1-4f up)
      (adjacent f2-5f f3-5f right)
      (adjacent f2-5f f1-5f left)
      (adjacent f3-5f f4-5f right)
      (adjacent f3-5f f2-5f left)
      (adjacent f3-5f f3-4f up)
      (adjacent f4-5f f5-5f right)
      (adjacent f4-5f f3-5f left)
      (adjacent f5-5f f6-5f right)
      (adjacent f5-5f f4-5f left)
      (adjacent f5-5f f5-6f down)
      (adjacent f5-5f f5-4f up)
      (adjacent f6-5f f5-5f left)
      (adjacent f6-5f f6-6f down)
      (adjacent f6-5f f6-4f up)
      (adjacent f5-6f f6-6f right)
      (adjacent f5-6f f5-7f down)
      (adjacent f5-6f f5-5f up)
      (adjacent f6-6f f5-6f left)
      (adjacent f6-6f f6-7f down)
      (adjacent f6-6f f6-5f up)
      (adjacent f5-7f f6-7f right)
      (adjacent f5-7f f5-6f up)
      (adjacent f6-7f f5-7f left)
      (adjacent f6-7f f6-6f up)

      (empty f1-3f)
      (empty f2-3f)
      (empty f3-3f)
      (empty f4-3f)
      (empty f5-3f)
      (empty f6-3f)
      (empty f1-4f)
      (empty f3-4f)
      (empty f5-4f)
      (empty f6-4f)
      (empty f3-5f)
      (empty f4-5f)
      (empty f6-5f)
      (empty f5-6f)
      (empty f5-7f)
      (empty f6-7f)

      (at ball0 f2-5f)
      (at ball1 f5-5f)
      (at ball2 f6-6f)

      (at-robot f1-5f)
   )

   (:goal
      (and
      (at-robot f1-5f)
      (at ball0 f1-3f)
      (at ball1 f5-3f)
      (at ball2 f6-5f)
      (empty f1-4f)		 
      (empty f5-6f)	 
      (empty f5-7f)	
      (empty f2-3f)
      (empty f3-4f)
      (empty f2-5f)
      (empty f6-6f)
      (empty f6-7f)
      (empty f3-3f)
      (empty f5-4f)
      (empty f3-5f)
      (empty f4-3f)
      (empty f6-4f)
      (empty f4-5f)
      (empty f5-5f)
      (empty f6-3f)	    

      )
   )
)

