

/* C code reading in a hanoi-task graphical description,
 * and generating PDDL STRIPS output.
 */



#define MAX_LENGTH 256


/* data structures ... (ha ha)
 */
typedef unsigned char Bool;
#define TRUE 1
#define FALSE 0




#include <stdlib.h>
#include <stdio.h>
#include <strings.h>
#include <sys/timeb.h>




/* commands
 */
char *gdata;






/* command line
 */
void usage( void );
Bool process_command_line( int argc, char *argv[] );





/* sokoban field
 */
char **gf;
int gx, gy;





int main( int argc, char *argv[] )

{

  FILE *data;

  int mx, x, y, i, j, nballs, nnavigables;
  Bool sw, ppf;
  Bool **nf;
  char c;

  if ( !process_command_line( argc, argv ) ) {
    usage();
    exit( 1 );
  }

  if ( (data = fopen( gdata, "r")) == NULL ) {
    printf("\n\nCannot open file %s.\n\n", gdata);
    exit( 1 );
  }

  gy = 0;
  mx = 0;
  x = 0;
  while ( (c = getc( data )) != EOF ) {
    if ( c == '\n' ) {
      x++;
      if ( x > mx ) mx = x;  
      x = 0;
      gy++;
    } else {
      x++;
    }
  }
  gx = mx;
  gf = ( char ** ) calloc( gx, sizeof( char * ) );
  nf = ( Bool ** ) calloc( gx, sizeof( Bool * ) );
  for ( i = 0; i < gx; i++ ) {
    gf[i] = ( char * ) calloc( gy, sizeof( char ) );
    nf[i] = ( Bool * ) calloc( gy, sizeof( Bool ) );
  }
  data = fopen( gdata, "r");
  y = 0;
  x = 0;
  while ( (c = getc( data )) != EOF ) {
    if ( c == '\n' ) {
      gf[x][y] = '\n';
      x = 0;
      y++;
    } else {
      if ( c == '.' ||
	   c == '$' ||
	   c == '@' ||
	   c == '#' ) {
	gf[x++][y] = c;
      } else {
	gf[x++][y] = ' ';
      }
    }
  }

  /* to see what is happening
   */
  printf("\n;;;\n;;; SOKOBAN TRANSLATED MAP:");
  printf("\n;;;\n;;; x: %d, y: %d\n;;;\n;;; ", gx, gy);
  for ( i = 0; i < gy; i++ ) {
    for ( j = 0; j < gx; j++ ) {
      printf("%c", gf[j][i]);
      if ( gf[j][i] == '\n' ) break;
    }
    printf(";;; ");
  }

  printf("\n\n\n(define (problem translated-sokoban)");
  printf("\n   (:domain typed-sokoban)");

  printf("\n   (:objects");
  printf("\n      up down left right - direction");

  printf("\n      ");
  nballs = 0;
  for ( x = 0; x < gx; x++ ) {
    for ( y = 0; y < gy; y++ ) {
      if ( gf[x][y] == '$' ) {
	printf("ball%d ", nballs++);
      }
    }
  }
  printf("- ball");

  for ( y = 0; y < gy; y++ ) {
    for ( x = 0; x < gx; x++ ) {
      nf[x][y] = FALSE;
    }
  }
  nnavigables = 0;
  for ( y = 0; y < gy; y++ ) {
    sw = FALSE;
    ppf = FALSE;
    for ( x = 0; x < gx; x++ ) {
      if ( gf[x][y] == '#' ) {
	while ( gf[x][y] == '#' ) x++;
	if ( gf[x][y] == '\n' ) break;
	sw = TRUE;
      }
      if ( sw ) {
	if ( !ppf ) {
	  printf("\n      ");
	}
	ppf = TRUE;
	printf("f%d-%df ", x, y);
	nf[x][y] = TRUE;
	nnavigables++;
      }
    }
  }
  printf("- navigable");

  printf("\n   )\n");


  printf("\n   (:init\n");

  for ( y = 0; y < gy; y++ ) {
    for ( x = 0; x < gx; x++ ) {
      if ( nf[x][y] ) {
	if ( nf[x+1][y] ) {
	  printf("\n      (adjacent f%d-%df f%d-%df right)", x, y, x+1, y);
	}
	if ( nf[x-1][y] ) {
	  printf("\n      (adjacent f%d-%df f%d-%df left)", x, y, x-1, y);
	}
	if ( nf[x][y+1] ) {
	  printf("\n      (adjacent f%d-%df f%d-%df down)", x, y, x, y+1);
	}
	if ( nf[x][y-1] ) {
	  printf("\n      (adjacent f%d-%df f%d-%df up)", x, y, x, y-1);
	}
      }
    }
  }

  printf("\n");
  for ( y = 0; y < gy; y++ ) {
    for ( x = 0; x < gx; x++ ) {
      if ( nf[x][y] && 
	   ( gf[x][y] == ' ' || gf[x][y] == '.' ) ) {
	printf("\n      (empty f%d-%df)", x, y);
      }
    }
  }
  
  printf("\n");
  nballs = 0;
  for ( y = 0; y < gy; y++ ) {
    for ( x = 0; x < gx; x++ ) {
      if ( nf[x][y] && gf[x][y] == '$' ) {
	printf("\n      (at ball%d f%d-%df)", nballs++, x, y);
      }
    }
  }

  printf("\n");
  for ( y = 0; y < gy; y++ ) {
    for ( x = 0; x < gx; x++ ) {
      if ( nf[x][y] && gf[x][y] == '@' ) {
	printf("\n      (at-robot f%d-%df)", x, y);
	break;
      }
    }
    if ( x < gx ) break;
  }

  printf("\n   )\n");


  printf("\n   (:goal");
  printf("\n      (and");

  printf("\n");
  nballs = 0;
  for ( y = 0; y < gy; y++ ) {
    for ( x = 0; x < gx; x++ ) {
      if ( nf[x][y] && gf[x][y] == '.' ) {
	printf("\n      (at ball%d f%d-%df)", nballs++, x, y);
      }
    }
  }

  printf("\n      )");
  printf("\n   )");
  printf("\n)\n\n");

  exit( 0 );

}
  
  








void usage( void )

{

  printf("\nusage:\n");

  printf("\nOPTIONS   DESCRIPTIONS\n\n");
  printf("-d <str>    name of input data file\n\n");

}



Bool process_command_line( int argc, char *argv[] )

{

  char option;

  gdata = NULL;

  while ( --argc && ++argv ) {
    if ( *argv[0] != '-' || strlen(*argv) != 2 ) {
      return FALSE;
    }
    option = *++argv[0];
    switch ( option ) {
    default:
      if ( --argc && ++argv ) {
	switch ( option ) {
	case 'd':
	  gdata = ( char * ) calloc( MAX_LENGTH, sizeof( char ) );
	  strncpy( gdata, *argv, MAX_LENGTH );
	  break;
	default:
	  printf( "\n\nunknown option: %c entered\n\n", option );
	  return FALSE;
	}
      } else {
	return FALSE;
      }
    }
  }

  if ( !gdata ) {
    return FALSE;
  }

  return TRUE;

}



