(define (domain spacecraft0)
 (:requirements :strips :typing)
 (:types direction instrument quality)
 (:constants Earth - direction)
 (:predicates
   (pointing ?d - direction)
   (power_on ?i - instrument)
   (calibrated ?i - instrument)
   (have_image ?d - direction ?q - quality)
   (time_to_turn ?d1 ?d2 - direction ?t)
   (capability ?i - instrument ?q - quality)
   (calibration_target ?i - instrument ?d - direction)
   (power_required ?i - instrument ?p)
  )
 (:resources power)
 (:consumable fuel)

 (:action turn_to
   :parameters (?d_new - direction)
   :vars (?d_prev - direction)
   :precondition (and (pointing ?d_prev) (not (= ?d_prev ?d_new)))
   :effect (and (not (pointing ?d_prev)) (pointing ?d_new))
   :resources ((fuel 3.0))
   :delay ?t : (time_to_turn ?d_prev ?d_new ?t))

 (:action NOOP
   :parameters (?d - direction)
   :effect (pointing ?d)
   :resources ((fuel 0.5)))

 (:action switch_on
  :parameters (?i - instrument)
  :effect (and (power_on ?i) (not (calibrated ?i)))
  :resources ((power ?p : (power_required ?i ?p)))
  :delay 2.0)

 (:action NOOP
  :parameters (?i - instrument)
  :effect (power_on ?i)
  :resources ((power ?p : (power_required ?i ?p))))

 (:action calibrate
  :parameters (?i - instrument ?d - direction)
  :precondition (and (power_on ?i) (pointing ?d) (calibration_target ?i ?d))
  :effect (calibrated ?i)
  :delay 1.0)

 (:action take_image
  :parameters (?i - instrument ?q - quality ?d - direction)
  :precondition (and (power_on ?i) (calibrated ?i) (capability ?i ?q) (pointing ?d))
  :effect (have_image ?d ?q)
  :delay 1.0)
 )
