
;;;
;;; SOKOBAN TRANSLATED MAP:
;;;
;;; x: 9, y: 11
;;;
;;;     
;;; 
;;; ####
;;; #. #
;;; # $#
;;; #  #####
;;; # .$ @ #
;;; # .$ # #
;;; ###    #
;;;   ######
;;; 
;;; 


(define (problem translated-sokoban)
   (:domain typed-sokoban)
   (:objects
      up down left right - direction
      ball0 ball1 ball2 - ball
      f1-3f f2-3f 
      f1-4f f2-4f 
      f1-5f f2-5f 
      f1-6f f2-6f f3-6f f4-6f f5-6f f6-6f 
      f1-7f f2-7f f3-7f f4-7f f6-7f 
      f3-8f f4-8f f5-8f f6-8f - navigable
   )

   (:init

      (adjacent f1-3f f2-3f right)
      (adjacent f1-3f f1-4f down)
      (adjacent f2-3f f1-3f left)
      (adjacent f2-3f f2-4f down)
      (adjacent f1-4f f2-4f right)
      (adjacent f1-4f f1-5f down)
      (adjacent f1-4f f1-3f up)
      (adjacent f2-4f f1-4f left)
      (adjacent f2-4f f2-5f down)
      (adjacent f2-4f f2-3f up)
      (adjacent f1-5f f2-5f right)
      (adjacent f1-5f f1-6f down)
      (adjacent f1-5f f1-4f up)
      (adjacent f2-5f f1-5f left)
      (adjacent f2-5f f2-6f down)
      (adjacent f2-5f f2-4f up)
      (adjacent f1-6f f2-6f right)
      (adjacent f1-6f f1-7f down)
      (adjacent f1-6f f1-5f up)
      (adjacent f2-6f f3-6f right)
      (adjacent f2-6f f1-6f left)
      (adjacent f2-6f f2-7f down)
      (adjacent f2-6f f2-5f up)
      (adjacent f3-6f f4-6f right)
      (adjacent f3-6f f2-6f left)
      (adjacent f3-6f f3-7f down)
      (adjacent f4-6f f5-6f right)
      (adjacent f4-6f f3-6f left)
      (adjacent f4-6f f4-7f down)
      (adjacent f5-6f f6-6f right)
      (adjacent f5-6f f4-6f left)
      (adjacent f6-6f f5-6f left)
      (adjacent f6-6f f6-7f down)
      (adjacent f1-7f f2-7f right)
      (adjacent f1-7f f1-6f up)
      (adjacent f2-7f f3-7f right)
      (adjacent f2-7f f1-7f left)
      (adjacent f2-7f f2-6f up)
      (adjacent f3-7f f4-7f right)
      (adjacent f3-7f f2-7f left)
      (adjacent f3-7f f3-8f down)
      (adjacent f3-7f f3-6f up)
      (adjacent f4-7f f3-7f left)
      (adjacent f4-7f f4-8f down)
      (adjacent f4-7f f4-6f up)
      (adjacent f6-7f f6-8f down)
      (adjacent f6-7f f6-6f up)
      (adjacent f3-8f f4-8f right)
      (adjacent f3-8f f3-7f up)
      (adjacent f4-8f f5-8f right)
      (adjacent f4-8f f3-8f left)
      (adjacent f4-8f f4-7f up)
      (adjacent f5-8f f6-8f right)
      (adjacent f5-8f f4-8f left)
      (adjacent f6-8f f5-8f left)
      (adjacent f6-8f f6-7f up)

      (empty f1-3f)
      (empty f2-3f)
      (empty f1-4f)
      (empty f1-5f)
      (empty f2-5f)
      (empty f1-6f)
      (empty f2-6f)
      (empty f4-6f)
      (empty f6-6f)
      (empty f1-7f)
      (empty f2-7f)
      (empty f4-7f)
      (empty f6-7f)
      (empty f3-8f)
      (empty f4-8f)
      (empty f5-8f)
      (empty f6-8f)

      (at ball0 f2-4f)
      (at ball1 f3-6f)
      (at ball2 f3-7f)

      (at-robot f5-6f)
   )

   (:goal
      (and

      (at ball0 f1-3f)
      (at ball1 f2-6f)
      (at ball2 f2-7f)
      )
   )
)

