
;;;
;;; SOKOBAN TRANSLATED MAP:
;;;
;;; x: 9, y: 10
;;;
;;;     
;;; 
;;; ########
;;; #   #  #
;;; # #.$ $#
;;; #   $  #
;;; #####. #
;;;   #   @#
;;;   #   .#
;;;   ######
;;; 


(define (problem translated-sokoban)
   (:domain typed-sokoban)
   (:objects
      up down left right - direction
      ball0 ball1 ball2 - ball
      f1-3f f2-3f f3-3f f5-3f f6-3f 
      f1-4f f3-4f f4-4f f5-4f f6-4f 
      f1-5f f2-5f f3-5f f4-5f f5-5f f6-5f 
      f5-6f f6-6f 
      f3-7f f4-7f f5-7f f6-7f 
      f3-8f f4-8f f5-8f f6-8f - navigable
   )

   (:init

      (adjacent f1-3f f2-3f right)
      (adjacent f1-3f f1-4f down)
      (adjacent f2-3f f3-3f right)
      (adjacent f2-3f f1-3f left)
      (adjacent f3-3f f2-3f left)
      (adjacent f3-3f f3-4f down)
      (adjacent f5-3f f6-3f right)
      (adjacent f5-3f f5-4f down)
      (adjacent f6-3f f5-3f left)
      (adjacent f6-3f f6-4f down)
      (adjacent f1-4f f1-5f down)
      (adjacent f1-4f f1-3f up)
      (adjacent f3-4f f4-4f right)
      (adjacent f3-4f f3-5f down)
      (adjacent f3-4f f3-3f up)
      (adjacent f4-4f f5-4f right)
      (adjacent f4-4f f3-4f left)
      (adjacent f4-4f f4-5f down)
      (adjacent f5-4f f6-4f right)
      (adjacent f5-4f f4-4f left)
      (adjacent f5-4f f5-5f down)
      (adjacent f5-4f f5-3f up)
      (adjacent f6-4f f5-4f left)
      (adjacent f6-4f f6-5f down)
      (adjacent f6-4f f6-3f up)
      (adjacent f1-5f f2-5f right)
      (adjacent f1-5f f1-4f up)
      (adjacent f2-5f f3-5f right)
      (adjacent f2-5f f1-5f left)
      (adjacent f3-5f f4-5f right)
      (adjacent f3-5f f2-5f left)
      (adjacent f3-5f f3-4f up)
      (adjacent f4-5f f5-5f right)
      (adjacent f4-5f f3-5f left)
      (adjacent f4-5f f4-4f up)
      (adjacent f5-5f f6-5f right)
      (adjacent f5-5f f4-5f left)
      (adjacent f5-5f f5-6f down)
      (adjacent f5-5f f5-4f up)
      (adjacent f6-5f f5-5f left)
      (adjacent f6-5f f6-6f down)
      (adjacent f6-5f f6-4f up)
      (adjacent f5-6f f6-6f right)
      (adjacent f5-6f f5-7f down)
      (adjacent f5-6f f5-5f up)
      (adjacent f6-6f f5-6f left)
      (adjacent f6-6f f6-7f down)
      (adjacent f6-6f f6-5f up)
      (adjacent f3-7f f4-7f right)
      (adjacent f3-7f f3-8f down)
      (adjacent f4-7f f5-7f right)
      (adjacent f4-7f f3-7f left)
      (adjacent f4-7f f4-8f down)
      (adjacent f5-7f f6-7f right)
      (adjacent f5-7f f4-7f left)
      (adjacent f5-7f f5-8f down)
      (adjacent f5-7f f5-6f up)
      (adjacent f6-7f f5-7f left)
      (adjacent f6-7f f6-8f down)
      (adjacent f6-7f f6-6f up)
      (adjacent f3-8f f4-8f right)
      (adjacent f3-8f f3-7f up)
      (adjacent f4-8f f5-8f right)
      (adjacent f4-8f f3-8f left)
      (adjacent f4-8f f4-7f up)
      (adjacent f5-8f f6-8f right)
      (adjacent f5-8f f4-8f left)
      (adjacent f5-8f f5-7f up)
      (adjacent f6-8f f5-8f left)
      (adjacent f6-8f f6-7f up)

      (empty f1-3f)
      (empty f2-3f)
      (empty f3-3f)
      (empty f5-3f)
      (empty f6-3f)
      (empty f1-4f)
      (empty f3-4f)
      (empty f5-4f)
      (empty f1-5f)
      (empty f2-5f)
      (empty f3-5f)
      (empty f5-5f)
      (empty f6-5f)
      (empty f5-6f)
      (empty f6-6f)
      (empty f3-7f)
      (empty f4-7f)
      (empty f5-7f)
      (empty f3-8f)
      (empty f4-8f)
      (empty f5-8f)
      (empty f6-8f)

      (at ball0 f4-4f)
      (at ball1 f6-4f)
      (at ball2 f4-5f)

      (at-robot f6-7f)
   )

   (:goal
      (and

      (at ball0 f3-4f)
      (at ball1 f5-6f)
      (at ball2 f6-8f)
      )
   )
)

