
;;;
;;; SOKOBAN TRANSLATED MAP:
;;;
;;; x: 8, y: 10
;;;
;;;     
;;; 
;;; #####
;;; #   ###
;;; #  $  #
;;; ##$$ .#
;;;  #@ . #
;;;  ## # #
;;;   #  .#
;;;   #####
;;; 


(define (problem translated-sokoban)
   (:domain typed-sokoban)
   (:objects
      up down left right - direction
      ball0 ball1 ball2 - ball
      f1-3f f2-3f f3-3f 
      f1-4f f2-4f f3-4f f4-4f f5-4f 
      f2-5f f3-5f f4-5f f5-5f 
      f2-6f f3-6f f4-6f f5-6f 
      f3-7f f5-7f 
      f3-8f f4-8f f5-8f - navigable
   )

   (:init

      (adjacent f1-3f f2-3f right)
      (adjacent f1-3f f1-4f down)
      (adjacent f2-3f f3-3f right)
      (adjacent f2-3f f1-3f left)
      (adjacent f2-3f f2-4f down)
      (adjacent f3-3f f2-3f left)
      (adjacent f3-3f f3-4f down)
      (adjacent f1-4f f2-4f right)
      (adjacent f1-4f f1-3f up)
      (adjacent f2-4f f3-4f right)
      (adjacent f2-4f f1-4f left)
      (adjacent f2-4f f2-5f down)
      (adjacent f2-4f f2-3f up)
      (adjacent f3-4f f4-4f right)
      (adjacent f3-4f f2-4f left)
      (adjacent f3-4f f3-5f down)
      (adjacent f3-4f f3-3f up)
      (adjacent f4-4f f5-4f right)
      (adjacent f4-4f f3-4f left)
      (adjacent f4-4f f4-5f down)
      (adjacent f5-4f f4-4f left)
      (adjacent f5-4f f5-5f down)
      (adjacent f2-5f f3-5f right)
      (adjacent f2-5f f2-6f down)
      (adjacent f2-5f f2-4f up)
      (adjacent f3-5f f4-5f right)
      (adjacent f3-5f f2-5f left)
      (adjacent f3-5f f3-6f down)
      (adjacent f3-5f f3-4f up)
      (adjacent f4-5f f5-5f right)
      (adjacent f4-5f f3-5f left)
      (adjacent f4-5f f4-6f down)
      (adjacent f4-5f f4-4f up)
      (adjacent f5-5f f4-5f left)
      (adjacent f5-5f f5-6f down)
      (adjacent f5-5f f5-4f up)
      (adjacent f2-6f f3-6f right)
      (adjacent f2-6f f2-5f up)
      (adjacent f3-6f f4-6f right)
      (adjacent f3-6f f2-6f left)
      (adjacent f3-6f f3-7f down)
      (adjacent f3-6f f3-5f up)
      (adjacent f4-6f f5-6f right)
      (adjacent f4-6f f3-6f left)
      (adjacent f4-6f f4-5f up)
      (adjacent f5-6f f4-6f left)
      (adjacent f5-6f f5-7f down)
      (adjacent f5-6f f5-5f up)
      (adjacent f3-7f f3-8f down)
      (adjacent f3-7f f3-6f up)
      (adjacent f5-7f f5-8f down)
      (adjacent f5-7f f5-6f up)
      (adjacent f3-8f f4-8f right)
      (adjacent f3-8f f3-7f up)
      (adjacent f4-8f f5-8f right)
      (adjacent f4-8f f3-8f left)
      (adjacent f5-8f f4-8f left)
      (adjacent f5-8f f5-7f up)

      (empty f1-3f)
      (empty f2-3f)
      (empty f3-3f)
      (empty f1-4f)
      (empty f2-4f)
      (empty f4-4f)
      (empty f5-4f)
      (empty f4-5f)
      (empty f5-5f)
      (empty f3-6f)
      (empty f4-6f)
      (empty f5-6f)
      (empty f3-7f)
      (empty f5-7f)
      (empty f3-8f)
      (empty f4-8f)
      (empty f5-8f)

      (at ball0 f3-4f)
      (at ball1 f2-5f)
      (at ball2 f3-5f)

      (at-robot f2-6f)
   )

   (:goal
      (and

      (at ball0 f5-5f)
      (at ball1 f4-6f)
      (at ball2 f5-8f)
      )
   )
)

