
;;;
;;; SOKOBAN TRANSLATED MAP:
;;;
;;; x: 8, y: 10
;;;
;;;    
;;; 
;;;    ####
;;; #### @#
;;; #   $ #
;;; #     #
;;; ## .###
;;;  #$ #
;;;  # .#
;;;  ####
;;; 


(define (problem translated-sokoban)
   (:domain typed-sokoban)
   (:objects
      up down left right - direction
      ball0 ball1 - ball
      f4-3f f5-3f 
      f1-4f f2-4f f3-4f f4-4f f5-4f 
      f1-5f f2-5f f3-5f f4-5f f5-5f 
      f2-6f f3-6f 
      f2-7f f3-7f 
      f2-8f f3-8f - navigable
   )

   (:init

      (adjacent f4-3f f5-3f right)
      (adjacent f4-3f f4-4f down)
      (adjacent f5-3f f4-3f left)
      (adjacent f5-3f f5-4f down)
      (adjacent f1-4f f2-4f right)
      (adjacent f1-4f f1-5f down)
      (adjacent f2-4f f3-4f right)
      (adjacent f2-4f f1-4f left)
      (adjacent f2-4f f2-5f down)
      (adjacent f3-4f f4-4f right)
      (adjacent f3-4f f2-4f left)
      (adjacent f3-4f f3-5f down)
      (adjacent f4-4f f5-4f right)
      (adjacent f4-4f f3-4f left)
      (adjacent f4-4f f4-5f down)
      (adjacent f4-4f f4-3f up)
      (adjacent f5-4f f4-4f left)
      (adjacent f5-4f f5-5f down)
      (adjacent f5-4f f5-3f up)
      (adjacent f1-5f f2-5f right)
      (adjacent f1-5f f1-4f up)
      (adjacent f2-5f f3-5f right)
      (adjacent f2-5f f1-5f left)
      (adjacent f2-5f f2-6f down)
      (adjacent f2-5f f2-4f up)
      (adjacent f3-5f f4-5f right)
      (adjacent f3-5f f2-5f left)
      (adjacent f3-5f f3-6f down)
      (adjacent f3-5f f3-4f up)
      (adjacent f4-5f f5-5f right)
      (adjacent f4-5f f3-5f left)
      (adjacent f4-5f f4-4f up)
      (adjacent f5-5f f4-5f left)
      (adjacent f5-5f f5-4f up)
      (adjacent f2-6f f3-6f right)
      (adjacent f2-6f f2-7f down)
      (adjacent f2-6f f2-5f up)
      (adjacent f3-6f f2-6f left)
      (adjacent f3-6f f3-7f down)
      (adjacent f3-6f f3-5f up)
      (adjacent f2-7f f3-7f right)
      (adjacent f2-7f f2-8f down)
      (adjacent f2-7f f2-6f up)
      (adjacent f3-7f f2-7f left)
      (adjacent f3-7f f3-8f down)
      (adjacent f3-7f f3-6f up)
      (adjacent f2-8f f3-8f right)
      (adjacent f2-8f f2-7f up)
      (adjacent f3-8f f2-8f left)
      (adjacent f3-8f f3-7f up)

      (empty f4-3f)
      (empty f1-4f)
      (empty f2-4f)
      (empty f3-4f)
      (empty f5-4f)
      (empty f1-5f)
      (empty f2-5f)
      (empty f3-5f)
      (empty f4-5f)
      (empty f5-5f)
      (empty f2-6f)
      (empty f3-6f)
      (empty f3-7f)
      (empty f2-8f)
      (empty f3-8f)

      (at ball0 f4-4f)
      (at ball1 f2-7f)

      (at-robot f5-3f)
   )

   (:goal
      (and

      (at ball0 f3-6f)
      (at ball1 f3-8f)
      )
   )
)

