
;;;
;;; SOKOBAN TRANSLATED MAP:
;;;
;;; x: 9, y: 11
;;;
;;;     
;;; 
;;;     ####
;;;     #  #
;;;   ###$.#
;;;   #  . #
;;; ###  #.#
;;; # $  $ #
;;; #   #@ #
;;; ########
;;; 
;;; 


(define (problem translated-sokoban)
   (:domain typed-sokoban)
   (:objects
      up down left right - direction
      ball0 ball1 ball2 - ball
      f5-3f f6-3f 
      f5-4f f6-4f 
      f3-5f f4-5f f5-5f f6-5f 
      f3-6f f4-6f f6-6f 
      f1-7f f2-7f f3-7f f4-7f f5-7f f6-7f 
      f1-8f f2-8f f3-8f f5-8f f6-8f - navigable
   )

   (:init

      (adjacent f5-3f f6-3f right)
      (adjacent f5-3f f5-4f down)
      (adjacent f6-3f f5-3f left)
      (adjacent f6-3f f6-4f down)
      (adjacent f5-4f f6-4f right)
      (adjacent f5-4f f5-5f down)
      (adjacent f5-4f f5-3f up)
      (adjacent f6-4f f5-4f left)
      (adjacent f6-4f f6-5f down)
      (adjacent f6-4f f6-3f up)
      (adjacent f3-5f f4-5f right)
      (adjacent f3-5f f3-6f down)
      (adjacent f4-5f f5-5f right)
      (adjacent f4-5f f3-5f left)
      (adjacent f4-5f f4-6f down)
      (adjacent f5-5f f6-5f right)
      (adjacent f5-5f f4-5f left)
      (adjacent f5-5f f5-4f up)
      (adjacent f6-5f f5-5f left)
      (adjacent f6-5f f6-6f down)
      (adjacent f6-5f f6-4f up)
      (adjacent f3-6f f4-6f right)
      (adjacent f3-6f f3-7f down)
      (adjacent f3-6f f3-5f up)
      (adjacent f4-6f f3-6f left)
      (adjacent f4-6f f4-7f down)
      (adjacent f4-6f f4-5f up)
      (adjacent f6-6f f6-7f down)
      (adjacent f6-6f f6-5f up)
      (adjacent f1-7f f2-7f right)
      (adjacent f1-7f f1-8f down)
      (adjacent f2-7f f3-7f right)
      (adjacent f2-7f f1-7f left)
      (adjacent f2-7f f2-8f down)
      (adjacent f3-7f f4-7f right)
      (adjacent f3-7f f2-7f left)
      (adjacent f3-7f f3-8f down)
      (adjacent f3-7f f3-6f up)
      (adjacent f4-7f f5-7f right)
      (adjacent f4-7f f3-7f left)
      (adjacent f4-7f f4-6f up)
      (adjacent f5-7f f6-7f right)
      (adjacent f5-7f f4-7f left)
      (adjacent f5-7f f5-8f down)
      (adjacent f6-7f f5-7f left)
      (adjacent f6-7f f6-8f down)
      (adjacent f6-7f f6-6f up)
      (adjacent f1-8f f2-8f right)
      (adjacent f1-8f f1-7f up)
      (adjacent f2-8f f3-8f right)
      (adjacent f2-8f f1-8f left)
      (adjacent f2-8f f2-7f up)
      (adjacent f3-8f f2-8f left)
      (adjacent f3-8f f3-7f up)
      (adjacent f5-8f f6-8f right)
      (adjacent f5-8f f5-7f up)
      (adjacent f6-8f f5-8f left)
      (adjacent f6-8f f6-7f up)

      (empty f5-3f)
      (empty f6-3f)
      (empty f6-4f)
      (empty f3-5f)
      (empty f4-5f)
      (empty f5-5f)
      (empty f6-5f)
      (empty f3-6f)
      (empty f4-6f)
      (empty f6-6f)
      (empty f1-7f)
      (empty f3-7f)
      (empty f4-7f)
      (empty f6-7f)
      (empty f1-8f)
      (empty f2-8f)
      (empty f3-8f)
      (empty f6-8f)

      (at ball0 f5-4f)
      (at ball1 f2-7f)
      (at ball2 f5-7f)

      (at-robot f5-8f)
   )

   (:goal
      (and

      (at ball0 f6-4f)
      (at ball1 f5-5f)
      (at ball2 f6-6f)
      )
   )
)

