
;;;
;;; SOKOBAN TRANSLATED MAP:
;;;
;;; x: 8, y: 9
;;;
;;;     
;;; 
;;;   #####
;;;   #   #
;;;   # #.#
;;; ###  .#
;;; #@ $$ #
;;; #  .$ #
;;; #######
;;; 


(define (problem translated-sokoban)
   (:domain typed-sokoban)
   (:objects
      up down left right - direction
      ball0 ball1 ball2 - ball
      f3-3f f4-3f f5-3f 
      f3-4f f5-4f 
      f3-5f f4-5f f5-5f 
      f1-6f f2-6f f3-6f f4-6f f5-6f 
      f1-7f f2-7f f3-7f f4-7f f5-7f - navigable
   )

   (:init

      (adjacent f3-3f f4-3f right)
      (adjacent f3-3f f3-4f down)
      (adjacent f4-3f f5-3f right)
      (adjacent f4-3f f3-3f left)
      (adjacent f5-3f f4-3f left)
      (adjacent f5-3f f5-4f down)
      (adjacent f3-4f f3-5f down)
      (adjacent f3-4f f3-3f up)
      (adjacent f5-4f f5-5f down)
      (adjacent f5-4f f5-3f up)
      (adjacent f3-5f f4-5f right)
      (adjacent f3-5f f3-6f down)
      (adjacent f3-5f f3-4f up)
      (adjacent f4-5f f5-5f right)
      (adjacent f4-5f f3-5f left)
      (adjacent f4-5f f4-6f down)
      (adjacent f5-5f f4-5f left)
      (adjacent f5-5f f5-6f down)
      (adjacent f5-5f f5-4f up)
      (adjacent f1-6f f2-6f right)
      (adjacent f1-6f f1-7f down)
      (adjacent f2-6f f3-6f right)
      (adjacent f2-6f f1-6f left)
      (adjacent f2-6f f2-7f down)
      (adjacent f3-6f f4-6f right)
      (adjacent f3-6f f2-6f left)
      (adjacent f3-6f f3-7f down)
      (adjacent f3-6f f3-5f up)
      (adjacent f4-6f f5-6f right)
      (adjacent f4-6f f3-6f left)
      (adjacent f4-6f f4-7f down)
      (adjacent f4-6f f4-5f up)
      (adjacent f5-6f f4-6f left)
      (adjacent f5-6f f5-7f down)
      (adjacent f5-6f f5-5f up)
      (adjacent f1-7f f2-7f right)
      (adjacent f1-7f f1-6f up)
      (adjacent f2-7f f3-7f right)
      (adjacent f2-7f f1-7f left)
      (adjacent f2-7f f2-6f up)
      (adjacent f3-7f f4-7f right)
      (adjacent f3-7f f2-7f left)
      (adjacent f3-7f f3-6f up)
      (adjacent f4-7f f5-7f right)
      (adjacent f4-7f f3-7f left)
      (adjacent f4-7f f4-6f up)
      (adjacent f5-7f f4-7f left)
      (adjacent f5-7f f5-6f up)

      (empty f3-3f)
      (empty f4-3f)
      (empty f5-3f)
      (empty f3-4f)
      (empty f5-4f)
      (empty f3-5f)
      (empty f4-5f)
      (empty f5-5f)
      (empty f2-6f)
      (empty f5-6f)
      (empty f1-7f)
      (empty f2-7f)
      (empty f3-7f)
      (empty f5-7f)

      (at ball0 f3-6f)
      (at ball1 f4-6f)
      (at ball2 f4-7f)

      (at-robot f1-6f)
   )

   (:goal
      (and

      (at ball0 f5-4f)
      (at ball1 f5-5f)
      (at ball2 f3-7f)
      )
   )
)

