
;;;
;;; SOKOBAN TRANSLATED MAP:
;;;
;;; x: 9, y: 10
;;;
;;;     
;;; 
;;;  ######
;;;  #  .@##
;;;  #   $.#
;;;  ### # #
;;; ##     #
;;; #  $  ##
;;; #   ###
;;; #####
;;; 


(define (problem translated-sokoban)
   (:domain typed-sokoban)
   (:objects
      up down left right - direction
      ball0 ball1 - ball
      f2-3f f3-3f f4-3f f5-3f 
      f2-4f f3-4f f4-4f f5-4f f6-4f 
      f4-5f f6-5f 
      f2-6f f3-6f f4-6f f5-6f f6-6f 
      f1-7f f2-7f f3-7f f4-7f f5-7f 
      f1-8f f2-8f f3-8f - navigable
   )

   (:init

      (adjacent f2-3f f3-3f right)
      (adjacent f2-3f f2-4f down)
      (adjacent f3-3f f4-3f right)
      (adjacent f3-3f f2-3f left)
      (adjacent f3-3f f3-4f down)
      (adjacent f4-3f f5-3f right)
      (adjacent f4-3f f3-3f left)
      (adjacent f4-3f f4-4f down)
      (adjacent f5-3f f4-3f left)
      (adjacent f5-3f f5-4f down)
      (adjacent f2-4f f3-4f right)
      (adjacent f2-4f f2-3f up)
      (adjacent f3-4f f4-4f right)
      (adjacent f3-4f f2-4f left)
      (adjacent f3-4f f3-3f up)
      (adjacent f4-4f f5-4f right)
      (adjacent f4-4f f3-4f left)
      (adjacent f4-4f f4-5f down)
      (adjacent f4-4f f4-3f up)
      (adjacent f5-4f f6-4f right)
      (adjacent f5-4f f4-4f left)
      (adjacent f5-4f f5-3f up)
      (adjacent f6-4f f5-4f left)
      (adjacent f6-4f f6-5f down)
      (adjacent f4-5f f4-6f down)
      (adjacent f4-5f f4-4f up)
      (adjacent f6-5f f6-6f down)
      (adjacent f6-5f f6-4f up)
      (adjacent f2-6f f3-6f right)
      (adjacent f2-6f f2-7f down)
      (adjacent f3-6f f4-6f right)
      (adjacent f3-6f f2-6f left)
      (adjacent f3-6f f3-7f down)
      (adjacent f4-6f f5-6f right)
      (adjacent f4-6f f3-6f left)
      (adjacent f4-6f f4-7f down)
      (adjacent f4-6f f4-5f up)
      (adjacent f5-6f f6-6f right)
      (adjacent f5-6f f4-6f left)
      (adjacent f5-6f f5-7f down)
      (adjacent f6-6f f5-6f left)
      (adjacent f6-6f f6-5f up)
      (adjacent f1-7f f2-7f right)
      (adjacent f1-7f f1-8f down)
      (adjacent f2-7f f3-7f right)
      (adjacent f2-7f f1-7f left)
      (adjacent f2-7f f2-8f down)
      (adjacent f2-7f f2-6f up)
      (adjacent f3-7f f4-7f right)
      (adjacent f3-7f f2-7f left)
      (adjacent f3-7f f3-8f down)
      (adjacent f3-7f f3-6f up)
      (adjacent f4-7f f5-7f right)
      (adjacent f4-7f f3-7f left)
      (adjacent f4-7f f4-6f up)
      (adjacent f5-7f f4-7f left)
      (adjacent f5-7f f5-6f up)
      (adjacent f1-8f f2-8f right)
      (adjacent f1-8f f1-7f up)
      (adjacent f2-8f f3-8f right)
      (adjacent f2-8f f1-8f left)
      (adjacent f2-8f f2-7f up)
      (adjacent f3-8f f2-8f left)
      (adjacent f3-8f f3-7f up)

      (empty f2-3f)
      (empty f3-3f)
      (empty f4-3f)
      (empty f2-4f)
      (empty f3-4f)
      (empty f4-4f)
      (empty f6-4f)
      (empty f4-5f)
      (empty f6-5f)
      (empty f2-6f)
      (empty f3-6f)
      (empty f4-6f)
      (empty f5-6f)
      (empty f6-6f)
      (empty f1-7f)
      (empty f2-7f)
      (empty f4-7f)
      (empty f5-7f)
      (empty f1-8f)
      (empty f2-8f)
      (empty f3-8f)

      (at ball0 f5-4f)
      (at ball1 f3-7f)

      (at-robot f5-3f)
   )

   (:goal
      (and

      (at ball0 f4-3f)
      (at ball1 f6-4f)
      )
   )
)

